/*
 * Decompiled with CFR 0.152.
 */
package phelps.util;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phelps.awt.geom.Dimension2D_Double;
import phelps.lang.Strings;
import phelps.util.Arrayss;

public class Units {
    public static final int RANGE_INVALID = Integer.MIN_VALUE;
    private static final Matcher MATCHER_LENGTH;
    private static final Map<String, Double> length_;
    private static final Matcher PAPERMATCHER_;
    private static final Map<String, Dimension2D> paper_;
    private static final String[] KSUFFIX;
    private static final long[] KUNIT;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Units() {
    }

    public static double getLength(String string, String string2) throws NumberFormatException {
        Matcher matcher = MATCHER_LENGTH;
        matcher.reset(string);
        if (!matcher.find()) {
            return Double.MIN_VALUE;
        }
        double d = Double.parseDouble(matcher.group(1));
        String string3 = matcher.groupCount() == 2 ? matcher.group(2) : "px";
        double d2 = Units.convertLength(string3, string2);
        return d * d2;
    }

    public static double convertLength(String string, String string2) {
        Double d = length_.get(string.trim().toLowerCase());
        Double d2 = length_.get(string2.trim().toLowerCase());
        if (!$assertionsDisabled && d == null) {
            throw new AssertionError(d);
        }
        if (!$assertionsDisabled && d2 == null) {
            throw new AssertionError(d2);
        }
        return d / d2;
    }

    public static void addLength(String string, String string2, String string3, double d) {
        if (!($assertionsDisabled || string3 != null && d != 0.0)) {
            throw new AssertionError();
        }
        Double d2 = new Double(d);
        length_.put(string.trim().toLowerCase(), d2);
        length_.put(string2.trim().toLowerCase(), d2);
        length_.put(string3.trim().toLowerCase(), d2);
    }

    public static Dimension2D getPaperSize(String string, String string2) {
        double d;
        boolean bl = false;
        String string3 = Strings.removeWhitespace(string).toLowerCase();
        Dimension2D dimension2D = paper_.get(string3);
        if (dimension2D == null && string3.indexOf(120) != -1) {
            dimension2D = Units.computeWxH(string);
            if (string.endsWith("r")) {
                bl = true;
            }
        } else if (dimension2D == null && string3.endsWith("r")) {
            bl = true;
            string3 = string3.substring(0, string3.length() - 1);
            dimension2D = paper_.get(string3);
        }
        double d2 = dimension2D.getWidth();
        double d3 = dimension2D.getHeight();
        if (bl) {
            d = d2;
            d3 = d2 = d3;
        }
        d = Units.convertLength("mm", string2);
        return new Dimension2D_Double(d2 *= d, d3 *= d);
    }

    public static void addPaperSize(String string, String string2) {
        if (!($assertionsDisabled || string != null && string2 != null)) {
            throw new AssertionError();
        }
        paper_.put(string.toLowerCase(), Units.computeWxH(string2));
    }

    private static Dimension2D computeWxH(String string) {
        string = Strings.removeWhitespace(string);
        Matcher matcher = PAPERMATCHER_;
        matcher.reset(string);
        if (!matcher.find()) {
            return null;
        }
        double d = Double.parseDouble(matcher.group(1));
        double d2 = Double.parseDouble(matcher.group(2));
        double d3 = Units.convertLength(matcher.group(3), "mm");
        return new Dimension2D_Double(d * d3, d2 * d3);
    }

    public static String prettySize(long l) {
        if (l == 0L) {
            return "0 bytes";
        }
        if (l == 1L) {
            return "1 byte";
        }
        if (l == -1L) {
            return "-1 byte";
        }
        long l2 = l >= 0L ? 1 : -1;
        l = Math.abs(l);
        long l3 = 1024L;
        long l4 = 0L;
        long l5 = 0L;
        int n = 0;
        while (l > l3 && n + 1 < KSUFFIX.length) {
            l4 = l / l3;
            l5 = l - l4 * l3;
            l = l4;
            ++n;
        }
        return Long.toString(l2 * l) + (l5 > 0L ? "." : "") + (l <= 10L && l5 > 0L ? Long.toString(l5 * 10L / l3) : "") + " " + KSUFFIX[n];
    }

    public static long parseSize(String string) {
        char c;
        string = Strings.removeWhitespace(string);
        long l = 0L;
        int n = 0;
        int n2 = string.length();
        while (n < n2 && '0' <= (c = string.charAt(n)) && c <= '9') {
            l = l * 10L + (long)c - 48L;
        }
        while (n < n2 && Character.isWhitespace(string.charAt(48))) {
        }
        if (n < n2) {
            c = Character.toLowerCase(string.charAt(n));
            int n3 = c == 'k' ? 1 : (c == 'm' ? 2 : (c == 'g' ? 3 : (c == 't' ? 4 : (c == 'p' ? 5 : (c == 'e' ? 6 : 0)))));
            l *= KUNIT[n3];
        }
        return l;
    }

    public static String toRange(int[] nArray) {
        if (!$assertionsDisabled && nArray == null) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            stringBuffer.append(Integer.MIN_VALUE == n2 ? "b" : Integer.toString(n2));
            if (i + 1 < n) {
                int n3 = i + 1;
                int n4 = nArray[n3] - n2;
                ++n3;
                while (n3 < n && nArray[n3] - nArray[n3 - 1] == n4) {
                    ++n3;
                }
                int n5 = n3 - i;
                int n6 = nArray[n3 - 1];
                if (!$assertionsDisabled && n5 < 2) {
                    throw new AssertionError();
                }
                if (n5 != 2) {
                    if (n4 == 0) {
                        stringBuffer.append("*").append(n5);
                        i = i + n5 - 1;
                    } else if (Integer.MIN_VALUE != n2 && Integer.MIN_VALUE != n6) {
                        if (n4 == 1) {
                            stringBuffer.append("-").append(n6);
                            i = i + n5 - 1;
                        } else if (n5 >= 4) {
                            stringBuffer.append("-").append(n6);
                            if (n4 == 2 && n2 > 0) {
                                stringBuffer.append(n2 % 2 == 1 ? "%odd" : "%even");
                            } else if (n4 == -1) {
                                stringBuffer.append("%reverse");
                            } else {
                                stringBuffer.append("%").append(n4);
                            }
                            i = i + n5 - 1;
                        }
                    }
                }
            }
            stringBuffer.append(",");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    public static int[] parseRange(String string, int n, int n2) {
        Object object;
        int n3;
        if (string == null || string.length() == 0) {
            string = "all";
        }
        if ((n3 = (string = string.replace(';', ',')).lastIndexOf(47)) != -1) {
            string = string.substring(0, n3);
        }
        string = Strings.removeWhitespace(string);
        Object object2 = new int[n2 - n + 1];
        int n4 = 0;
        boolean bl = false;
        Object object3 = new StringTokenizer(string, ", ");
        while (((StringTokenizer)object3).hasMoreElements()) {
            object = ((StringTokenizer)object3).nextToken().toLowerCase();
            if (((String)object).length() == 0) continue;
            try {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10 = 1;
                String string2 = null;
                int n11 = ((String)object).lastIndexOf(37);
                if (n11 != -1) {
                    string2 = ((String)object).substring(n11 + 1);
                    object = ((String)object).substring(0, n11);
                }
                n3 = ((String)object).indexOf(45);
                if (((String)object).startsWith("back")) {
                    bl = true;
                    continue;
                }
                if ("all".equals(object)) {
                    n9 = n;
                    n8 = n2;
                } else if (((String)object).startsWith("rev")) {
                    n9 = n2;
                    n8 = n;
                } else if ("odd".equals(object)) {
                    n9 = n + (n % 2 == 0 ? 1 : 0);
                    n8 = n2;
                    n10 = 2;
                } else if ("even".equals(object)) {
                    n9 = n + (n % 2 == 0 ? 0 : 1);
                    n8 = n2;
                    n10 = 2;
                } else if (n3 == -1) {
                    n7 = ((String)object).charAt(0);
                    n9 = n7 == 45 || Character.isDigit((char)n7) ? Integer.parseInt((String)object) : ("first".equals(object) ? n : ("last".equals(object) ? n2 : Integer.MIN_VALUE));
                    n8 = n9;
                } else {
                    String string3 = ((String)object).substring(0, n3);
                    String string4 = ((String)object).substring(n3 + 1);
                    int n12 = "first".equals(string3) || "".equals(string3) ? n : (n9 = "end".equals(string3) || "last".equals(string3) ? n2 : Integer.parseInt(string3));
                    int n13 = "first".equals(string3) ? n : (n8 = "".equals(string4) || "end".equals(string4) || "last".equals(string4) ? n2 : Integer.parseInt(string4));
                }
                int n14 = n9 == Integer.MIN_VALUE ? n9 : (n9 < n ? n : (n9 = n9 > n2 ? n2 : n9));
                int n15 = n8 == Integer.MIN_VALUE ? n8 : (n8 < n ? n : (n8 = n8 > n2 ? n2 : n8));
                if (string2 != null) {
                    if (string2.startsWith("odd")) {
                        n10 = 2;
                        if (n9 % 2 == 0) {
                            ++n9;
                        }
                    } else if (string2.startsWith("even")) {
                        n10 = 2;
                        if (n9 % 2 != 0) {
                            ++n9;
                        }
                    } else if (string2.startsWith("rev")) {
                        n7 = n9;
                        n9 = n8;
                        n8 = n7;
                    } else {
                        n10 = Integer.parseInt(string2);
                    }
                }
                n7 = Math.abs(n10);
                int n16 = n6 = n9 == n8 ? n7 : Math.abs(n8 - n9) / n7 + 1;
                if (n6 + n4 >= ((int[])object2).length) {
                    object2 = Arrayss.resize(object2, n6 + ((int[])object2).length * 2);
                }
                if (n9 == n8) {
                    for (n5 = 0; n5 < n10; ++n5) {
                        object2[n4++] = n9;
                    }
                    continue;
                }
                if (n9 <= n8) {
                    for (n5 = n9; n5 <= n8; n5 += n7) {
                        object2[n4++] = n5;
                    }
                    continue;
                }
                for (n5 = n9; n5 >= n8; n5 -= n7) {
                    object2[n4++] = n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(numberFormatException);
            }
        }
        object2 = Arrayss.resize(object2, n4);
        if (bl && n4 >= 1) {
            object3 = (int[])object2.clone();
            Arrays.sort((int[])object3);
            object = new int[n4];
            for (int i = 0; i < n4; ++i) {
                object[Arrays.binarySearch((int[])object3, (int)object2[i])] = i + 1;
            }
            object2 = object;
        }
        return object2;
    }

    public static int[][] parseRanges(String string, int n, int n2) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = -1;
            int n4 = string2.lastIndexOf(47);
            if (n4 != -1) {
                try {
                    n3 = Integer.parseInt(string2.substring(n4 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                n4 = string2.indexOf(47);
                string2 = string2.substring(0, n4);
            }
            int[] nArray = Units.parseRange(string2, n, n2);
            if (n3 > 0) {
                int n5 = nArray.length;
                for (int i = 0; i < n5; i += n3) {
                    arrayList.add(Arrayss.subset(nArray, i, Math.min(n3, n5 - i)));
                }
                continue;
            }
            arrayList.add(nArray);
        }
        return (int[][])arrayList.toArray((T[])new int[arrayList.size()][]);
    }

    static {
        int n;
        $assertionsDisabled = !Units.class.desiredAssertionStatus();
        MATCHER_LENGTH = Pattern.compile("([-+0-9.]+)\\s*(\\w+)?").matcher("");
        length_ = new HashMap<String, Double>();
        String[] stringArray = new String[]{"meter", "meters", "m", "centimeter", "centimeters", "cm", "millimeter", "millimeters", "mm", "inch", "inches", "in", "foot", "feet", "ft", "mile", "miles", "mile", "point", "points", "pt", "scaled point", "scaled point", "sp", "big point", "big points", "bp", "pica", "picas", "pc", "didot", "didots", "dd", "cicero", "ciceros", "cc"};
        double[] dArray = new double[]{1.0, 0.01, 0.001, 0.0254, 0.30479999999999996, 1609.3439999999998, 3.5145980351459805E-4, 3.875732421875E-7, 3.5277777777777776E-4, 0.004233333333333333, 3.760650274425863E-4, 0.004512780329311035};
        if (!$assertionsDisabled && stringArray.length != 3 * dArray.length) {
            throw new AssertionError();
        }
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            Units.addLength(stringArray[n * 3], stringArray[n * 3 + 1], stringArray[n * 3 + 2], dArray[n]);
        }
        n = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
        Units.addLength("pixel", "pixels", "px", 0.0254 / (double)n);
        PAPERMATCHER_ = Pattern.compile("([0-9.]+)\\s*x\\s*([0-9.]+)\\s*(\\w+)").matcher("");
        paper_ = new HashMap<String, Dimension2D>();
        stringArray = new String[]{"US", "8.5x11in", "letter", "8.5x11in", "legal", "8.5x14in", "foolscap", "13.5x17in", "4A0", "1682x2378mm", "2A0", "1189x1682mm", "A0", "841x1189mm", "A1", "594x841mm", "A2", "420x594mm", "A3", "297x420mm", "A4", "210x297mm", "A5", "148x210mm", "A6", "105x148mm", "A7", "74x105mm", "A8", "52x74mm", "A9", "37x52mm", "A10", "26x37mm", "B0", "1000x1414mm", "B1", "707x1000mm", "B2", "500x707mm", "B3", "353x500mm", "B4", "250x353mm", "B5", "176x250mm", "B6", "125x176mm", "B7", "88x125mm", "B8", "62x88mm", "B9", "44x62mm", "B10", "31x44mm", "C0", "917x1297mm", "C1", "648x917mm", "C2", "458x648mm", "C3", "324x458mm", "C4", "229x324mm", "C5", "162x229mm", "C6", "114x162mm", "C7", "81x114mm", "C8", "57x81mm", "C9", "40x57mm", "C10", "28x40mm"};
        int n3 = stringArray.length;
        for (int i = 0; i < n3; i += 2) {
            Units.addPaperSize(stringArray[i], stringArray[i + 1]);
        }
        KSUFFIX = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB", "EB"};
        KUNIT = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L, 0x1000000000000000L};
    }
}

