/*
 * Decompiled with CFR 0.152.
 */
package phelps.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import multivalent.node.Root;
import multivalent.std.span.HyperlinkSpan;
import phelps.net.CrawlerDisplay;
import phelps.net.CrawlerThread;
import phelps.net.LinkRec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Crawler
extends Observable
implements Runnable {
    public boolean fTrace = false;
    public static final int PAGE = 0;
    public static final int SUBTREE = 1;
    public static final int SITE = 2;
    public static final int ANY = 3;
    int maxThreads_ = 20;
    int threadCnt_ = 0;
    int totalLinks = 0;
    int scope_ = 1;
    int maxDepth_ = Integer.MAX_VALUE;
    URL start_;
    Map<String, String> seen = new HashMap<String, String>(200);
    List<LinkRec> pool = new LinkedList<LinkRec>();
    List<LinkRec> active = new LinkedList<LinkRec>();
    CrawlerDisplay dis = new CrawlerDisplay(this.active);

    public Crawler(URL uRL) {
        this.start_ = uRL;
    }

    public void setMaxThreads(int n) {
        this.maxThreads_ = n;
    }

    public int getMaxThreads() {
        return this.maxThreads_;
    }

    public void setScope(int n) {
        this.scope_ = n;
    }

    public int getScope() {
        return this.scope_;
    }

    public void setMaxDepth(int n) {
        this.maxDepth_ = n;
    }

    public int getMaxDepth() {
        return this.maxDepth_;
    }

    synchronized void addLinks(Collection<HyperlinkSpan> collection, int n) {
        if (n >= this.maxDepth_) {
            return;
        }
        block7: for (HyperlinkSpan hyperlinkSpan : collection) {
            URL uRL = (URL)hyperlinkSpan.getTarget();
            String string = uRL.getProtocol();
            String string2 = uRL.getRef();
            if (string2 != null) {
                try {
                    uRL = new URL(string, uRL.getHost(), uRL.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            String string3 = uRL.toString();
            if (!"file".equals(string) && !"http".equals(string) || this.seen.get(string3) != null) continue;
            switch (this.scope_) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    if (this.start_.getHost().equals(uRL.getHost()) && uRL.getFile().indexOf(this.start_.getFile()) == 0) break;
                    continue block7;
                }
                case 2: {
                    if (this.start_.getHost().equals(uRL.getHost())) break;
                    continue block7;
                }
            }
            this.setChanged();
            this.notifyObservers(uRL);
            this.pool.add(new LinkRec(uRL, n));
            this.seen.put(string3, string3);
            ++this.totalLinks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void workerDone(LinkRec linkRec) {
        Object object = this.active;
        synchronized (object) {
            this.active.remove(linkRec);
        }
        --this.threadCnt_;
        if (linkRec != null) {
            this.setChanged();
            this.notifyObservers(linkRec.root);
        }
        if (this.fTrace) {
            System.out.println(new StringBuffer().append("").append(this.threadCnt_).append("/").append(Thread.currentThread().getThreadGroup().activeCount()).append(" threads, ").append(this.pool.size()).append(" links to go").toString());
        }
        while (this.pool.size() > 0 && this.threadCnt_ < this.maxThreads_) {
            object = this.pool.remove(0);
            List<LinkRec> list = this.active;
            synchronized (list) {
                this.active.add((LinkRec)object);
            }
            new CrawlerThread(this, (LinkRec)object).start();
            ++this.threadCnt_;
            if (!this.fTrace) continue;
            System.out.println(new StringBuffer().append("thread #").append(this.threadCnt_).append(": ").append(((LinkRec)object).url).toString());
        }
        if (this.pool.size() == 0 && this.threadCnt_ == 0) {
            System.out.println(new StringBuffer().append("Done -- scanned ").append(this.totalLinks).append(" pages").toString());
        }
        this.dis.repaint(200L);
    }

    @Override
    public void run() {
        this.pool.add(new LinkRec(this.start_, 0));
        this.threadCnt_ = 1;
        this.workerDone(null);
    }

    public static void main(String[] stringArray) {
        try {
            Crawler crawler = new Crawler(new URL(stringArray[0]));
            crawler.addObserver(crawler.new TestObserver());
            new Thread(crawler).start();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(new StringBuffer().append("bad URL: ").append(malformedURLException).toString());
        }
    }

    class CopyObserver
    implements Observer {
        CopyObserver() {
        }

        public void update(Observable observable, Object object) {
            if (object instanceof URL || object instanceof Root) {
                // empty if block
            }
        }
    }

    class TestObserver
    implements Observer {
        TestObserver() {
        }

        public void update(Observable observable, Object object) {
        }
    }
}

