/*
 * Decompiled with CFR 0.152.
 */
package phelps.math;

public class Matrix {
    static final boolean DEBUG = false;
    private double[][] x_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Matrix(int n, int n2) {
        if (!($assertionsDisabled || n >= 1 && n2 >= 1)) {
            throw new AssertionError();
        }
        this.x_ = new double[n][n2];
    }

    public Matrix(double[][] dArray) {
        this.x_ = dArray != null ? dArray : new double[0][0];
    }

    public Matrix(Matrix matrix) {
        this((double[][])matrix.x_.clone());
    }

    public int getRows() {
        return this.x_.length;
    }

    public int getCols() {
        return this.x_[0].length;
    }

    public double get(int n, int n2) {
        if (!($assertionsDisabled || 0 <= n && n <= this.getRows() && 0 <= n2 && n2 <= this.getCols())) {
            throw new AssertionError();
        }
        return this.x_[n][n2];
    }

    public void set(int n, int n2, double d) {
        if (!($assertionsDisabled || 0 <= n && n <= this.getRows() && 0 <= n2 && n2 <= this.getCols())) {
            throw new AssertionError();
        }
        this.x_[n][n2] = d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Matrix)) {
            return false;
        }
        Matrix matrix = (Matrix)object;
        int n = this.getRows();
        int n2 = this.getCols();
        if (n != matrix.getRows() || n2 != matrix.getCols()) {
            return false;
        }
        double[][] dArray = this.x_;
        double[][] dArray2 = matrix.x_;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (dArray[i][j] == dArray2[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.x_ != null ? (this.x_.length << 8) + this.x_[0].length : 0;
    }

    public Matrix transpose() {
        int n = this.getRows();
        int n2 = this.getCols();
        double[][] dArray = new double[n2][n];
        double[][] dArray2 = this.x_;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j][i] = dArray2[i][j];
            }
        }
        return new Matrix(dArray);
    }

    public Matrix invert() throws IllegalStateException {
        int n;
        int n2;
        int n3 = this.getRows();
        int n4 = this.getCols();
        double[][] dArray = this.x_;
        if (n3 == 2 && n4 == 2) {
            double d = dArray[0][0];
            double d2 = dArray[1][1];
            double d3 = dArray[0][1];
            double d4 = dArray[1][0];
            if (d * d2 - d3 * d4 == 0.0) {
                throw new IllegalStateException("matrix not invertable");
            }
            double[][] dArray2 = new double[2][2];
            return new Matrix(new double[][]{{d2, -d3}, {-d4, d}});
        }
        double[][] dArray3 = new double[n3][n4 * 2];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                dArray3[n2][n] = dArray[n2][n];
            }
        }
        n2 = 0;
        n = n4;
        while (n2 < n3) {
            dArray3[n2][n] = 1.0;
            ++n2;
            ++n;
        }
        this.solveGaussJordan(dArray3, n3, n4 * 2, n3);
        double[][] dArray4 = new double[n3][n4];
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n4; ++i) {
                dArray4[n][i] = dArray3[n][i + n4];
            }
        }
        return new Matrix(dArray4);
    }

    public double determinant() throws IllegalStateException {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        int n5 = this.getRows();
        if (n5 != (n4 = this.getCols())) {
            throw new IllegalStateException("only square matrices have determinants");
        }
        double[][] dArray = this.x_;
        double d2 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d = 1.0;
            n2 = 0;
            n = n3;
            while (n2 < n5) {
                if (n == n4) {
                    n = 0;
                }
                d *= dArray[n2][n];
                ++n2;
                ++n;
            }
            d2 += d;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            d = 1.0;
            n2 = 0;
            n = n3;
            while (n2 < n5) {
                if (n < 0) {
                    n = n4 - 1;
                }
                d *= dArray[n2][n];
                ++n2;
                --n;
            }
            d2 -= d;
        }
        return d2;
    }

    public Matrix add(Matrix matrix) throws IllegalArgumentException {
        int n = this.getRows();
        int n2 = this.getCols();
        if (matrix == null || n != matrix.getRows() || n2 != matrix.getCols()) {
            throw new IllegalArgumentException("matrices of different dimensions");
        }
        double[][] dArray = new double[n][n2];
        double[][] dArray2 = this.x_;
        double[][] dArray3 = matrix.x_;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = dArray2[i][j] + dArray3[i][j];
            }
        }
        return new Matrix(dArray);
    }

    public Matrix multiply(double d) {
        int n = this.getRows();
        int n2 = this.getCols();
        double[][] dArray = new double[n][n2];
        double[][] dArray2 = this.x_;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = dArray2[i][j] * d;
            }
        }
        return new Matrix(dArray);
    }

    public Matrix multiply(Matrix matrix) throws IllegalArgumentException {
        int n = this.getRows();
        int n2 = this.getCols();
        int n3 = matrix.getCols();
        if (matrix == null || n2 != matrix.getRows()) {
            throw new IllegalArgumentException("matrices of incompatible dimensions");
        }
        double[][] dArray = new double[n][n3];
        double[][] dArray2 = this.x_;
        double[][] dArray3 = matrix.x_;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 0; k < n2; ++k) {
                    d += dArray2[i][k] * dArray3[k][j];
                }
                dArray[i][j] = d;
            }
        }
        return new Matrix(dArray);
    }

    public double[] solveGaussJordan(int n) {
        return this.solveGaussJordan(this.x_, this.getRows(), this.getCols(), n);
    }

    double[] solveGaussJordan(double[][] dArray, int n, int n2, int n3) {
        int n4;
        if (!$assertionsDisabled && n >= n2) {
            throw new AssertionError((Object)(n + " >= " + n2));
        }
        for (int i = 0; i < n3; ++i) {
            n4 = -1;
            for (int j = i; j < n; ++j) {
                if (dArray[j][i] == 0.0) continue;
                n4 = j;
                break;
            }
            if (n4 == -1) continue;
            double[] dArray2 = dArray[n4];
            if (n4 != i) {
                dArray[n4] = dArray[i];
                dArray[i] = dArray2;
            }
            double d = 1.0 / dArray2[i];
            dArray2[i] = 1.0;
            int n5 = i + 1;
            while (n5 < n2) {
                int n6 = n5++;
                dArray2[n6] = dArray2[n6] * d;
            }
            for (n5 = 0; n5 < n; ++n5) {
                double[] dArray3 = dArray[n5];
                if (dArray3 == dArray2 || dArray3[i] == 0.0) continue;
                double d2 = dArray3[i];
                dArray3[i] = 0.0;
                for (int j = i + 1; j < n2; ++j) {
                    int n7 = j;
                    dArray3[n7] = dArray3[n7] - dArray2[j] * d2;
                }
            }
        }
        double[] dArray4 = new double[n];
        for (n4 = 0; n4 < n; ++n4) {
            dArray4[n4] = dArray[n4][n];
        }
        return dArray4;
    }

    public double[] maximize(double[] dArray) {
        int n;
        int n2;
        int n3 = dArray.length;
        int[] nArray = new int[n3];
        int n4 = 1 + this.getRows();
        int n5 = this.getCols() + n3;
        int n6 = n5 - 1;
        double[][] dArray2 = this.x_;
        double[][] dArray3 = new double[n4][n5];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[0][n2] = -dArray[n2];
        }
        int n7 = this.getCols() - 1;
        for (n2 = 1; n2 < n4; ++n2) {
            double d = dArray2[n2 - 1][n7];
            if (d >= 0.0) {
                for (n = 0; n < n3; ++n) {
                    dArray3[n2][n] = dArray2[n2 - 1][n];
                }
            } else {
                for (n = 0; n < n3; ++n) {
                    dArray3[n2][n] = -dArray2[n2 - 1][n];
                }
            }
            dArray3[n2][n6] = Math.abs(d);
        }
        n2 = 1;
        n7 = n3;
        while (n2 < n4) {
            dArray3[n2][n7] = 1.0;
            ++n2;
            ++n7;
        }
        double[] dArray4 = dArray3[0];
        block5: while (true) {
            double d;
            double d2 = 0.0;
            int n8 = -1;
            for (n = 0; n < n3; ++n) {
                if (!(dArray4[n] < d2)) continue;
                d2 = dArray4[n];
                n8 = n;
            }
            if (d2 == 0.0) break;
            d2 = Double.MAX_VALUE;
            n = -1;
            for (int i = 1; i < n4; ++i) {
                if (dArray3[i][n8] < 0.0 || !((d = dArray3[i][n6] / dArray3[i][n8]) < d2)) continue;
                d2 = d;
                n = i;
            }
            if (n == -1) {
                return null;
            }
            nArray[n8] = n;
            double[] dArray5 = dArray3[n];
            d = 1.0 / dArray5[n8];
            int n9 = 0;
            while (n9 < n5) {
                int n10 = n9++;
                dArray5[n10] = dArray5[n10] * d;
            }
            dArray5[n8] = 1.0;
            n9 = 0;
            while (true) {
                if (n9 >= n4) continue block5;
                double[] dArray6 = dArray3[n9];
                if (dArray6 != dArray5 && dArray6[n8] != 0.0) {
                    double d3 = dArray6[n8];
                    for (int i = 0; i < n5; ++i) {
                        int n11 = i;
                        dArray6[n11] = dArray6[n11] - dArray5[i] * d3;
                    }
                    dArray6[n8] = 0.0;
                }
                ++n9;
            }
            break;
        }
        double[] dArray7 = new double[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] <= 0) continue;
            dArray7[i] = dArray3[nArray[i]][n6];
        }
        dArray7[n3] = dArray3[0][n6];
        return dArray7;
    }

    static {
        $assertionsDisabled = !Matrix.class.desiredAssertionStatus();
    }
}

