/*
 * Decompiled with CFR 0.152.
 */
package phelps.doc;

import java.awt.Color;
import java.util.Map;
import java.util.StringTokenizer;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Node;
import multivalent.VObject;
import phelps.doc.FuzzSpan;
import phelps.lang.Integers;
import phelps.net.URIs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobustLocation {
    static final boolean DEBUG = false;
    public static final String ATTR_CONTEXT = "context";
    public static final String ATTR_TREE = "tree";
    public static final String ATTR_ID = "id";
    public static final String ATTR_LENGTH = "length";
    static final int PENALTY_SIBLING = 1;
    static final int PENALTY_LEVEL = 25;
    static final int PENALTY_THRESHOLD = 22;
    static final int DEPTHCREDIT = 35;
    static final int SCORE_CONTENT = 3;
    static final int SCORE_CONTEXT = 2;
    static final int PERFECTCC = 7;

    private RobustLocation() {
    }

    public static void descriptorFor(Node node, int n, Node node2, Map<String, Object> map) {
        INode iNode;
        map.put("behavior", "Location");
        for (iNode = node.getParentNode(); iNode != null && iNode.getName() == null; iNode = iNode.getParentNode()) {
        }
        int n2 = node.structChildNum();
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(URIs.encode(node.getName()));
        stringBuffer.append(' ');
        if (n2 > 0 && iNode.structChildAt(n2 - 1) != null) {
            stringBuffer.append(URIs.encode(iNode.structChildAt(n2 - 1).getName()));
        }
        stringBuffer.append(' ');
        if (n2 + 1 < iNode.structsize() && iNode.structChildAt(n2 + 1) != null) {
            stringBuffer.append(URIs.encode(iNode.structChildAt(n2 + 1).getName()));
        }
        map.put(ATTR_CONTEXT, stringBuffer.substring(0));
        stringBuffer.setLength(0);
        stringBuffer.append(n).append(' ');
        for (Node node3 = node; node3 != node2; node3 = node3.getParentNode()) {
            String string = node3.getName();
            if (string == null) continue;
            stringBuffer.append(' ').append(node3.structChildNum()).append('/').append(URIs.encode(string));
        }
        map.put(ATTR_TREE, stringBuffer.substring(0));
    }

    public static Mark attach(Map<String, Object> map, INode iNode) {
        String string;
        Object object;
        int n;
        if (map == null || iNode == null) {
            return null;
        }
        INode iNode2 = null;
        int n2 = 0;
        Document document = iNode.getDocument();
        Layer layer = document.getLayer("<scratch>");
        boolean bl = false;
        String string2 = (String)map.get("idref");
        if (string2 != null) {
            // empty if block
        }
        Report report = new Report();
        string2 = (String)map.get(ATTR_TREE);
        if (string2 != null) {
            int n3;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            object = new int[n];
            for (n3 = 0; n3 < n; ++n3) {
                string = stringTokenizer.nextToken();
                int n4 = string.indexOf(47);
                object[n3] = Integer.parseInt(string.substring(0, n4));
                stringArray[n3] = URIs.decode(string.substring(n4 + 1));
            }
            RobustLocation.attachTree(iNode, stringArray, object, n - 1, 0, 0, report);
            n3 = report.fuzz;
            if (n3 > 0) {
                RobustLocation.updateStat("TREEROBUST", 1, document);
            }
            if (bl && n3 > 0) {
                new FuzzSpan(report.node, n2, layer, n3 < 22 ? Color.GREEN : Color.YELLOW);
            }
            if (report.complete) {
                report.fuzz = n2;
                return new Mark((Leaf)report.node, report.fuzz);
            }
            iNode2 = (INode)report.node;
        }
        if ((string2 = (String)map.get(ATTR_CONTEXT)) != null) {
            int n5;
            String string3;
            int n6;
            if (iNode2 == null) {
                iNode2 = iNode;
            }
            int n7 = 0;
            n = string2.indexOf(32);
            if (n < (n6 = string2.lastIndexOf(32))) {
                object = string2.substring(0, n);
                string3 = string2.substring(n + 1, n6);
                string = string2.substring(n6 + 1);
            } else if (n == -1) {
                object = string2;
                string = "";
                string3 = "";
            } else {
                object = string2.substring(0, n);
                string = "";
                string3 = "";
            }
            object = URIs.decode((String)object);
            string3 = URIs.decode(string3);
            string = URIs.decode(string);
            Mark mark = null;
            int n8 = 0;
            Mark mark2 = null;
            INode iNode3 = null;
            INode iNode4 = iNode.getParentNode();
            for (INode iNode5 = iNode2; iNode5 != null && iNode5 != iNode4; iNode5 = iNode5.getParentNode()) {
                int n9 = iNode5.size();
                for (int i = 0; i < n9; ++i) {
                    Node node = iNode5.childAt(i);
                    if (node == iNode3 || (mark = RobustLocation.attachContent(node, (String)object, string3, string)) == null) continue;
                    n5 = mark.offset;
                    if (n5 > n8) {
                        n8 = n5;
                        mark2 = mark;
                    }
                    if (n5 == 7) break;
                }
                if ((mark = mark2) != null) break;
                n7 = (n7 + iNode5.size()) * 2;
                iNode3 = iNode5;
            }
            if (mark != null && ((n5 = mark.offset) == 7 || (n7 += 7 - n5) <= 22)) {
                if (n7 > 0) {
                    RobustLocation.updateStat("CCROBUST", 1, document);
                }
                if (bl && n7 > 0) {
                    new FuzzSpan(mark.leaf, n2, layer, n7 < 22 ? Color.ORANGE : Color.RED);
                }
                mark.offset = n2;
                return mark;
            }
        }
        return null;
    }

    public static Mark attachContent(Node node, String string, String string2, String string3) {
        String string4;
        Leaf leaf = node.getFirstLeaf();
        if (leaf == null) {
            return null;
        }
        int n = -1;
        int n2 = 0;
        Leaf leaf2 = null;
        Leaf leaf3 = null;
        Leaf leaf4 = leaf.getNextLeaf();
        Leaf leaf5 = node.getLastLeaf().getNextLeaf();
        String string5 = null;
        String string6 = leaf != null ? leaf.getName() : null;
        String string7 = string4 = leaf4 != null ? leaf4.getName() : null;
        while (leaf != null && leaf != leaf5) {
            n = 0;
            if (string.equals(string6)) {
                n += 3;
            }
            if (string2.equals(string5)) {
                n += 2;
            }
            if (string3.equals(string4)) {
                n += 2;
            }
            if (n > n2) {
                n2 = n;
                leaf2 = leaf;
                if (n == 7) break;
            }
            leaf3 = leaf;
            leaf = leaf4;
            leaf4 = leaf4 != null ? leaf.getNextLeaf() : null;
            string5 = string6;
            string6 = string4;
            string4 = leaf4 != null ? leaf4.getName() : null;
        }
        if (n2 >= 4) {
            return new Mark(leaf2, n2);
        }
        return null;
    }

    public static Node attachId(String string, String string2, Node node) {
        Leaf leaf = node.getLastLeaf();
        for (Leaf leaf2 = node.getFirstLeaf(); leaf2 != null && leaf2 != leaf; leaf2 = leaf2.getNextLeaf()) {
            int n = leaf2.sizeSticky();
            for (int i = 0; i < n; ++i) {
                Mark mark = leaf2.getSticky(i);
                Object object = mark.getOwner();
                if (!(object instanceof VObject) || !string.equals(((VObject)object).getAttr(string2))) continue;
                return leaf2;
            }
        }
        return node.findDFS(null, ATTR_ID, string);
    }

    public static void attachTree(Node node, String[] stringArray, int[] nArray, int n, int n2, int n3, Report report) {
        if (node.getName() == null && node.isStruct() && ((INode)node).size() == 1) {
            node = ((INode)node).childAt(0);
        }
        if (n2 > 22) {
            return;
        }
        boolean bl = node.isLeaf();
        if (n < 0 || bl) {
            report.reset(node, n2, n3, bl);
            return;
        }
        INode iNode = (INode)node;
        int n4 = iNode.structsize();
        int n5 = Math.min(nArray[n], n4);
        Node node2 = null;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        Node node3 = null;
        boolean bl2 = true;
        int n8 = 0;
        int n9 = n8 / 2;
        int n10 = 1;
        int n11 = n2;
        while (bl2 || n5 - n9 >= 0) {
            String string;
            node3 = null;
            if (n10 == 1) {
                if (bl2) {
                    node3 = iNode.structChildAt(n5 + n9);
                    bl2 = node3 != null;
                }
            } else if (n8 > 0 && n5 - n9 >= 0) {
                node3 = iNode.structChildAt(n5 - n9);
            }
            if (node3 != null && (string = node3.getName()).equals(stringArray[n])) {
                RobustLocation.attachTree(node3, stringArray, nArray, n - 1, n11, n3 + 1, report);
                if (report.fuzz == Integer.MAX_VALUE) {
                    report.reset(node3, n11, n3, false);
                }
                if (n6 == Integer.MAX_VALUE || report.fuzz - (report.depth - n7) * 35 < n6) {
                    if (report.complete) {
                        return;
                    }
                    node2 = report.node;
                    n6 = report.fuzz;
                    n7 = report.depth;
                }
            }
            n9 = ++n8 / 2;
            n10 *= -1;
            ++n11;
        }
        bl2 = true;
        if (n > 0) {
            n8 = 0;
            n9 = n8 / 2;
            n10 = 1;
            n11 = n2 + 25;
            while (bl2 || n5 - n9 >= 0) {
                node3 = null;
                if (n10 == 1) {
                    if (bl2) {
                        node3 = iNode.structChildAt(n5 + n9);
                        bl2 = node3 != null;
                    }
                } else if (n8 > 0 && n5 - n9 >= 0) {
                    node3 = iNode.structChildAt(n5 - n9);
                }
                if (node3 != null) {
                    for (int i = 0; i <= 1; ++i) {
                        Node node4 = i == 0 ? node3 : iNode;
                        int n12 = i == 0 ? 0 : 1;
                        RobustLocation.attachTree(node4, stringArray, nArray, n - n12, n11, n3 + 1, report);
                        if (report.fuzz >= Integer.MAX_VALUE || n6 != Integer.MAX_VALUE && report.fuzz - (report.depth - n7) * 35 >= n6) continue;
                        if (report.complete) {
                            return;
                        }
                        node2 = report.node;
                        n6 = report.fuzz;
                        n7 = report.depth;
                    }
                }
                n9 = ++n8 / 2;
                n10 *= -1;
                ++n11;
            }
        }
        report.reset(node2, n6, n7, false);
    }

    static void updateStat(String string, int n, Document document) {
        if (document == null) {
            return;
        }
        int n2 = Integers.parseInt(document.getAttr(string), 0) + n;
        document.putAttr(string, Integer.toString(n2));
    }

    static class Report {
        public Node node;
        public int fuzz;
        public int depth;
        public boolean complete;

        public Report() {
            this.reset();
        }

        public void reset() {
            this.node = null;
            this.fuzz = 0;
            this.depth = 0;
            this.complete = false;
        }

        public void reset(Node node, int n, int n2, boolean bl) {
            this.node = node;
            this.fuzz = n;
            this.depth = n2;
            this.complete = bl;
        }
    }
}

