/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.net.URI;
import java.net.URISyntaxException;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.DocInfo;
import multivalent.INode;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.node.LeafText;
import phelps.lang.Strings;
import phelps.net.URIs;

public class SelectionUI
extends Behavior {
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_SELURI = "seluri";
    public static final String ATTR_FULLPAGEURI = "fullpageuri";
    public static final String ATTR_URI = "uri";

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/DOCPOPUP" == string && semanticEvent.getIn() == this.getBrowser().getSelectionSpan()) {
            String string2 = this.getAttr(ATTR_SELURI);
            if (string2 == null) {
                return false;
            }
            INode iNode = (INode)semanticEvent.getOut();
            this.createUI("button", this.getAttr(ATTR_TITLE), "event " + string2, iNode, "LOOKUP", false);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object;
        Browser browser = this.getBrowser();
        Span span = browser.getSelectionSpan();
        String string2 = null;
        if (null != string) {
            if (string.equals(this.getAttr(ATTR_SELURI))) {
                object = null;
                if (span.isSet()) {
                    object = browser.clipboard();
                } else {
                    Node node = browser.getCurNode();
                    if (node instanceof LeafText) {
                        object = node.getName();
                    }
                }
                if (object != null) {
                    string2 = string + URIs.encode(Strings.trimPunct((String)object));
                }
            } else if (string.equals(this.getAttr(ATTR_FULLPAGEURI))) {
                object = browser.getCurDocument().getURI();
                if (((URI)object).getScheme().equals("http")) {
                    string2 = string + URIs.encode(((URI)object).toString());
                }
            } else if (string.equals(this.getAttr(ATTR_URI))) {
                string2 = string;
            }
        }
        if (string2 != null) {
            try {
                object = new DocInfo(new URI(string2));
                ((DocInfo)object).window = this.getAttr("window");
                browser.eventq("openDocument", object);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

