/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.QuadCurve2D;
import java.util.Map;
import multivalent.Browser;
import multivalent.CHashMap;
import multivalent.Context;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import phelps.doc.RobustLocation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveTextSpan
extends Span {
    public static final String MSG_RESET_DEST = "resetMoveTo";
    private static final int DRAG_THRESHOLD = 25;
    private static boolean active_ = false;
    private static boolean skip_ = false;
    private static int x0_;
    private static int y0_;
    private Mark moveTo_ = new Mark(null, -1, null);
    private Node obs_ = null;
    private QuadCurve2D spline_ = new QuadCurve2D.Double();
    private Map<String, Object> pdest_ = null;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("formattedDocument" == string) {
            this.setDisplay();
        } else {
            if (this != semanticEvent.getIn()) {
                return false;
            }
            if ("createWidget/DOCPOPUP" == string) {
                INode iNode = (INode)semanticEvent.getOut();
                Browser browser = this.getBrowser();
                if (this.isEditable() && this.moveTo_.isSet()) {
                    this.createUI("button", "Re-set move-to point", new SemanticEvent(browser, MSG_RESET_DEST, this, this, null), iNode, "EDIT", false);
                }
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (this == semanticEvent.getIn() && MSG_RESET_DEST == string) {
            this.moveTo_.remove();
            this.setDisplay();
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        if (this.moveTo_.isSet()) {
            context.underline = Color.RED;
        } else {
            context.foreground = Color.WHITE;
            context.background = Color.LIGHT_GRAY;
        }
        return false;
    }

    @Override
    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        if (skip_) {
            return false;
        }
        boolean bl = this.moveTo_.isSet();
        Browser browser = this.getBrowser();
        int n = aWTEvent.getID();
        if (n == 504) {
            browser.setCursor(Cursor.getPredefinedCursor(12));
            browser.eventq("showStatus", bl ? "Click to move text" : "Choose move to point by pressing down now and dragging to destination.");
            this.repaint();
        } else if (n == 505) {
            this.spanExit();
        } else if (n == 501 && this.contains(browser.getCurNode(), browser.getCurOffset()) && (((MouseEvent)aWTEvent).getModifiers() & 0x10) != 0) {
            if (bl) {
                active_ = true;
                Point point2 = browser.getCurScrn();
                x0_ = point2.x;
                y0_ = point2.y;
            }
            browser.setGrab(this);
        }
        return super.eventAfter(aWTEvent, point, node);
    }

    @Override
    public void event(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        Browser browser = this.getBrowser();
        if (400 <= n && n <= 402 && browser.getGrab() == this) {
            browser.releaseGrab(this);
            skip_ = true;
            browser.event(aWTEvent);
            browser.setGrab(this);
            skip_ = false;
        } else if (n == 506) {
            if (active_) {
                Point point = browser.getCurScrn();
                if (this.isEditable() && (Math.abs(point.x - x0_) > 25 || Math.abs(point.y - y0_) > 25)) {
                    this.spanExit();
                    skip_ = true;
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    browser.event(new MouseEvent((Component)aWTEvent.getSource(), 501, mouseEvent.getWhen() + 1L, 16, x0_, y0_, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    skip_ = false;
                }
            } else {
                browser.setCurNode(null);
                this.getRoot().eventBeforeAfter(aWTEvent, browser.getCurScrn());
                Node node = browser.getCurNode();
                int n2 = browser.getCurOffset();
                if (node != null && node.isLeaf()) {
                    if (this.contains(node, n2)) {
                        this.moveTo_.remove();
                    } else {
                        this.moveTo_.move((Leaf)node, n2);
                    }
                    this.setDisplay();
                }
            }
        } else if (n == 502) {
            boolean bl = active_;
            this.spanExit();
            if (bl) {
                this.execute();
            }
        }
    }

    protected void spanExit() {
        Browser browser = this.getBrowser();
        if (browser != null) {
            browser.releaseGrab(this);
            browser.setCursor(Cursor.getDefaultCursor());
            browser.eventq("showStatus", "");
            this.repaint();
        }
        active_ = false;
    }

    protected void setDisplay() {
        if (this.obs_ != null) {
            this.obs_.deleteObserver(this);
        }
        if (this.isSet() && this.moveTo_.isSet()) {
            Leaf leaf = this.getStart().leaf;
            Leaf leaf2 = this.moveTo_.leaf;
            this.obs_ = leaf.commonAncestor(leaf2);
            this.obs_.addObserver(this);
            Point point = leaf.getRelLocation(this.obs_);
            Point point2 = leaf2.getRelLocation(this.obs_);
            point.translate(0, leaf.bbox.height / 2);
            point2.translate(0, leaf2.bbox.height / 2);
            Point point3 = leaf.offset2rel(this.getStart().offset);
            point.translate(point3.x, point3.y);
            point3 = leaf2.offset2rel(this.moveTo_.offset);
            point2.translate(point3.x, point3.y);
            int n = point.x;
            int n2 = point.y;
            int n3 = point2.x;
            int n4 = point2.y;
            int n5 = n3 - n;
            int n6 = n4 - n2;
            int n7 = n + n5 / 2;
            int n8 = n2 + n6 / 2 + (n6 <= -10 ? 20 : -20);
            this.spline_.setCurve(n, n2, n7, n8, n3, n4);
        } else {
            this.obs_ = null;
        }
        this.getBrowser().repaint();
    }

    @Override
    public boolean paintAfter(Context context, Node node) {
        if (node == this.obs_) {
            Graphics2D graphics2D = context.g;
            graphics2D.setColor(Color.RED);
            graphics2D.draw(this.spline_);
            AffineTransform affineTransform = graphics2D.getTransform();
            double d = this.spline_.getX1();
            double d2 = this.spline_.getY1();
            double d3 = this.spline_.getX2();
            double d4 = this.spline_.getY2();
            double d5 = d3 - d;
            double d6 = d4 - d2;
            double d7 = Math.atan(d6 / d5);
            double d8 = 0.2617993877991494;
            graphics2D.translate(d3, d4);
            graphics2D.rotate(d7 + Math.PI - d8 + (d5 > 0.0 ? 0.0 : Math.PI));
            graphics2D.drawLine(0, 0, 10, 0);
            graphics2D.rotate(2.0 * d8);
            graphics2D.drawLine(0, 0, 10, 0);
            graphics2D.setTransform(affineTransform);
        }
        return false;
    }

    @Override
    public boolean formatAfter(Node node) {
        this.setDisplay();
        return false;
    }

    @Override
    public void destroy() {
        this.moveTo_.remove();
        if (this.obs_ != null) {
            this.obs_.deleteObserver(this);
        }
        super.destroy();
    }

    @Override
    public void moveq(Leaf leaf, int n, Leaf leaf2, int n2) {
        super.moveq(leaf, n, leaf2, n2);
        if (this.moveTo_.isSet() && this.isSet() && this.contains(this.moveTo_)) {
            this.moveTo_.remove();
        }
    }

    public void execute() {
        Leaf leaf = this.getStart().leaf;
        Leaf leaf2 = this.getEnd().leaf;
        Leaf leaf3 = this.moveTo_.leaf;
        int n = this.getStart().offset;
        int n2 = this.getEnd().offset;
        int n3 = this.moveTo_.offset;
        this.destroy();
        String string = leaf.cut(n, leaf2, n2);
        leaf3.insert(n3, string, null);
    }

    @Override
    public ESISNode save() {
        ESISNode eSISNode = super.save();
        if (eSISNode != null && this.moveTo_.isSet() && this.moveTo_.isSet()) {
            if (this.pdest_ == null) {
                this.pdest_ = new CHashMap<Object>(5);
            } else {
                this.pdest_.clear();
            }
            RobustLocation.descriptorFor(this.moveTo_.leaf, this.moveTo_.offset, this.getDocument(), this.pdest_);
            eSISNode.appendChild(new ESISNode("moveto", this.pdest_));
        }
        return eSISNode;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        if (eSISNode != null) {
            int n = eSISNode.size();
            for (int i = 0; i < n; ++i) {
                ESISNode eSISNode2;
                Object object = eSISNode.childAt(i);
                if (!(object instanceof ESISNode) || !"moveto".equals((eSISNode2 = (ESISNode)object).getGI())) continue;
                this.pdest_ = eSISNode2.attrs;
                break;
            }
        }
    }

    @Override
    public void buildAfter(Document document) {
        if (this.pdest_ != null) {
            this.moveTo_.move(RobustLocation.attach(this.pdest_, document));
        }
        super.buildAfter(document);
    }
}

