/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import multivalent.Meta;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.io.InputStreams;

public class DecodePredictor
extends FilterInputStream {
    private boolean eof_ = false;
    private int pred_;
    private int colors_;
    private int bitsper_;
    private byte[] lastline_;
    private byte[] line_;
    private int linei_;
    private int col0_;
    private int rowlen_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DecodePredictor(InputStream inputStream, int n, Dict dict, PDFReader pDFReader) throws IOException {
        super(inputStream);
        if (!($assertionsDisabled || n != 1 && n != 10)) {
            throw new AssertionError();
        }
        this.pred_ = n;
        Object object = dict.get("Colors");
        int n2 = this.colors_ = object != null ? pDFReader.getObjInt(object) : 1;
        if (!$assertionsDisabled && this.colors_ < 1) {
            throw new AssertionError();
        }
        object = dict.get("BitsPerComponent");
        int n3 = this.bitsper_ = object != null ? pDFReader.getObjInt(object) : 8;
        if (this.bitsper_ > 8) {
            Meta.sampledata("Predictor " + n + " bitsper=" + this.bitsper_);
        }
        int n4 = (object = dict.get("Columns")) != null ? pDFReader.getObjInt(object) : 1;
        this.col0_ = (this.colors_ * this.bitsper_ + 7) / 8;
        this.rowlen_ = (n4 * this.colors_ * this.bitsper_ + 7) / 8 + this.col0_;
        this.line_ = new byte[this.rowlen_];
        this.lastline_ = new byte[this.line_.length];
        this.nextRow();
    }

    private void nextRow() throws IOException {
        byte[] byArray = this.lastline_;
        this.lastline_ = this.line_;
        byte[] byArray2 = this.line_ = byArray;
        byte[] byArray3 = this.lastline_;
        this.linei_ = this.col0_;
        int n = this.pred_;
        if (n == 15) {
            n = this.in.read();
            if (n == -1) {
                this.eof_ = true;
                return;
            }
            if (!($assertionsDisabled || (n += 10) >= 10 && n < 15)) {
                throw new AssertionError(n);
            }
        } else if (n >= 10) {
            this.in.read();
        }
        int n2 = this.rowlen_;
        try {
            InputStreams.readFully(this.in, byArray2, 0 + this.col0_, n2 - this.col0_);
        }
        catch (EOFException eOFException) {
            this.eof_ = true;
            return;
        }
        int n3 = (this.colors_ * this.bitsper_ + 7) / 8;
        switch (n) {
            case 1: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
            case 2: {
                for (int i = 0 + this.col0_; i < n2; ++i) {
                    int n4 = i;
                    byArray2[n4] = (byte)(byArray2[n4] + byArray2[i - n3]);
                }
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                for (int i = 0 + this.col0_; i < n2; ++i) {
                    int n5 = i;
                    byArray2[n5] = (byte)(byArray2[n5] + byArray2[i - n3]);
                }
                break;
            }
            case 12: {
                for (int i = 0 + this.col0_; i < n2; ++i) {
                    int n6 = i;
                    byArray2[n6] = (byte)(byArray2[n6] + byArray3[i]);
                }
                break;
            }
            case 13: {
                for (int i = 0 + this.col0_; i < n2; ++i) {
                    int n7 = i;
                    byArray2[n7] = (byte)(byArray2[n7] + ((byArray2[i - n3] & 0xFF) + (byArray3[i] & 0xFF)) / 2);
                }
                break;
            }
            case 14: {
                int n8 = 0 + this.col0_;
                while (n8 < n2) {
                    int n9 = byArray2[n8 - n3] & 0xFF;
                    int n10 = byArray3[n8] & 0xFF;
                    int n11 = byArray3[n8 - n3] & 0xFF;
                    int n12 = n9 + n10 - n11;
                    int n13 = Math.abs(n12 - n9);
                    int n14 = Math.abs(n12 - n10);
                    int n15 = Math.abs(n12 - n11);
                    int n16 = n13 <= n14 && n13 <= n15 ? n9 : (n14 <= n15 ? n10 : n11);
                    int n17 = n8++;
                    byArray2[n17] = (byte)(byArray2[n17] + (byte)n16);
                }
                break;
            }
            case 15: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)(n + " vs " + this.pred_));
                }
                break;
            }
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (this.eof_) {
            return -1;
        }
        if (this.linei_ == this.rowlen_) {
            this.nextRow();
            return this.read(byArray, n, n2);
        }
        n2 = Math.min(n2, this.rowlen_ - this.linei_);
        if (!($assertionsDisabled || n2 >= 0 && n2 <= this.rowlen_ - this.col0_)) {
            throw new AssertionError();
        }
        System.arraycopy(this.line_, this.linei_, byArray, n, n2);
        this.linei_ += n2;
        return n2;
    }

    public int read() throws IOException {
        int n;
        if (this.eof_) {
            n = -1;
        } else if (this.linei_ < this.rowlen_) {
            n = this.line_[this.linei_++] & 0xFF;
        } else {
            this.nextRow();
            return this.read();
        }
        return n;
    }

    public boolean markSupported() {
        return false;
    }

    static {
        $assertionsDisabled = !DecodePredictor.class.desiredAssertionStatus();
    }
}

