/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.FSFile;
import com.pt.io.FSFileZip;
import com.pt.io.FileSystem;
import com.pt.io.InputStreamInflater;
import com.pt.io.InputStreamRandomAccess;
import com.pt.io.InputUni;
import com.pt.io.InputUniFile;
import com.pt.io.RandomAccess;
import com.pt.lang.MSDOS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tools.bzip2.CBZip2InputStream;
import phelps.io.InputStreamSlice;
import phelps.lang.Bytes;

public class FileSystemZip
extends FileSystem {
    public static final char separatorChar = '/';
    private static final byte[] SIG_CENTRAL_START = new byte[]{80, 75, 1, 2};
    private static final byte[] SIG_LOCAL = new byte[]{80, 75, 3, 4};
    private static final byte[] SIG_CENTRAL_END = new byte[]{80, 75, 5, 6};
    private RandomAccess ra_;
    private long dirpos_ = -1L;
    private int dircnt_;

    public FileSystemZip(InputUni inputUni) throws IOException {
        super(inputUni.getURI());
        this.ra_ = inputUni.getRandomAccess();
        try {
            this.init();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public FileSystemZip(File file) throws IOException {
        this(new InputUniFile(file));
    }

    private void init() throws IOException {
        int n;
        int n2;
        int n3;
        long l;
        this.ra_.seek(0L);
        int n4 = SIG_LOCAL.length;
        for (int i = 0; i < n4; ++i) {
            if (this.ra_.read() == SIG_LOCAL[i]) continue;
            throw new IOException("not valid Zip");
        }
        for (l = this.ra_.length() - 22L; l >= 0L; --l) {
            this.ra_.seek(l);
            n3 = 1;
            n2 = SIG_CENTRAL_END.length;
            for (n = 0; n < n2; ++n) {
                if (this.ra_.read() == SIG_CENTRAL_END[n]) continue;
                n3 = 0;
                break;
            }
            if (n3 != 0) break;
        }
        if (l == -1L) {
            throw new IOException("central directory not found -- not valid Zip");
        }
        n3 = this.read2();
        this.read2();
        n = this.read2();
        n2 = this.read2();
        if (n != n2) {
            throw new IOException("split archives not supported");
        }
        this.dircnt_ = n2;
        long l2 = this.read4();
        this.dirpos_ = l - l2;
    }

    private int read2() throws IOException {
        return this.ra_.read() + (this.ra_.read() << 8);
    }

    private long read4() throws IOException {
        return this.ra_.read() + (this.ra_.read() << 8) + (this.ra_.read() << 16) + (this.ra_.read() << 24);
    }

    private String readString(int n) throws IOException {
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)this.ra_.read());
        }
        return stringBuffer.toString();
    }

    private FSFileZip readEntry(long l) throws IOException {
        byte[] byArray;
        int n;
        this.ra_.seek(l);
        int n2 = SIG_CENTRAL_START.length;
        for (n = 0; n < n2; ++n) {
            if (this.ra_.read() == SIG_CENTRAL_START[n]) continue;
            return null;
        }
        n = this.read2();
        n2 = this.read2();
        int n3 = this.read2();
        int n4 = this.read2();
        int n5 = this.read2();
        int n6 = this.read2();
        long l2 = MSDOS.date(n6, n5);
        long l3 = this.read4();
        long l4 = this.read4();
        long l5 = this.read4();
        int n7 = this.read2();
        int n8 = this.read2();
        int n9 = this.read2();
        int n10 = this.read2();
        int n11 = this.read2();
        long l6 = this.read4();
        long l7 = this.read4();
        String string = this.readString(n7);
        if (n8 == 0) {
            byArray = Bytes.ARRAY0;
        } else {
            byArray = new byte[n8];
            this.ra_.readFully(byArray);
        }
        String string2 = this.readString(n9);
        return new FSFileZip(this, l7, string, n2, n3, n4, l2, l3, l5, l4, byArray, string2);
    }

    public Iterator iterator() throws IOException {
        return new IteratorFSFileZip(this.dirpos_, this.dircnt_);
    }

    public InputStream getInputStream(FSFile fSFile) throws IOException {
        if (this.ra_ == null) {
            throw new IOException("closed");
        }
        if (!(fSFile instanceof FSFileZip)) {
            throw new IOException("Not a FSFileZip");
        }
        FSFileZip fSFileZip = (FSFileZip)fSFile;
        if (fSFileZip.getSource() != this) {
            throw new IOException("file didn't come from this Zip");
        }
        int n = fSFileZip.getMethod();
        int n2 = fSFileZip.getFlags();
        long l = fSFileZip.getOffset() + 30L + (long)fSFileZip.getPath().length() + (long)fSFileZip.getExtra().length;
        InputStream inputStream = new InputStreamSlice(new InputStreamRandomAccess(this.ra_, false), l, fSFileZip.lengthCompressed());
        switch (n) {
            case 0: {
                break;
            }
            case 8: {
                inputStream = new InputStreamInflater(inputStream, n, n2);
                break;
            }
            case 12: {
                inputStream = new CBZip2InputStream(inputStream);
                break;
            }
            default: {
                ((InputStream)inputStream).close();
                throw new IOException("Unsupported compression method: " + n);
            }
        }
        return inputStream;
    }

    public void close() throws IOException {
        if (this.ra_ != null) {
            this.ra_.close();
            this.ra_ = null;
        }
    }

    class IteratorFSFileZip
    implements Iterator {
        private FSFileZip next_;
        private long pos_;
        private int cnt_;

        public IteratorFSFileZip(long l, int n) {
            this.pos_ = l;
            this.cnt_ = n;
        }

        public boolean hasNext() {
            return this.cnt_ > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FSFileZip fSFileZip = null;
            try {
                fSFileZip = FileSystemZip.this.readEntry(this.pos_);
                this.pos_ += (long)(46 + fSFileZip.getPath().length() + fSFileZip.getExtra().length + fSFileZip.getComment().length());
            }
            catch (IOException iOException) {
            }
            finally {
                --this.cnt_;
            }
            return fSFileZip;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

