/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import tmap_30.map.MapTool;
import tmap_30.map.ToolHandle;

public class XTool
extends MapTool {
    public XTool(int n, int n2, int n3, int n4, Color color) {
        this.numHandles = 3;
        this.mouseDownHandle = 3;
        this.snapMid_Y = false;
        this.needsRange_Y = false;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.color = color;
        this.saveHandles();
    }

    public XTool(Rectangle rectangle, Color color) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }

    public void draw(Graphics graphics) {
        int n = 0;
        graphics.setColor(this.color);
        graphics.drawLine(this.x, this.y + this.height / 2, this.x + this.width, this.y + this.height / 2);
        if (this.drawHandles) {
            n = 0;
            while (n < this.numHandles) {
                this.handle[n].draw(graphics);
                ++n;
            }
        }
    }

    protected void saveHandles() {
        this.handle = new ToolHandle[this.numHandles];
        this.handle[0] = new ToolHandle(this.x - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 7);
        this.handle[1] = new ToolHandle(this.x + this.width / 2 - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 8);
        this.handle[2] = new ToolHandle(this.x + this.width - this.hw / 2, this.y + this.height / 2 - this.hh / 2, this.hw, this.hh, this.color, 3);
    }

    public void adjustWidthHeight() {
        if (this.y + this.height / 2 < this.boundingRect.y) {
            this.height = 0;
            this.y = this.boundingRect.y;
            return;
        }
        if (this.y < this.boundingRect.y) {
            this.height = 2 * (this.y + this.height / 2 - this.boundingRect.y);
            this.y = this.boundingRect.y;
            return;
        }
        if (this.y + this.height / 2 > this.boundingRect.y + this.boundingRect.height) {
            this.height = 0;
            this.y = this.boundingRect.y + this.boundingRect.height;
            return;
        }
        if (this.y + this.height > this.boundingRect.y + this.boundingRect.height) {
            this.height = 2 * (this.boundingRect.y + this.boundingRect.height - (this.y + this.height / 2));
            this.y = this.boundingRect.y + this.boundingRect.height - this.height;
        }
    }

    public void bump_against_sides(int n, int n2) {
        if (n - this.width / 2 < this.boundingRect.x) {
            this.pan_right = false;
            this.pan_right_fast = false;
            if (this.left_edge_scroll) {
                this.pan_left = true;
                this.pan_left_fast = n < this.boundingRect.x + 2;
            } else {
                this.pan_left = false;
                this.pan_left_fast = false;
            }
            this.x = this.boundingRect.x;
        } else if (n - this.width / 2 + this.width > this.boundingRect.x + this.boundingRect.width) {
            this.pan_left = false;
            this.pan_left_fast = false;
            if (this.right_edge_scroll) {
                this.pan_right = true;
                this.pan_right_fast = n > this.boundingRect.x + this.boundingRect.width - 2;
            } else {
                this.pan_right = false;
                this.pan_right_fast = false;
            }
            this.x = this.boundingRect.x + this.boundingRect.width - this.width;
        } else {
            this.pan_left = false;
            this.pan_right = false;
            this.pan_left_fast = false;
            this.pan_right_fast = false;
            this.x = n - this.width / 2;
        }
        if (n2 < this.boundingRect.y + this.hh / 2) {
            this.pan_down = false;
            this.pan_down_fast = false;
            if (this.top_edge_scroll) {
                this.pan_up = true;
                this.pan_up_fast = n2 == this.boundingRect.y;
            } else {
                this.pan_up = false;
                this.pan_up_fast = false;
            }
            this.y = this.boundingRect.y;
            this.height = 0;
            return;
        }
        if (n2 > this.boundingRect.y + this.boundingRect.height - this.hh / 2) {
            this.pan_up = false;
            this.pan_up_fast = false;
            if (this.bottom_edge_scroll) {
                this.pan_down = true;
                this.pan_down_fast = n2 == this.boundingRect.y + this.boundingRect.height;
            } else {
                this.pan_down = false;
                this.pan_down = false;
            }
            this.y = this.boundingRect.y + this.boundingRect.height;
            this.height = 0;
            return;
        }
        this.pan_down = false;
        this.pan_up = false;
        this.pan_down_fast = false;
        this.pan_up_fast = false;
        this.y = n2 - this.height / 2;
    }
}

