/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import com.arbortext.catalog.Catalog;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.XSLTResolverInterface;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLTransformer {
    public static final String SELECTED_DISPLAY_XSLPROP = "displaymodule";
    public static final String XSLVALU_DISPLAY_DATASET = "dataset";
    public static final String XSLVALU_DISPLAY_ENTITY = "entity";
    public static final String XSLVALU_DISPLAY_ATTRB = "attributedetail";
    public static final String XSLVALU_DISPLAY_PRNT = "printall";
    public static final String SELECTED_ENTITY_XSLPROP = "entityindex";
    public static final String SELECTED_ATTRIBS_XSLPROP = "attributeindex";
    public static final String SUPPRESS_TRIPLES_SUBJECTS_XSLPROP = "suppress_subjects_identifier";
    public static final String SUPPRESS_TRIPLES_OBJECTS_XSLPROP = "suppress_objects_identifier";
    public static final String SUPPRESS_TRIPLES_DELIMETER = " ";
    public static final String PACKAGE_INDEX_NAME_XSLPROP = "package_index_name";
    public static final String PACKAGE_ID_XSLPROP = "package_id";
    public static final String DEFAULT_CSS_XSLPROP = "qformat";
    public static final String ENTITY_CSS_XSLPROP = "entitystyle";
    public static final String CSS_PATH_XSLPROP = "stylePath";
    public static final String HREF_PATH_EXTENSION_XSLPROP = "href_path_extension";
    public static final String NAMESPACE_FOR_SCHEMA_LOCATION = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String ATTRIB_NAME_FOR_SCHEMA_LOCATION = "schemaLocation";
    public static final String ID_TO_GET_GENERIC_STYLESHEET = "unidentified";
    private final String CONFIG_KEY_LOCAL_CATALOG_PATH = "local_catalog_path";
    private final String CONFIG_KEY_GENERIC_STYLESHEET = "genericStylesheet";
    private final String CONFIG_KEY_GENERIC_LOCATION = "genericStylesheetLocation";
    private final String GENERIC_STYLESHEET;
    private final String GENERIC_LOCATION;
    private final ClassLoader classLoader;
    private static XMLTransformer instance;
    private static String latestDocID;
    private static XSLTResolverInterface resolver;
    private Properties transformerProperties;
    private ConfigXML config = Morpho.getConfiguration();

    private XMLTransformer() {
        this.GENERIC_STYLESHEET = this.config.get("genericStylesheet", 0);
        this.GENERIC_LOCATION = this.config.get("genericStylesheetLocation", 0);
        Log.debug(30, "XMLTransformer: ClassLoader *would* have been: " + this.getClass().getClassLoader().getClass().getName());
        this.classLoader = Morpho.class.getClassLoader();
        Log.debug(30, "XMLTransformer: ...but from Morpho, setting ClassLoader to: " + this.classLoader.getClass().getName());
        Thread t = Thread.currentThread();
        t.setContextClassLoader(this.classLoader);
        this.transformerProperties = new Properties();
    }

    public static XMLTransformer getInstance() {
        if (instance == null) {
            instance = new XMLTransformer();
        }
        return instance;
    }

    public Reader transform(Reader xmlDocReader) throws IOException {
        Log.debug(50, "XMLTransformer.transform(Reader xmlDocReader) called");
        this.validateInputParam(xmlDocReader, "XML document reader");
        Document doc = null;
        try {
            doc = this.getAsDOMDocument(xmlDocReader);
        }
        catch (IOException e) {
            this.throwIOException(e, "IOException");
        }
        catch (SAXException e) {
            this.throwIOException(e, "SAXException");
        }
        catch (FactoryConfigurationError e) {
            this.throwIOException(e, "FactoryConfigurationError");
        }
        catch (ParserConfigurationException e) {
            this.throwIOException(e, "ParserConfigurationException");
        }
        return this.transform(doc);
    }

    public Reader transform(Reader xmlDocReader, Reader xslStyleSheet, String xsltLocation) throws IOException {
        Log.debug(50, "XMLTransformer.transform(Reader, Reader) called");
        this.validateInputParam(xmlDocReader, "XML document reader");
        this.validateInputParam(xslStyleSheet, "XSL stylesheet reader");
        Document doc = null;
        try {
            doc = this.getAsDOMDocument(xmlDocReader);
        }
        catch (IOException e) {
            this.throwIOException(e, "IOException");
        }
        catch (SAXException e) {
            this.throwIOException(e, "SAXException");
        }
        catch (FactoryConfigurationError e) {
            this.throwIOException(e, "FactoryConfigurationError");
        }
        catch (ParserConfigurationException e) {
            this.throwIOException(e, "ParserConfigurationException");
        }
        return this.transform(doc, xslStyleSheet, xsltLocation);
    }

    public Reader transform(Document domDoc) throws IOException {
        Log.debug(50, "XMLTransformer.transform(Reader xmlDocReader) called");
        this.validateInputParam(domDoc, "XML DOM Document");
        Element rootNode = domDoc.getDocumentElement();
        Log.debug(50, "domDoc is: " + XMLUtilities.getDOMTreeAsString((Node)rootNode));
        String identifier = null;
        if (domDoc.getDoctype() != null) {
            identifier = domDoc.getDoctype().getPublicId();
            Log.debug(50, "getPublicId() gives: " + identifier);
        }
        if ((identifier == null || identifier.trim().equals("")) && (identifier = rootNode.getAttributeNS(NAMESPACE_FOR_SCHEMA_LOCATION, ATTRIB_NAME_FOR_SCHEMA_LOCATION)) != null && !identifier.trim().equals("")) {
            identifier = identifier.trim().substring(0, identifier.indexOf(SUPPRESS_TRIPLES_DELIMETER));
            Log.debug(50, "getAttributeNS schemaLocation is: " + identifier);
        }
        if (identifier == null || identifier.trim().equals("")) {
            identifier = rootNode.getNamespaceURI();
            Log.debug(50, "rootNode.getNamespaceURI() gives: " + identifier);
        }
        if (identifier == null || identifier.trim().equals("")) {
            identifier = ID_TO_GET_GENERIC_STYLESHEET;
            Log.debug(50, "no identifier - requesting generic stylesheet");
        }
        return this.transform(domDoc, this.getStyleSheetReader(identifier), this.getStyleSheetLocation(identifier));
    }

    public Reader transform(Document domDoc, Reader xslStyleSheet, String xsltLocation) throws IOException {
        Log.debug(50, "XMLTransformer.transform(Document, Reader) called");
        this.validateInputParam(domDoc, "XML DOM Document");
        this.validateInputParam(xslStyleSheet, "XSL stylesheet reader");
        return this.doTransform(this.getAsDOMSource(domDoc), xslStyleSheet, xsltLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Reader doTransform(Source source, Reader xslStyleSheet, String xsltLocation) throws IOException {
        Log.debug(50, "--> XMLTransformer.doTransform(Source, Reader) called;\n    Source = " + source + "\n    xslStyleSheet = " + xslStyleSheet);
        CharArrayWriter outputWriter = new CharArrayWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setURIResolver(new CustomURIResolver(xsltLocation));
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer(new StreamSource(xslStyleSheet));
        }
        catch (TransformerConfigurationException e) {
            String msg = "XMLTransformer.transform(): getting Transformer instance. Nested TransformerConfigurationException=" + e.getMessage();
            e.printStackTrace();
            Log.debug(12, msg);
            outputWriter.write(msg.toCharArray(), 0, msg.length());
            e.printStackTrace(new PrintWriter(outputWriter));
        }
        transformer.setErrorListener(new CustomErrorListener());
        Enumeration propertyNames = this.getTransformerPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String nextProp = (String)propertyNames.nextElement();
            transformer.setParameter(nextProp, this.getTransformerProperty(nextProp));
        }
        try {
            Log.debug(50, "XMLTransformer doing transformer.transform...");
            transformer.transform(source, new StreamResult(outputWriter));
            Log.debug(50, "XMLTransformer DONE transformer.transform!");
        }
        catch (TransformerException e) {
            String msg = "XMLTransformer.transform(): Error transforming document. Nested TransformerException=" + e.getMessage();
            e.printStackTrace();
            Log.debug(12, msg);
            outputWriter.write(msg.toCharArray(), 0, msg.length());
            e.printStackTrace(new PrintWriter(outputWriter));
        }
        catch (Exception e) {
            String msg = "XMLTransformer.transform(): Unrecognized Error transforming document: " + e.getMessage();
            e.printStackTrace();
            Log.debug(12, msg);
            outputWriter.write(msg.toCharArray(), 0, msg.length());
            e.printStackTrace(new PrintWriter(outputWriter));
        }
        finally {
            outputWriter.flush();
            outputWriter.close();
        }
        return new StringReader(outputWriter.toString());
    }

    private void validateInputParam(Object param, String paramDescription) throws IOException {
        if (param == null) {
            String errMsg = "XMLTransformer received NULL parameter: " + paramDescription;
            IOException exception = new IOException(errMsg);
            exception.fillInStackTrace();
            Log.debug(12, errMsg);
            throw exception;
        }
    }

    private DOMSource getAsDOMSource(Document domDoc) {
        return new DOMSource(domDoc);
    }

    private synchronized Document getAsDOMDocument(Reader xmlDocReader) throws IOException, SAXException, FactoryConfigurationError, ParserConfigurationException {
        InputSource source = new InputSource(xmlDocReader);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setErrorHandler(new CustomErrorHandler());
        return docBuilder.parse(source);
    }

    public void addTransformerProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (this.transformerProperties.contains(key)) {
            return;
        }
        this.transformerProperties.setProperty(key, value);
    }

    public void removeTransformerProperty(String key) {
        if (key == null) {
            return;
        }
        this.transformerProperties.remove(key);
    }

    public void removeAllTransformerProperties() {
        this.transformerProperties.clear();
    }

    public void setTransformerProperties(Properties newProps) {
        this.transformerProperties = newProps;
    }

    public Properties getCurrentTransformerProperties() {
        Properties returnProps = new Properties();
        if (this.transformerProperties.isEmpty()) {
            return returnProps;
        }
        Iterator<Object> keys = this.transformerProperties.keySet().iterator();
        String nextKey = null;
        while (keys.hasNext()) {
            nextKey = String.valueOf(keys.next());
            returnProps.setProperty(String.valueOf(nextKey), this.transformerProperties.getProperty(nextKey));
        }
        Log.debug(50, "XMLTransformer.getCurrentTransformerProperties() returning " + returnProps);
        return returnProps;
    }

    public Enumeration getTransformerPropertyNames() {
        return this.transformerProperties.propertyNames();
    }

    public String getTransformerProperty(String key) {
        if (key == null) {
            return null;
        }
        return this.transformerProperties.getProperty(key);
    }

    private void throwIOException(Throwable e, String type) throws IOException {
        String msg = "\nXMLTransformer - IOException. Nested " + type + " = " + e.getMessage() + "\n";
        e.printStackTrace();
        Log.debug(12, msg);
        IOException ioe = new IOException(msg);
        ioe.fillInStackTrace();
        throw ioe;
    }

    private Reader getStyleSheetReader(String identifier) throws IOException {
        try {
            this.getXSLTResolverService();
        }
        catch (ServiceNotHandledException ee) {
            Log.debug(0, "Error acquiring XSLT Resolver plugin: " + ee);
            ee.printStackTrace();
            return new InputStreamReader(this.classLoader.getResourceAsStream(this.GENERIC_STYLESHEET));
        }
        Reader xsltReader = null;
        try {
            xsltReader = resolver.getXSLTStylesheetReader(identifier);
        }
        catch (DocumentNotFoundException d) {
            String msg = "XMLTransformer.getStyleSheetReader(): Nested DocumentNotFoundException = " + d.getMessage() + "\n";
            d.printStackTrace();
            Log.debug(12, msg);
            IOException ioe = new IOException(msg);
            ioe.fillInStackTrace();
            throw ioe;
        }
        return xsltReader;
    }

    private String getStyleSheetLocation(String identifier) {
        try {
            this.getXSLTResolverService();
        }
        catch (ServiceNotHandledException ee) {
            Log.debug(0, "Error acquiring XSLT Resolver plugin: " + ee);
            ee.printStackTrace();
            return this.GENERIC_LOCATION;
        }
        return resolver.getXSLTStylesheetLocation(identifier);
    }

    private XSLTResolverInterface getXSLTResolverService() throws ServiceNotHandledException {
        if (resolver == null) {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(XSLTResolverInterface.class);
            resolver = (XSLTResolverInterface)((Object)provider);
        }
        return resolver;
    }

    class InnerCatalog
    extends Catalog {
        InnerCatalog() {
        }

        public String resolvePublic(String publicID, String systemID) throws MalformedURLException, IOException {
            String resolution = super.resolvePublic(publicID, systemID);
            Log.debug(50, "InnerCatalog.resolvePublic(): " + resolution);
            latestDocID = resolution;
            return resolution;
        }
    }

    class CustomURIResolver
    implements URIResolver {
        private final String STYLESHEET_LOCATION;
        private final StringBuffer resolution;

        protected CustomURIResolver() {
            this.STYLESHEET_LOCATION = XMLTransformer.this.config.get("genericStylesheetLocation", 0);
            this.resolution = new StringBuffer();
        }

        protected CustomURIResolver(String location) {
            this.STYLESHEET_LOCATION = location;
            this.resolution = new StringBuffer();
        }

        public Source resolve(String href, String base) throws TransformerException {
            Log.debug(50, "CustomURIResolver.resolve() received href=" + href + " and base=" + base);
            this.resolution.delete(0, this.resolution.length());
            this.resolution.append(this.STYLESHEET_LOCATION);
            this.resolution.append("/");
            this.resolution.append(href);
            InputStream stream = XMLTransformer.this.classLoader.getResourceAsStream(this.resolution.toString());
            Log.debug(50, "CustomURIResolver.resolve() returning StreamSource \nfor InputStream = " + stream + "\nfor path = " + this.resolution.toString());
            return new StreamSource(stream);
        }
    }

    class CustomErrorListener
    implements ErrorListener {
        CustomErrorListener() {
        }

        public void error(TransformerException exception) throws TransformerException {
            this.handleException(exception, "TRANSFORMATION ERROR");
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            this.handleException(exception, "TRANSFORMATION FATAL ERROR");
        }

        public void warning(TransformerException exception) throws TransformerException {
            this.handleException(exception, "TRANSFORMATION WARNING");
        }

        private void handleException(TransformerException exception, String errMessage) throws TransformerException {
            Log.debug(2, "Error reading documentation files;\n" + exception.getMessage());
            Log.debug(12, "\n* * * XMLTransformer$CustomErrorListener: " + errMessage + ": " + exception.getMessage());
            exception.fillInStackTrace();
            throw exception;
        }
    }

    class CustomErrorHandler
    implements ErrorHandler {
        CustomErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.handleException(exception, "SAX ERROR");
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.handleException(exception, "SAX FATAL ERROR");
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.handleException(exception, "SAX WARNING");
        }

        private void handleException(SAXParseException exception, String errMessage) throws SAXException {
            Log.debug(2, "Error reading documentation files;\n" + exception.getMessage());
            Log.debug(12, "XMLTransformer$CustomErrorHandler: " + errMessage + ": " + exception.getMessage());
            exception.fillInStackTrace();
            throw exception;
        }
    }
}

