/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.util.ColumnSortableTableModel;
import edu.ucsb.nceas.morpho.util.SortTableCommand;
import edu.ucsb.nceas.morpho.util.SortableTableHeaderCellRenderer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

public class SortableJTable
extends JTable
implements MouseListener {
    public static final String ASCENDING = "ascending";
    public static final String DECENDING = "decending";
    public static final String NONORDERED = "nonodered";
    private boolean sorted;
    private int indexOfSortedColumn;
    private String orderOfSortedColumn;
    private JTableHeader tableHeader;

    public SortableJTable() {
    }

    public SortableJTable(ColumnSortableTableModel model) {
        super(model);
        this.init();
    }

    private void init() {
        this.sorted = false;
        this.indexOfSortedColumn = -1;
        this.orderOfSortedColumn = NONORDERED;
        this.tableHeader = this.getTableHeader();
        this.tableHeader.setDefaultRenderer(new SortableTableHeaderCellRenderer());
        this.tableHeader.addMouseListener(this);
    }

    public void setModel(ColumnSortableTableModel model) {
        super.setModel(model);
        this.init();
    }

    public void resetModel(ColumnSortableTableModel model) {
        super.setModel(model);
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSorted(boolean mySorted) {
        this.sorted = mySorted;
    }

    public int getIndexOfSortedColumn() {
        return this.indexOfSortedColumn;
    }

    public void setIndexOfSortedColumn(int myIndex) {
        this.indexOfSortedColumn = myIndex;
    }

    public String getOrderOfSortedColumn() {
        return this.orderOfSortedColumn;
    }

    public void setOrderOfSortedColumn(String myOrder) {
        this.orderOfSortedColumn = myOrder;
    }

    public void mouseClicked(MouseEvent event) {
        SortTableCommand sortCommand = null;
        int index = this.columnAtPoint(new Point(event.getX(), event.getY()));
        String order = null;
        order = !this.sorted ? ASCENDING : (this.indexOfSortedColumn == index && this.orderOfSortedColumn.equals(ASCENDING) ? DECENDING : ASCENDING);
        sortCommand = new SortTableCommand(this, index, order);
        sortCommand.execute(null);
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }
}

