/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TemporalPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class Temporal
extends AbstractUIPage {
    private final String pageID = "TEMPORAL";
    private final String nextPageID = "TAXONOMIC";
    private final String title = "Temporal Coverage";
    private final String subtitle = "";
    private final String xPathRoot = "/eml:eml/dataset/coverage/temporalCoverage[";
    private final String pageNumber = "11";
    private final String[] colNames = new String[]{"Time Coverages"};
    private final Object[] editors = null;
    private CustomList timespanList;
    private OrderedMap returnMap = new OrderedMap();

    public Temporal() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        Temporal vbox = this;
        vbox.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc = WidgetFactory.makeHTMLLabel("<b>Enter information about temporal coverage.</b> Temporal coverage can be specified as a single point in time, multiple points in time, or a range thereof. ", 3);
        vbox.add(desc);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        vbox.add(WidgetFactory.makeDefaultSpacer());
        this.timespanList = WidgetFactory.makeList(this.colNames, this.editors, 4, true, true, false, true, true, true);
        this.timespanList.setBorder(new EmptyBorder(0, 5, 5, 10));
        vbox.add(this.timespanList);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        this.initActions();
    }

    private void initActions() {
        this.timespanList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nTemporal: CustomAddAction called");
                Temporal.this.showNewTemporalDialog();
            }
        });
        this.timespanList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nTemporal: CustomEditAction called");
                Temporal.this.showEditTemporalDialog();
            }
        });
    }

    private void showNewTemporalDialog() {
        TemporalPage temporalPage = (TemporalPage)WizardPageLibrary.getPage("TEMPORAL_PAGE");
        ModalDialog wpd = new ModalDialog(temporalPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = temporalPage.getSurrogate();
            newRow.add(temporalPage);
            this.timespanList.addRow(newRow);
        }
    }

    private void showEditTemporalDialog() {
        List selRowList = this.timespanList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 2) {
            return;
        }
        Object dialogObj = selRowList.get(1);
        if (dialogObj == null || !(dialogObj instanceof TemporalPage)) {
            return;
        }
        TemporalPage editTemporalPage = (TemporalPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editTemporalPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editTemporalPage.getSurrogate();
            newRow.add(editTemporalPage);
            this.timespanList.replaceSelectedRow(newRow);
        }
    }

    public void onLoadAction() {
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public OrderedMap getPageData(String xPath) {
        this.returnMap.clear();
        int index = 1;
        Object nextRowObj2 = null;
        List nextRowList = null;
        Object nextUserObject = null;
        OrderedMap nextNVPMap = null;
        TemporalPage nextTemporalPage = null;
        List rowLists = this.timespanList.getListOfRowLists();
        if (rowLists != null && rowLists.isEmpty()) {
            return null;
        }
        for (Object nextRowObj2 : rowLists) {
            if (nextRowObj2 == null || (nextRowList = (List)nextRowObj2).size() < 2 || (nextUserObject = nextRowList.get(1)) == null) continue;
            nextTemporalPage = nextUserObject;
            nextNVPMap = nextTemporalPage.getPageData(xPath + index++ + "]");
            this.returnMap.putAll((Map)nextNVPMap);
        }
        System.out.println("TemporalPage returning - " + this.returnMap.toString());
        this.timespanList.removeAllRows();
        return this.returnMap;
    }

    public OrderedMap getPageData() {
        return this.getPageData("/eml:eml/dataset/coverage/temporalCoverage[");
    }

    public String getPageID() {
        return "TEMPORAL";
    }

    public String getTitle() {
        return "Temporal Coverage";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        return "TAXONOMIC";
    }

    public String getPageNumber() {
        return "11";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        if (xPathRoot.equals("removeAllRows")) {
            this.timespanList.removeAllRows();
        }
        boolean res = true;
        TemporalPage temporalPage = (TemporalPage)WizardPageLibrary.getPage("TEMPORAL_PAGE");
        data.remove((Object)"/temporalCoverage/@scope");
        data.remove((Object)"/temporalCoverage/@id");
        boolean flag = temporalPage.setPageData(data, "/temporalCoverage");
        if (!flag) {
            res = false;
        }
        List newRow = temporalPage.getSurrogate();
        newRow.add(temporalPage);
        this.timespanList.addRow(newRow);
        return res;
    }
}

