/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CodeDefnPanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonImportPanel;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodeDefinition
extends AbstractUIPage {
    public final String pageID = "CODE_DEFINITION";
    public String nextPageID = "CODE_IMPORT_SUMMARY";
    public final String pageNumber = "";
    public final String title = "Code Defintions Import Page";
    public final String subtitle = "Define the columns for the codes and definitions";
    private WizardContainerFrame mainWizFrame;
    private OrderedMap resultsMap;
    private CodeDefnPanel importPanel = null;
    private JTextField attrField;
    private JTextField entityField;
    private AbstractDataPackage adp = null;

    public CodeDefinition(WizardContainerFrame mainWizFrame) {
        this.mainWizFrame = mainWizFrame;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        JLabel label = WidgetFactory.makeHTMLLabel("Identify the columns of the new data table that contain the Codes and Definitions for the following Attribute - ", 1, false);
        JLabel attrLabel = WidgetFactory.makeLabel("Attribute Name:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.attrField = WidgetFactory.makeOneLineTextField();
        this.attrField.setEditable(false);
        JPanel attrPanel = WidgetFactory.makePanel();
        attrPanel.add(attrLabel);
        attrPanel.add(this.attrField);
        JLabel entityLabel = WidgetFactory.makeLabel("Entity Name:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.entityField = WidgetFactory.makeOneLineTextField();
        this.entityField.setEditable(false);
        JPanel entityPanel = WidgetFactory.makePanel();
        entityPanel.add(entityLabel);
        entityPanel.add(this.entityField);
        infoPanel.add(label);
        infoPanel.add(WidgetFactory.makeDefaultSpacer());
        infoPanel.add(attrPanel);
        infoPanel.add(WidgetFactory.makeDefaultSpacer());
        infoPanel.add(entityPanel);
        infoPanel.add(WidgetFactory.makeDefaultSpacer());
        this.add((Component)infoPanel, "North");
        this.importPanel = new CodeDefnPanel(true, false);
        this.add((Component)this.importPanel, "Center");
    }

    public void onLoadAction() {
        this.adp = this.getADP();
        if (this.adp == null) {
            Log.debug(10, "Error! Unable to obtain the ADP in CodeDefinition page!");
            return;
        }
        String attr = this.adp.getCurrentImportAttributeName();
        String entity = this.adp.getCurrentImportEntityName();
        this.attrField.setText(attr);
        this.entityField.setText(entity);
        String tableName = this.adp.getLastImportedEntity();
        List attrs = this.adp.getLastImportedAttributes();
        Vector rowData = this.adp.getLastImportedDataSet();
        this.importPanel.setTable(tableName, attrs, rowData);
        this.importPanel.invalidate();
        this.adp.setLastImportedAttributes(null);
        this.adp.setLastImportedEntity(null);
        this.adp.setLastImportedDataSet(null);
        String prevPageID = this.mainWizFrame.getPreviousPageID();
        if (prevPageID.equals("TEXT_IMPORT_WIZARD") || prevPageID.equals("ENTITY")) {
            Node newDOM = this.mainWizFrame.collectDataFromPages();
            Node entNode = null;
            String entityXpath = "";
            try {
                entityXpath = XMLUtilities.getTextNodeWithXPath((Node)this.adp.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/entities").getNodeValue();
                NodeList entityNodes = XMLUtilities.getNodeListWithXPath((Node)newDOM, (String)entityXpath);
                entNode = entityNodes.item(0);
            }
            catch (Exception w) {
                Log.debug(5, "Error in trying to get entNode in ImportDataCommand");
            }
            Entity entityNode = new Entity(entNode);
            Log.debug(30, "Adding Entity object to AbstractDataPackage..");
            this.adp.addEntity(entityNode);
            this.adp.setLocation("");
            if (prevPageID.equals("ENTITY") && rowData == null) {
                File entityFile;
                int entityIdx = this.adp.getEntityCount() - 1;
                boolean text_file = false;
                String format = this.adp.getPhysicalFormat(entityIdx, 0);
                if (format.indexOf("Text") > -1 || format.indexOf("text") > -1 || format.indexOf("Asci") > -1 || format.indexOf("asci") > -1) {
                    text_file = true;
                }
                MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
                DataViewContainerPanel resultPane = null;
                Morpho morpho = null;
                if (morphoFrame != null) {
                    resultPane = morphoFrame.getDataViewContainerPanel();
                }
                if (resultPane != null) {
                    morpho = resultPane.getFramework();
                }
                if ((entityFile = CodeDefnPanel.getEntityFile(morpho, this.adp, entityIdx)) == null) {
                    return;
                }
                Vector<Integer> colsToExtract = new Vector<Integer>();
                for (int ci = 0; ci < attrs.size(); ++ci) {
                    colsToExtract.add(new Integer(ci));
                }
                int numHeaderLines = 0;
                String field_delimiter = this.adp.getPhysicalFieldDelimiter(entityIdx, 0);
                String delimiter = this.getDelimiterString(field_delimiter);
                boolean ignoreConsecutiveDelimiters = this.adp.ignoreConsecutiveDelimiters(entityIdx, 0);
                List<ArrayList<String>> data = null;
                if (text_file) {
                    data = CodeDefnPanel.getColumnValues(entityFile, colsToExtract, numHeaderLines, delimiter, ignoreConsecutiveDelimiters, 25);
                } else {
                    data = new ArrayList();
                    ArrayList<String> row1 = new ArrayList<String>();
                    for (int ci = 0; ci < colsToExtract.size(); ++ci) {
                        row1.add("**nontext**");
                    }
                    data.add(row1);
                }
                rowData = new Vector();
                TaxonImportPanel.addColumnsToRowData(rowData, data);
                this.importPanel.setTable(tableName, attrs, rowData);
                this.importPanel.invalidate();
            }
        }
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        if (this.importPanel.validateUserInput()) {
            OrderedMap map = this.adp.getCurrentImportMap();
            String relativeXPath = this.adp.getCurrentImportXPath();
            String scale = this.adp.getCurrentImportScale().toLowerCase();
            String path = relativeXPath + "/measurementScale/" + scale + "/nonNumericDomain/enumeratedDomain[1]/entityCodeList";
            Iterator it = map.keySet().iterator();
            String prefix = "";
            int pos = -1;
            while (it.hasNext()) {
                String k1 = (String)it.next();
                pos = k1.indexOf("/entityReference");
                if (pos <= -1) continue;
                prefix = k1.substring(0, pos);
                break;
            }
            if (pos == -1) {
                Log.debug(15, "Error in CodeDefintion!! map doesnt have the entityReference key");
            } else {
                map.remove((Object)(prefix + "/entityReference"));
                map.remove((Object)(prefix + "/valueAttributeReference"));
                map.remove((Object)(prefix + "/definitionAttributeReference"));
                OrderedMap importMap = this.importPanel.getPanelData(prefix);
                map.putAll((Map)importMap);
            }
            return true;
        }
        return false;
    }

    private AbstractDataPackage getADP() {
        AbstractDataPackage dp = UIController.getInstance().getCurrentAbstractDataPackage();
        return dp;
    }

    public OrderedMap getPageData() {
        return this.resultsMap;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    public String getPageID() {
        return "CODE_DEFINITION";
    }

    public String getTitle() {
        return "Code Defintions Import Page";
    }

    public String getSubtitle() {
        return "Define the columns for the codes and definitions";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return "";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }

    private String getDelimiterString(String field_delimiter) {
        String str = "";
        String temp = field_delimiter.trim();
        if (temp.startsWith("#x")) {
            if ((temp = temp.substring(2)).equals("0A")) {
                str = "\n";
            }
            if (temp.equals("09")) {
                str = "\t";
            }
            if (temp.equals("20")) {
                str = " ";
            }
        } else {
            str = temp;
        }
        return str;
    }
}

