/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.DataPackageWizardPlugin;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.ArticlePanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.BookPanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.PartyPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.ReportPanel;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Node;

public class CitationPage
extends AbstractUIPage {
    private final String pageID = "CITATION";
    private final String nextPageID = "";
    private final String pageNumber = "";
    private final String title = "Citation Page";
    private final String subtitle = "";
    private String TAXON_CITATION_CREATOR_ROOTXPATH = "creator";
    private String TAXON_CITATION_CREATOR_GENERIC_NAME = "taxon_citation_creator";
    private JLabel titleLabel;
    private JTextField titleField;
    private JLabel authorLabel;
    private CustomList authorList;
    private final String[] authorListNames = new String[]{"Party", "Role", "Address"};
    private final Object[] editors = null;
    private JLabel pubDateLabel;
    private JTextField pubDateField;
    private JPanel radioPanel;
    private JLabel citationTypeLabel;
    private JPanel bookPanel;
    private JPanel articlePanel;
    private JPanel reportPanel;
    private JPanel currentPanel;
    private JPanel middlePanel;
    private JPanel topMiddlePanel;
    private String xPathRoot = "";
    private final String[] typeElemNames = new String[3];
    private static String citationType = "";
    public static final int CITATIONTYPE_BOOK = 0;
    public static final int CITATIONTYPE_ARTICLE = 1;
    public static final int CITATIONTYPE_REPORT = 2;
    private static final int MAX_AUTHOR_NAMES_SHOWN = 2;
    private static final int BORDERED_PANEL_TOT_ROWS = 5;
    private final int PADDING = 5;
    private OrderedMap returnMap;

    public CitationPage() {
        this.initNames();
        this.init();
    }

    private void initNames() {
        this.typeElemNames[0] = "Book";
        this.typeElemNames[1] = "Article";
        this.typeElemNames[2] = "Report";
    }

    private void init() {
        this.middlePanel = new JPanel();
        this.topMiddlePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.middlePanel, "Center");
        this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 1));
        this.middlePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 15));
        this.topMiddlePanel.setLayout(new BoxLayout(this.topMiddlePanel, 1));
        this.topMiddlePanel.add(WidgetFactory.makeHTMLLabel("<font size=\"4\"><b>Define the Citation Details:</b></font>", 1));
        this.topMiddlePanel.add(WidgetFactory.makeDefaultSpacer());
        JPanel titlePanel = WidgetFactory.makePanel(1);
        this.titleLabel = WidgetFactory.makeLabel("Title:", true);
        titlePanel.add(this.titleLabel);
        this.titleField = WidgetFactory.makeOneLineTextField();
        titlePanel.add(this.titleField);
        titlePanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.topMiddlePanel.add(titlePanel);
        this.topMiddlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel authorPanel = WidgetFactory.makePanel(-1);
        this.authorLabel = WidgetFactory.makeLabel("Author(s):", true);
        authorPanel.add(this.authorLabel);
        this.authorList = WidgetFactory.makeList(this.authorListNames, this.editors, -1, true, true, false, true, true, true);
        this.authorList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CitationPage.this.updateDOMFromListOfPages();
                CitationPage.this.showNewAuthorPartyDialog();
            }
        });
        this.authorList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CitationPage.this.updateDOMFromListOfPages();
                CitationPage.this.showEditAuthorPartyDialog();
            }
        });
        authorPanel.add(this.authorList);
        authorPanel.setMaximumSize(new Dimension(2000, 165));
        authorPanel.setPreferredSize(new Dimension(2000, 165));
        this.topMiddlePanel.add(authorPanel);
        JPanel pubDatePanel = WidgetFactory.makePanel(1);
        this.pubDateLabel = WidgetFactory.makeLabel("Publication Date:", false);
        pubDatePanel.add(this.pubDateLabel);
        this.pubDateField = WidgetFactory.makeOneLineTextField();
        pubDatePanel.add(this.pubDateField);
        pubDatePanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.topMiddlePanel.add(pubDatePanel);
        JPanel dataHelpPanel = WidgetFactory.makePanel(1);
        JLabel spacer = WidgetFactory.makeLabel("", false);
        JLabel datehelp = WidgetFactory.makeHTMLLabel("Use the YYYY-MM-DD format - (e.g. 1989-02-24)", 1);
        dataHelpPanel.add(spacer);
        dataHelpPanel.add(datehelp);
        this.topMiddlePanel.add(dataHelpPanel);
        this.topMiddlePanel.add(WidgetFactory.makeHalfSpacer());
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                if (e.getActionCommand().equals(CitationPage.this.typeElemNames[0])) {
                    CitationPage.this.setCitationTypeUI(CitationPage.this.bookPanel);
                    CitationPage.this.setCitationType(CitationPage.this.typeElemNames[0]);
                } else if (e.getActionCommand().equals(CitationPage.this.typeElemNames[1])) {
                    CitationPage.this.setCitationTypeUI(CitationPage.this.articlePanel);
                    CitationPage.this.setCitationType(CitationPage.this.typeElemNames[1]);
                } else if (e.getActionCommand().equals(CitationPage.this.typeElemNames[2])) {
                    CitationPage.this.setCitationTypeUI(CitationPage.this.reportPanel);
                    CitationPage.this.setCitationType(CitationPage.this.typeElemNames[2]);
                }
            }
        };
        this.citationTypeLabel = WidgetFactory.makeLabel("Category:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.radioPanel = WidgetFactory.makeRadioPanel(this.typeElemNames, -1, listener);
        JPanel outerRadioPanel = new JPanel();
        outerRadioPanel.setLayout(new BoxLayout(outerRadioPanel, 0));
        outerRadioPanel.add(this.citationTypeLabel);
        outerRadioPanel.add(this.radioPanel);
        this.topMiddlePanel.add(outerRadioPanel);
        this.topMiddlePanel.setMaximumSize(this.topMiddlePanel.getPreferredSize());
        this.topMiddlePanel.setPreferredSize(this.topMiddlePanel.getPreferredSize());
        this.topMiddlePanel.setMinimumSize(this.topMiddlePanel.getPreferredSize());
        this.middlePanel.add(this.topMiddlePanel);
        this.currentPanel = this.getEmptyPanel();
        this.middlePanel.add(this.currentPanel);
        this.middlePanel.add(Box.createGlue());
        this.bookPanel = this.getBookPanel();
        this.articlePanel = this.getArticlePanel();
        this.reportPanel = this.getReportPanel();
        this.setCitationType("");
        this.refreshUI();
    }

    private void showNewAuthorPartyDialog() {
        PartyPage partyPage = (PartyPage)WizardPageLibrary.getPage("PARTY_CITATION_AUTHOR");
        ModalDialog wpd = new ModalDialog(partyPage, WizardContainerFrame.getDialogParent(), 740, 540);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = partyPage.getSurrogate();
            newRow.add(partyPage);
            this.authorList.addRow(newRow);
            if (partyPage.editingOriginalRef) {
                this.updateOriginalRefPartyPage(partyPage);
            }
            this.updateDOMFromListOfPages();
            this.refreshAuthorList();
        }
        WidgetFactory.unhiliteComponent(this.authorLabel);
    }

    private void showEditAuthorPartyDialog() {
        List selRowList = this.authorList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 4) {
            return;
        }
        Object dialogObj = selRowList.get(3);
        if (dialogObj == null || !(dialogObj instanceof PartyPage)) {
            return;
        }
        PartyPage editPartyPage = (PartyPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editPartyPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editPartyPage.getSurrogate();
            newRow.add(editPartyPage);
            this.authorList.replaceSelectedRow(newRow);
            if (editPartyPage.editingOriginalRef) {
                this.updateOriginalRefPartyPage(editPartyPage);
            }
            this.updateDOMFromListOfPages();
            this.refreshAuthorList();
        }
    }

    private void updateOriginalRefPartyPage(PartyPage partyPage) {
        String originalRefID = partyPage.getReferencesNodeIDString();
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(15, "\npackage from UIController is null");
            Log.debug(5, "ERROR: cannot update!");
            return;
        }
        List nextRowList2 = null;
        PartyPage nextPage = null;
        for (List nextRowList2 : this.authorList.getListOfRowLists()) {
            if (nextRowList2.size() < 4 || (nextPage = (PartyPage)nextRowList2.get(3)) == null || !nextPage.getRefID().equals(originalRefID)) continue;
            Node root = adp.getSubtreeAtReference(originalRefID);
            OrderedMap map = XMLUtilities.getDOMTreeAsXPathMap((Node)root);
            Log.debug(45, "updateOriginalRefPartyPage() got a match with ID: " + originalRefID + "; map = " + map);
            if (map == null || map.isEmpty()) {
                return;
            }
            boolean checkParty = nextPage.setPageData(map, "/" + this.TAXON_CITATION_CREATOR_ROOTXPATH);
        }
    }

    private void updateDOMFromListOfPages() {
        List nextRowList2 = null;
        ArrayList<AbstractUIPage> pagesList = new ArrayList<AbstractUIPage>();
        AbstractUIPage nextPage = null;
        for (List nextRowList2 : this.authorList.getListOfRowLists()) {
            if (nextRowList2.size() < 4 || (nextPage = (AbstractUIPage)nextRowList2.get(3)) == null) continue;
            pagesList.add(nextPage);
        }
        DataPackageWizardPlugin.deleteExistingAndAddPageDataToDOM(UIController.getInstance().getCurrentAbstractDataPackage(), pagesList, this.TAXON_CITATION_CREATOR_ROOTXPATH, this.TAXON_CITATION_CREATOR_GENERIC_NAME);
    }

    private boolean populatePartiesList(List personnelOrderedMapList, String personnelXPathRoot) {
        Iterator persIt = personnelOrderedMapList.iterator();
        OrderedMap nextPersonnelMap = null;
        int partyPredicate = 1;
        this.authorList.removeAllRows();
        boolean partyRetVal = true;
        while (persIt.hasNext()) {
            nextPersonnelMap = (OrderedMap)persIt.next();
            if (nextPersonnelMap == null || nextPersonnelMap.isEmpty()) continue;
            PartyPage nextParty = (PartyPage)WizardPageLibrary.getPage("PARTY_CITATION_AUTHOR");
            boolean checkParty = nextParty.setPageData(nextPersonnelMap, personnelXPathRoot + partyPredicate++ + "]");
            if (!checkParty) {
                partyRetVal = false;
            }
            List newRow = nextParty.getSurrogate();
            newRow.add(nextParty);
            this.authorList.addRow(newRow);
        }
        return partyRetVal;
    }

    private void setCitationType(String type) {
        citationType = type;
    }

    private void setCitationTypeUI(JPanel panel) {
        this.middlePanel.remove(this.currentPanel);
        this.currentPanel = panel;
        this.middlePanel.add(this.currentPanel);
        this.topMiddlePanel.setMaximumSize(this.topMiddlePanel.getPreferredSize());
        this.topMiddlePanel.setMinimumSize(this.topMiddlePanel.getPreferredSize());
        ((WizardPageSubPanelAPI)((Object)this.currentPanel)).onLoadAction();
        this.currentPanel.invalidate();
        this.currentPanel.validate();
        this.currentPanel.repaint();
        this.topMiddlePanel.validate();
        this.topMiddlePanel.repaint();
        this.middlePanel.validate();
        this.middlePanel.repaint();
    }

    private JPanel getEmptyPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(5);
        panel.add(WidgetFactory.makeDefaultSpacer());
        return panel;
    }

    private BookPanel getBookPanel() {
        BookPanel panel = new BookPanel(this);
        WidgetFactory.addTitledBorder(panel, this.typeElemNames[0]);
        return panel;
    }

    private ArticlePanel getArticlePanel() {
        ArticlePanel panel = new ArticlePanel(this);
        WidgetFactory.addTitledBorder(panel, this.typeElemNames[1]);
        return panel;
    }

    private ReportPanel getReportPanel() {
        ReportPanel panel = new ReportPanel(this);
        WidgetFactory.addTitledBorder(panel, this.typeElemNames[2]);
        return panel;
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public void refreshUI() {
        this.currentPanel.validate();
        this.currentPanel.repaint();
        this.middlePanel.validate();
        this.middlePanel.repaint();
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
        this.refreshAuthorList();
    }

    private void refreshAuthorList() {
        List rows = this.authorList.getListOfRowLists();
        for (int i = 0; i < rows.size(); ++i) {
            Object dialogObj;
            List row = (List)rows.get(i);
            if (row.size() < 4 || (dialogObj = row.get(3)) == null || !(dialogObj instanceof PartyPage)) continue;
            PartyPage editPartyPage = (PartyPage)dialogObj;
            OrderedMap map = editPartyPage.getPageData("/creator[1]");
            editPartyPage.setPageData(map, "/creator[1]");
            List newRow = editPartyPage.getSurrogate();
            newRow.add(editPartyPage);
            this.authorList.replaceRow(i, newRow);
        }
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Citation Page";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    public boolean onAdvanceAction() {
        if (this.titleField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.titleLabel);
            this.titleField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.titleLabel);
        if (this.authorList.getRowCount() == 0) {
            WidgetFactory.hiliteComponent(this.authorLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.authorLabel);
        if (citationType == null || citationType.trim().equals("")) {
            WidgetFactory.hiliteComponent(this.citationTypeLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.citationTypeLabel);
        return ((WizardPageSubPanelAPI)((Object)this.currentPanel)).validateUserInput();
    }

    public List getSurrogate() {
        ArrayList<String> surrogate = new ArrayList<String>();
        surrogate.add(this.titleField.getText());
        Iterator it = this.authorList.getListOfRowLists().iterator();
        String creator = "";
        int cnt = 0;
        while (it.hasNext()) {
            if (cnt == 2) {
                creator = creator + " ...";
                break;
            }
            List row = (List)it.next();
            String party = (String)row.get(0);
            int idx = party.indexOf(",");
            if (idx >= 0) {
                party = party.substring(0, idx);
            }
            creator = creator + party;
            if (cnt < 1 && it.hasNext()) {
                creator = creator + ", ";
            }
            ++cnt;
        }
        surrogate.add(creator);
        surrogate.add(citationType);
        return surrogate;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String xPath) {
        OrderedMap newMap;
        OrderedMap map = new OrderedMap();
        map.put((Object)(xPath + "/title[1]"), (Object)this.titleField.getText());
        Iterator it = this.authorList.getListOfRowLists().iterator();
        int idx = 1;
        while (it.hasNext()) {
            List row = (List)it.next();
            if (row.size() < 4) continue;
            PartyPage party = (PartyPage)row.get(3);
            OrderedMap partyMap = party.getPageData(xPath + "/creator[" + idx + "]");
            map.putAll((Map)partyMap);
            ++idx;
        }
        String pubn = this.pubDateField.getText();
        if (!pubn.trim().equals("")) {
            map.put((Object)(xPath + "/pubDate[1]"), (Object)pubn);
        }
        if (citationType.equals("Book")) {
            newMap = ((WizardPageSubPanelAPI)((Object)this.bookPanel)).getPanelData(xPath + "/book[1]");
            map.putAll((Map)newMap);
        } else if (citationType.equals("Article")) {
            newMap = ((WizardPageSubPanelAPI)((Object)this.articlePanel)).getPanelData(xPath + "/article[1]");
            map.putAll((Map)newMap);
        } else if (citationType.equals("Report")) {
            newMap = ((WizardPageSubPanelAPI)((Object)this.reportPanel)).getPanelData(xPath + "/report[1]");
            map.putAll((Map)newMap);
        }
        return map;
    }

    private String findCitationType(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/book[1]/publisher[1]/organizationName[1]"));
        if (o1 != null) {
            return "Book";
        }
        o1 = map.get((Object)(xPath + "/article[1]/journal[1]"));
        if (o1 != null) {
            return "Article";
        }
        o1 = map.get((Object)(xPath + "/report[1]/publisher[1]/organizationName[1]"));
        if (o1 != null) {
            return "Report";
        }
        o1 = map.get((Object)(xPath + "/report[1]/reportNumber[1]"));
        if (o1 != null) {
            return "Report";
        }
        o1 = map.get((Object)(xPath + "/report[1]/totalPages[1]"));
        if (o1 != null) {
            return "Report";
        }
        return "";
    }

    private boolean mapContainsCreator(OrderedMap map, String xPath, int idx) {
        boolean b = map.containsKey((Object)(xPath + "/creator[" + idx + "]/references[1]"));
        if (b) {
            return true;
        }
        b = map.containsKey((Object)(xPath + "/creator[" + idx + "]/references"));
        if (b) {
            return true;
        }
        b = map.containsKey((Object)(xPath + "/creator[" + idx + "]/individualName/surName[1]"));
        if (b) {
            return true;
        }
        b = map.containsKey((Object)(xPath + "/creator[" + idx + "]/individualName[1]/surName[1]"));
        if (b) {
            return true;
        }
        b = map.containsKey((Object)(xPath + "/creator[" + idx + "]/organizationName[1]"));
        if (b) {
            return true;
        }
        b = map.containsKey((Object)(xPath + "/creator[" + idx + "]/positionName[1]"));
        return b;
    }

    public boolean setPageData(OrderedMap map, String xPath) {
        this.titleField.setText((String)map.get((Object)(xPath + "/title[1]")));
        map.remove((Object)(xPath + "/title[1]"));
        int idx = 1;
        while (this.mapContainsCreator(map, xPath, idx)) {
            OrderedMap copyMap = this.getNewCreatorMap(map, xPath, idx);
            PartyPage page = (PartyPage)WizardPageLibrary.getPage("PARTY_CITATION_AUTHOR");
            page.setPageData(copyMap, xPath + "/creator[" + idx + "]");
            List row = page.getSurrogate();
            row.add(page);
            this.authorList.addRow(row);
            ++idx;
        }
        String pubn = (String)map.get((Object)(xPath + "/pubDate[1]"));
        if (pubn != null) {
            this.pubDateField.setText(pubn);
            map.remove((Object)(xPath + "/pubDate[1]"));
        }
        citationType = this.findCitationType(map, xPath);
        int componentNum = -1;
        if (citationType.equals("Book")) {
            componentNum = 0;
            this.setCitationType("Book");
            this.setCitationTypeUI(this.bookPanel);
            ((WizardPageSubPanelAPI)((Object)this.bookPanel)).setPanelData(xPath + "/book[1]", map);
        } else if (citationType.equals("Article")) {
            componentNum = 1;
            this.setCitationType("Article");
            this.setCitationTypeUI(this.articlePanel);
            ((WizardPageSubPanelAPI)((Object)this.articlePanel)).setPanelData(xPath + "/article[1]", map);
        } else if (citationType.equals("Report")) {
            componentNum = 2;
            this.setCitationType("Report");
            this.setCitationTypeUI(this.reportPanel);
            ((WizardPageSubPanelAPI)((Object)this.reportPanel)).setPanelData(xPath + "/report[1]", map);
        }
        if (componentNum != -1) {
            Container c = (Container)this.radioPanel.getComponent(1);
            JRadioButton jrb = (JRadioButton)c.getComponent(componentNum);
            jrb.setSelected(true);
        }
        this.refreshUI();
        return true;
    }

    private OrderedMap getNewCreatorMap(OrderedMap map, String xPath, int idx) {
        OrderedMap newMap = new OrderedMap();
        String searchString = xPath + "/creator[" + idx + "]";
        for (String k : map.keySet()) {
            if (!k.startsWith(searchString)) continue;
            newMap.put((Object)k, (Object)((String)map.get((Object)k)));
        }
        return newMap;
    }
}

