/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardListener;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Node;

public class WizardContainerFrame
extends JFrame {
    public static JFrame frame;
    private DataPackageWizardListener listener;
    private Node domToReturn;
    private boolean domPresentToReturn = false;
    private InputMap imap;
    private ActionMap amap;
    private final String ID_ATTR_XPATH = "/@id";
    private final StringBuffer tempBuff = new StringBuffer();
    private final OrderedMap idMap = new OrderedMap();
    private JLabel stepLabel;
    private int PADDING = 5;
    private Container contentPane;
    private JPanel topPanel;
    private JPanel middlePanel;
    private JPanel bottomBorderPanel;
    private JPanel bottomPanel;
    private JLabel titleLabel;
    private JLabel subtitleLabel;
    private JButton nextButton;
    private JButton prevButton;
    private JButton finishButton;
    private AbstractUIPage currentPage;
    private Stack pageStack;
    private WizardPageLibrary pageLib;
    private boolean showPageCount;
    private Map pageCache;
    private String firstPageID;
    private static JFrame dummyFrame;
    private static JFrame dialogParent;

    public WizardContainerFrame() {
        frame = this;
        this.listener = this.listener;
        this.pageStack = new Stack();
        this.pageLib = new WizardPageLibrary(this);
        this.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WizardContainerFrame.this.cancelAction();
            }
        });
    }

    public void setDataPackageWizardListener(DataPackageWizardListener listener) {
        this.listener = listener;
    }

    public void setCurrentPage(String pageID) {
        Log.debug(45, "setCurrentPage called with String ID: " + pageID);
        if (pageID == null) {
            Log.debug(15, "setCurrentPage called with NULL ID");
            return;
        }
        AbstractUIPage pageForID = WizardPageLibrary.getPage(pageID);
        if (pageForID == null) {
            Log.debug(15, "setCurrentPage: page library does NOT contain ID: " + pageID);
            return;
        }
        if (this.pageStack.isEmpty()) {
            this.firstPageID = pageID;
        }
        this.setCurrentPage(pageForID);
    }

    public void setCurrentPage(AbstractUIPage newPage) {
        if (newPage == null) {
            Log.debug(45, "setCurrentPage called with NULL WizardPage");
            return;
        }
        Log.debug(45, "setCurrentPage called with WizardPage ID = " + newPage.getPageID());
        this.currentPage = newPage;
        this.setpageTitle(newPage.getTitle());
        this.setpageSubtitle(this.getCurrentPage().getSubtitle());
        this.middlePanel.removeAll();
        this.setPageCount();
        this.middlePanel.add((Component)this.getCurrentPage(), "Center");
        this.getCurrentPage().setOpaque(false);
        this.middlePanel.repaint();
        this.updateButtonsStatus();
        this.getCurrentPage().onLoadAction();
    }

    public AbstractUIPage getCurrentPage() {
        return this.currentPage;
    }

    private void setPageCount() {
        if (this.showPageCount) {
            this.stepLabel.setText("Step " + this.getCurrentPage().getPageNumber() + " of " + WizardSettings.NUMBER_OF_STEPS);
        } else {
            this.stepLabel.setText("");
        }
    }

    private void updateButtonsStatus() {
        Log.debug(45, "updateButtonsStatus called");
        if (this.getCurrentPage() == null) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            return;
        }
        this.prevButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        if (this.pageStack.isEmpty() || this.pageStack.peek() == null) {
            this.prevButton.setEnabled(false);
        }
        if (this.getCurrentPage().getNextPageID() == null) {
            this.nextButton.setEnabled(false);
            this.finishButton.setEnabled(true);
            this.finishButton.grabFocus();
        } else {
            this.nextButton.setEnabled(true);
            this.nextButton.grabFocus();
            this.finishButton.setEnabled(false);
        }
    }

    public void setButtonsStatus(boolean prevStatus, boolean nextStatus, boolean finishStatus) {
        this.prevButton.setEnabled(prevStatus);
        this.nextButton.setEnabled(nextStatus);
        this.finishButton.setEnabled(finishStatus);
    }

    private void init() {
        this.pageCache = new HashMap();
        this.initContentPane();
        this.initKeyInputMap();
        this.initTopPanel();
        this.initMiddlePanel();
        this.initBottomPanel();
        this.initButtons();
        this.updateButtonsStatus();
    }

    private void initKeyInputMap() {
        this.imap = new InputMap();
        this.imap.put(KeyStroke.getKeyStroke("ESCAPE"), "cancelKeyAction");
        this.imap.put(KeyStroke.getKeyStroke("alt C"), "cancelKeyAction");
        this.imap.put(KeyStroke.getKeyStroke("LEFT"), "previousKeyAction");
        this.imap.put(KeyStroke.getKeyStroke("alt P"), "previousKeyAction");
        this.imap.put(KeyStroke.getKeyStroke("RIGHT"), "nextKeyAction");
        this.imap.put(KeyStroke.getKeyStroke("alt N"), "nextKeyAction");
        this.amap = new ActionMap();
        this.amap.put("cancelKeyAction", new AbstractAction("cancelKeyAction"){

            public void actionPerformed(ActionEvent evt) {
                Log.debug(45, "cancelKeyAction" + evt.getActionCommand());
                WizardContainerFrame.this.cancelAction();
            }
        });
        this.amap.put("previousKeyAction", new AbstractAction("previousKeyAction"){

            public void actionPerformed(ActionEvent evt) {
                Log.debug(45, "previousKeyAction" + evt.getActionCommand());
                WizardContainerFrame.this.previousAction();
            }
        });
        this.amap.put("nextKeyAction", new AbstractAction("nextKeyAction"){

            public void actionPerformed(ActionEvent evt) {
                Log.debug(45, "nextKeyAction" + evt.getActionCommand());
                WizardContainerFrame.this.nextAction();
            }
        });
    }

    private void initContentPane() {
        this.setIconImage(UISettings.FRAME_AND_TASKBAR_ICON);
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
    }

    private void initTopPanel() {
        Log.debug(45, "WizardContainerFrame starting init()");
        this.titleLabel = new JLabel("");
        this.titleLabel.setFont(WizardSettings.TITLE_FONT);
        this.titleLabel.setForeground(WizardSettings.TITLE_TEXT_COLOR);
        this.titleLabel.setBorder(new EmptyBorder(this.PADDING, 0, this.PADDING, 0));
        this.subtitleLabel = new JLabel("");
        this.subtitleLabel.setFont(WizardSettings.SUBTITLE_FONT);
        this.subtitleLabel.setForeground(WizardSettings.SUBTITLE_TEXT_COLOR);
        this.subtitleLabel.setBorder(new EmptyBorder(this.PADDING, 0, this.PADDING, 0));
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.topPanel.setPreferredSize(WizardSettings.TOP_PANEL_DIMS);
        this.topPanel.setBorder(new EmptyBorder(0, 3 * this.PADDING, 0, 3 * this.PADDING));
        this.topPanel.setBackground(WizardSettings.TOP_PANEL_BG_COLOR);
        this.topPanel.setOpaque(true);
        this.topPanel.add(this.titleLabel);
        this.topPanel.add(this.subtitleLabel);
        this.contentPane.add((Component)this.topPanel, "North");
    }

    private void initMiddlePanel() {
        this.middlePanel = new JPanel();
        this.middlePanel.setLayout(new BorderLayout());
        this.middlePanel.setBorder(new EmptyBorder(this.PADDING, 3 * this.PADDING, this.PADDING, 3 * this.PADDING));
        this.middlePanel.setInputMap(1, this.imap);
        this.middlePanel.setActionMap(this.amap);
        this.contentPane.add((Component)this.middlePanel, "Center");
    }

    private void initBottomPanel() {
        this.bottomBorderPanel = new JPanel();
        this.bottomBorderPanel.setLayout(new BorderLayout(0, 2));
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.setBorder(new EmptyBorder(this.PADDING / 2, 0, 0, 0));
        this.bottomBorderPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, WizardSettings.TOP_PANEL_BG_COLOR));
        this.bottomPanel.setBorder(new EmptyBorder(this.PADDING, this.PADDING, this.PADDING, this.PADDING));
        this.stepLabel = new JLabel();
        this.stepLabel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        this.stepLabel.setText("Step 1 of " + WizardSettings.NUMBER_OF_STEPS);
        this.bottomBorderPanel.add((Component)this.stepLabel, "West");
        this.bottomBorderPanel.add((Component)this.bottomPanel, "Center");
        this.bottomBorderPanel.setInputMap(1, this.imap);
        this.bottomBorderPanel.setActionMap(this.amap);
        this.contentPane.add((Component)this.bottomBorderPanel, "South");
    }

    private void initButtons() {
        this.addButton("Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardContainerFrame.this.cancelAction();
            }
        });
        this.prevButton = this.addButton("< Back", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardContainerFrame.this.previousAction();
            }
        });
        this.nextButton = this.addButton("Next >", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardContainerFrame.this.nextAction();
            }
        });
        this.finishButton = this.addButton("Finish", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardContainerFrame.this.finishAction();
            }
        });
        this.getRootPane().setDefaultButton(this.nextButton);
    }

    public void setShowPageCountdown(boolean show) {
        this.showPageCount = show;
        this.setPageCount();
    }

    public String getFirstPageID() {
        return this.firstPageID;
    }

    public String getPreviousPageID() {
        AbstractUIPage page = this.getPreviousPage();
        if (page == null) {
            return "";
        }
        return page.getPageID();
    }

    public AbstractUIPage getPreviousPage() {
        if (this.pageStack.isEmpty()) {
            return null;
        }
        return (AbstractUIPage)this.pageStack.peek();
    }

    public void nextAction() {
        Log.debug(45, "nextFinishAction called");
        if (!this.getCurrentPage().onAdvanceAction()) {
            return;
        }
        if (this.getCurrentPage().getNextPageID() == null) {
            return;
        }
        Log.debug(45, "nextFinishAction pushing currentPage to Stack (" + this.getCurrentPage().getPageID() + ")");
        this.pageStack.push(this.getCurrentPage());
        String nextPgID = this.getCurrentPage().getNextPageID();
        Log.debug(45, "nextFinishAction - next page ID is: " + nextPgID);
        AbstractUIPage nextPage = (AbstractUIPage)this.pageCache.get(nextPgID);
        if (nextPage == null) {
            nextPage = WizardPageLibrary.getPage(nextPgID);
        }
        this.setCurrentPage(nextPage);
    }

    public void finishAction() {
        this.pageStack.push(this.getCurrentPage());
        this.setVisible(false);
        Node rootNode = null;
        rootNode = !this.domPresentToReturn ? this.collectDataFromPages() : this.domToReturn;
        this.listener.wizardComplete(rootNode);
        this.doCleanUp();
    }

    public Node collectDataFromPages() {
        HashMap<String, AbstractUIPage> pageMap = new HashMap<String, AbstractUIPage>();
        OrderedMap wizData = new OrderedMap();
        while (!this.pageStack.isEmpty()) {
            AbstractUIPage nextPage = (AbstractUIPage)this.pageStack.pop();
            String nextPageID = nextPage.getPageID();
            Log.debug(45, ">> collectDataFromPages() - next pageID = " + nextPageID);
            if (nextPageID == null || nextPageID.trim().length() < 1) {
                Log.debug(15, "\n*** WARNING - WizardContainerFrame.collectDataFromPages() has encountered a page with no ID! Object is: " + nextPage);
                continue;
            }
            pageMap.put(nextPageID, nextPage);
        }
        AbstractUIPage GENERAL = (AbstractUIPage)pageMap.get("GENERAL");
        AbstractUIPage KEYWORDS = (AbstractUIPage)pageMap.get("KEYWORDS");
        AbstractUIPage PARTY_CREATOR_PAGE = (AbstractUIPage)pageMap.get("PARTY_CREATOR_PAGE");
        AbstractUIPage PARTY_CONTACT_PAGE = (AbstractUIPage)pageMap.get("PARTY_CONTACT_PAGE");
        AbstractUIPage PARTY_ASSOCIATED_PAGE = (AbstractUIPage)pageMap.get("PARTY_ASSOCIATED_PAGE");
        AbstractUIPage PROJECT = (AbstractUIPage)pageMap.get("PROJECT");
        AbstractUIPage METHODS = (AbstractUIPage)pageMap.get("METHODS");
        AbstractUIPage USAGE_RIGHTS = (AbstractUIPage)pageMap.get("USAGE_RIGHTS");
        AbstractUIPage GEOGRAPHIC = (AbstractUIPage)pageMap.get("GEOGRAPHIC");
        AbstractUIPage TEMPORAL = (AbstractUIPage)pageMap.get("TEMPORAL");
        AbstractUIPage TAXONOMIC = (AbstractUIPage)pageMap.get("TAXONOMIC");
        AbstractUIPage ACCESS = (AbstractUIPage)pageMap.get("ACCESS");
        AbstractUIPage DATA_LOCATION = (AbstractUIPage)pageMap.get("DATA_LOCATION");
        AbstractUIPage TEXT_IMPORT_WIZARD = (AbstractUIPage)pageMap.get("TEXT_IMPORT_WIZARD");
        AbstractUIPage DATA_FORMAT = (AbstractUIPage)pageMap.get("DATA_FORMAT");
        AbstractUIPage ENTITY = (AbstractUIPage)pageMap.get("ENTITY");
        OrderedMap generalMap = null;
        if (GENERAL != null) {
            generalMap = GENERAL.getPageData();
            String titleXPath = "/eml:eml/dataset/title[1]";
            Object titleObj = generalMap.get((Object)"/eml:eml/dataset/title[1]");
            if (titleObj != null) {
                wizData.put((Object)"/eml:eml/dataset/title[1]", titleObj);
            }
        }
        if (PARTY_CREATOR_PAGE != null) {
            this.addPageDataToResultsMap(PARTY_CREATOR_PAGE, wizData);
        }
        if (PARTY_ASSOCIATED_PAGE != null) {
            this.addPageDataToResultsMap(PARTY_ASSOCIATED_PAGE, wizData);
        }
        if (generalMap != null) {
            String abstractXPath = "/eml:eml/dataset/abstract/para[1]";
            Object abstractObj = generalMap.get((Object)"/eml:eml/dataset/abstract/para[1]");
            if (abstractObj != null) {
                wizData.put((Object)"/eml:eml/dataset/abstract/para[1]", abstractObj);
            }
        }
        if (KEYWORDS != null) {
            this.addPageDataToResultsMap(KEYWORDS, wizData);
        }
        if (USAGE_RIGHTS != null) {
            this.addPageDataToResultsMap(USAGE_RIGHTS, wizData);
        }
        if (GEOGRAPHIC != null) {
            this.addPageDataToResultsMap(GEOGRAPHIC, wizData);
        }
        if (TEMPORAL != null) {
            this.addPageDataToResultsMap(TEMPORAL, wizData);
        }
        if (TAXONOMIC != null) {
            this.addPageDataToResultsMap(TAXONOMIC, wizData);
        }
        if (PARTY_CONTACT_PAGE != null) {
            this.addPageDataToResultsMap(PARTY_CONTACT_PAGE, wizData);
        }
        if (METHODS != null) {
            this.addPageDataToResultsMap(METHODS, wizData);
        }
        if (PROJECT != null) {
            this.addPageDataToResultsMap(PROJECT, wizData);
        }
        if (ACCESS != null) {
            this.addPageDataToResultsMap(ACCESS, wizData);
        }
        if (TEXT_IMPORT_WIZARD != null) {
            this.addPageDataToResultsMap(TEXT_IMPORT_WIZARD, wizData);
        }
        if (ENTITY != null) {
            this.addPageDataToResultsMap(ENTITY, wizData);
        }
        if (DATA_FORMAT != null) {
            this.addPageDataToResultsMap(DATA_FORMAT, wizData);
        }
        if (DATA_LOCATION != null) {
            this.addPageDataToResultsMap(DATA_LOCATION, wizData);
        }
        this.addIDs(new String[]{"/eml:eml/dataset/dataTable", "/eml:eml/dataset/dataTable/attributeList/attribute"}, wizData);
        Log.debug(45, "\n\n********** Wizard finished: NVPs:");
        Log.debug(45, wizData.toString());
        Node rootNode = this.getNewEmptyDataPackageDOM("<eml:eml    packageId=\"\" system=\"knb\"    xmlns:eml=\"eml://ecoinformatics.org/eml-2.0.1\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"eml://ecoinformatics.org/eml-2.0.1 eml.xsd\">    <dataset>    <title> </title>    <creator> </creator>   </dataset> </eml:eml>");
        try {
            XMLUtilities.getXPathMapAsDOMTree((Map)wizData, (Node)rootNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug(5, "unexpected error trying to create new XML document after wizard finished\n");
            this.cancelAction();
            return null;
        }
        Log.debug(45, "\n\n********** Wizard finished: DOM:");
        Log.debug(45, XMLUtilities.getDOMTreeAsString((Node)rootNode));
        return rootNode;
    }

    private Node getNewEmptyDataPackageDOM(String DocText) {
        Node rootNode = null;
        try {
            rootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)new StringReader(DocText));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug(5, "unexpected error trying to create new XML document");
            this.cancelAction();
            return null;
        }
        return rootNode;
    }

    private void addIDs(String[] elementsNeedingIDsArray, OrderedMap resultsMap) {
        this.idMap.clear();
        Set keyset = resultsMap.keySet();
        for (int i = 0; i < elementsNeedingIDsArray.length; ++i) {
            String nextXPath = elementsNeedingIDsArray[i];
            if (keyset.contains(nextXPath)) {
                this.idMap.put((Object)(nextXPath + "/@id"), (Object)WizardSettings.getUniqueID());
            }
            this.tempBuff.delete(0, this.tempBuff.length());
            this.tempBuff.append(nextXPath);
            this.tempBuff.append("/");
            if (this.mapKeysContainSubstring(keyset, this.tempBuff.toString())) {
                this.idMap.put((Object)(nextXPath + "/@id"), (Object)WizardSettings.getUniqueID());
            }
            nextXPath = nextXPath + "[";
            int idx = 1;
            this.tempBuff.delete(0, this.tempBuff.length());
            this.tempBuff.append(nextXPath);
            this.tempBuff.append(idx++);
            this.tempBuff.append("]");
            while (this.mapKeysContainSubstring(keyset, this.tempBuff.toString())) {
                this.tempBuff.append("/@id");
                this.idMap.put((Object)this.tempBuff.toString(), (Object)WizardSettings.getUniqueID());
                this.tempBuff.delete(0, this.tempBuff.length());
                this.tempBuff.append(nextXPath);
                this.tempBuff.append(idx++);
                this.tempBuff.append("]");
            }
        }
        resultsMap.putAll((Map)this.idMap);
    }

    private boolean mapKeysContainSubstring(Set keyset, String xpath) {
        if (keyset == null || xpath == null || xpath.trim().equals("")) {
            return false;
        }
        Iterator it = keyset.iterator();
        if (it == null) {
            return false;
        }
        String nextKey = null;
        while (it.hasNext()) {
            nextKey = (String)it.next();
            if (nextKey == null || nextKey.indexOf(xpath) < 0) continue;
            return true;
        }
        return false;
    }

    public void setDOMToReturn(Node dom) {
        this.domToReturn = dom;
        this.domPresentToReturn = true;
    }

    private void addPageDataToResultsMap(AbstractUIPage nextPage, OrderedMap resultsMap) {
        String nextKey = null;
        OrderedMap nextPgData = nextPage.getPageData();
        if (nextPgData == null) {
            return;
        }
        Iterator it = nextPgData.keySet().iterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            nextKey = (String)it.next();
            if (nextKey == null || nextKey.trim().equals("")) continue;
            resultsMap.put((Object)nextKey, nextPgData.get((Object)nextKey));
        }
    }

    public void previousAction() {
        if (this.pageStack.isEmpty()) {
            return;
        }
        AbstractUIPage previousPage = (AbstractUIPage)this.pageStack.pop();
        if (previousPage == null) {
            Log.debug(15, "previousAction - popped a NULL page from stack");
            return;
        }
        Log.debug(45, "previousAction - popped page with ID: " + previousPage.getPageID() + " from stack");
        AbstractUIPage currentPage = this.getCurrentPage();
        Log.debug(45, "previousAction adding currentPage to pageCache (" + currentPage.getPageID() + ")");
        currentPage.onRewindAction();
        this.pageCache.put(currentPage.getPageID(), currentPage);
        this.setCurrentPage(previousPage);
    }

    public void reInitializePageStack() {
        if (this.pageStack == null) {
            this.pageStack = new Stack();
            return;
        }
        this.pageStack.removeAllElements();
    }

    public void cancelAction() {
        Entity[] arr;
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp != null && (arr = adp.getOriginalEntityArray()) != null) {
            System.out.println("replacing subtree - ");
            adp.deleteAllEntities();
            for (int i = 0; i < arr.length; ++i) {
                System.out.println("adding entity - " + i);
                adp.addEntity(arr[i]);
            }
        }
        this.setVisible(false);
        this.listener.wizardCanceled();
        this.doCleanUp();
    }

    private void doCleanUp() {
        UIController.getInstance().setWizardNotRunning();
        this.pageStack.clear();
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp != null) {
            adp.clearAllAttributeImports();
        }
    }

    private void setpageTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = " ";
        }
        this.titleLabel.setText(newTitle);
    }

    private void setpageSubtitle(String newSubTitle) {
        if (newSubTitle == null) {
            newSubTitle = " ";
        }
        this.subtitleLabel.setText(newSubTitle);
    }

    private JButton addButton(String title, ActionListener actionListener) {
        JButton button = WidgetFactory.makeJButton(title, actionListener, WizardSettings.NAV_BUTTON_DIMS);
        this.bottomPanel.add(button);
        this.bottomPanel.add(Box.createHorizontalStrut(this.PADDING));
        return button;
    }

    public static JFrame getDialogParent() {
        dialogParent = frame != null && frame.isShowing() ? frame : UIController.getInstance().getCurrentActiveWindow();
        if (dialogParent == null || dialogParent.getX() < 0 || dialogParent.getY() < 0) {
            if (dummyFrame == null) {
                dummyFrame = new JFrame();
                dummyFrame.setBounds(UISettings.CLIENT_SCREEN_WIDTH / 2, UISettings.CLIENT_SCREEN_HEIGHT / 2, 1, 1);
                dummyFrame.setVisible(false);
            }
            dialogParent = dummyFrame;
        }
        return dialogParent;
    }
}

