/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.editor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class NodeInfo
implements Serializable {
    static Hashtable icons = new Hashtable();
    String name;
    String iconName;
    String PCDataValue;
    String cardinality = "ONE";
    Hashtable attr = new Hashtable();
    Object Item = null;
    String editor = null;
    String rooteditor = null;
    String help = null;
    boolean choice_flag;
    boolean selected_flag;
    boolean checkbox_flag;
    boolean xml_attribute = false;
    int nodeVisLevel = 0;

    public NodeInfo(String name) {
        this.name = name;
        this.iconName = "red.gif";
        this.setIcon("red.gif");
        this.choice_flag = false;
        this.selected_flag = false;
        this.checkbox_flag = false;
        this.setCardinality("ZERO to MANY");
    }

    public String toString() {
        if (this.name.equalsIgnoreCase("#PCDATA")) {
            return this.PCDataValue;
        }
        if (this.name.indexOf("CHOICE") > -1) {
            return "(CHOICE)";
        }
        if (this.name.indexOf("SEQUENCE") > -1) {
            return "(SEQUENCE)";
        }
        return this.name;
    }

    public void setNodeVisLevel(int nvl) {
        this.nodeVisLevel = nvl;
    }

    public int getNodeVisLevel() {
        return this.nodeVisLevel;
    }

    public void setXMLAttribute(boolean val) {
        this.xml_attribute = val;
    }

    public boolean isXMLAttribute() {
        return this.xml_attribute;
    }

    public void setCardinality(String card) {
        this.cardinality = card;
        if (card.equalsIgnoreCase("ONE")) {
            this.setIcon("red.gif");
        }
        if (card.equalsIgnoreCase("OPTIONAL")) {
            this.setIcon("yellow.gif");
        }
        if (card.equalsIgnoreCase("ZERO to MANY")) {
            this.setIcon("green.gif");
        }
        if (card.equalsIgnoreCase("ONE to MANY")) {
            this.setIcon("blue.gif");
        }
        if (this.choice_flag && this.selected_flag) {
            this.setIcon("sel.gif");
        }
        if (this.choice_flag && !this.selected_flag) {
            this.setIcon("unsel.gif");
        }
    }

    public boolean isChoice() {
        return this.choice_flag;
    }

    public void setChoice(boolean flg) {
        this.choice_flag = flg;
    }

    public void setCheckboxFlag(boolean flg) {
        this.checkbox_flag = flg;
        if (this.choice_flag && this.selected_flag && !this.checkbox_flag) {
            this.setIcon("sel.gif");
        }
        if (this.choice_flag && this.selected_flag && this.checkbox_flag) {
            this.setIcon("checkedBox.gif");
        }
        if (this.choice_flag && !this.selected_flag && !this.checkbox_flag) {
            this.setIcon("unsel.gif");
        }
        if (this.choice_flag && !this.selected_flag && this.checkbox_flag) {
            this.setIcon("uncheckedBox.gif");
        }
    }

    public boolean isCheckbox() {
        return this.checkbox_flag;
    }

    public boolean isSelected() {
        return this.selected_flag;
    }

    public void setSelected(boolean flg) {
        this.selected_flag = flg;
        if (this.choice_flag && this.selected_flag && !this.checkbox_flag) {
            this.setIcon("sel.gif");
        }
        if (this.choice_flag && this.selected_flag && this.checkbox_flag) {
            this.setIcon("checkedBox.gif");
        }
        if (this.choice_flag && !this.selected_flag && !this.checkbox_flag) {
            this.setIcon("unsel.gif");
        }
        if (this.choice_flag && !this.selected_flag && this.checkbox_flag) {
            this.setIcon("uncheckedBox.gif");
        }
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String hlp) {
        this.help = hlp;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String edt) {
        this.editor = edt;
    }

    public String getRootEditor() {
        return this.rooteditor;
    }

    public void setRootEditor(String redt) {
        this.rooteditor = redt;
    }

    public void setPCValue(String val) {
        this.PCDataValue = val;
    }

    public String getPCValue() {
        return this.PCDataValue.trim();
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public Object getItem() {
        return this.Item;
    }

    public void setItem(Object o) {
        this.Item = o;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setIcon(String name) {
        this.iconName = name;
        if (!icons.containsKey(name)) {
            ImageIcon temp = new ImageIcon(this.getClass().getResource(name));
            icons.put(name, temp);
        }
    }

    public ImageIcon getIcon() {
        if (this.iconName != null) {
            if (icons.containsKey(this.iconName)) {
                return (ImageIcon)icons.get(this.iconName);
            }
            return null;
        }
        return null;
    }

    public String getIconName() {
        return this.iconName;
    }

    public NodeInfo cloneNodeInfo() {
        NodeInfo clone = new NodeInfo(this.name);
        clone.cardinality = this.cardinality;
        clone.iconName = this.iconName;
        clone.PCDataValue = this.PCDataValue;
        clone.Item = this.Item;
        clone.editor = this.editor;
        clone.choice_flag = this.choice_flag;
        clone.selected_flag = this.selected_flag;
        clone.rooteditor = this.rooteditor;
        clone.help = this.help;
        Enumeration enumeration = this.attr.keys();
        while (enumeration.hasMoreElements()) {
            Object kk = enumeration.nextElement();
            Object val = this.attr.get(kk);
            clone.attr.put(kk, val);
        }
        return clone;
    }

    public String getAttrValue(String key) {
        String ret = null;
        if (this.attr.containsKey(key)) {
            ret = (String)this.attr.get(key);
        }
        return ret;
    }
}

