/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import com.arbortext.catalog.Catalog;
import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.DataPackage;
import edu.ucsb.nceas.morpho.datapackage.TripleCollection;
import edu.ucsb.nceas.morpho.datastore.CacheAccessException;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.EditorInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.LocalQuery;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PackageUtil {
    public static NodeList getPathContent(File f, Vector paths, Morpho morpho) {
        for (int i = 0; i < paths.size(); ++i) {
            String s = (String)paths.elementAt(i);
            NodeList nl = PackageUtil.getPathContent(f, s, morpho);
            if (nl == null || nl.getLength() == 0) continue;
            return nl;
        }
        return null;
    }

    public static NodeList getPathContent(File f, String path, Morpho morpho) {
        Document doc;
        try {
            doc = PackageUtil.getDoc(f, morpho);
        }
        catch (Exception e1) {
            System.err.println("File: " + f.getPath() + " : parse threw (1): " + e1.toString());
            return null;
        }
        try {
            long start_time_xpath = System.currentTimeMillis();
            NodeList docNodeList = XPathAPI.selectNodeList((Node)doc, (String)path);
            long stop_time = System.currentTimeMillis();
            return docNodeList;
        }
        catch (TransformerException se) {
            System.err.println("File: " + f.getPath() + " : parse threw (2): " + se.toString());
            return null;
        }
    }

    public static Document getDoc(File file, String catalogPath) throws SAXException, Exception {
        Document doc;
        InputSource in;
        FileReader fs;
        long start_time = System.currentTimeMillis();
        String fileName = file.getName();
        String parent = file.getParent();
        int lastsep = parent.lastIndexOf(File.separator);
        fileName = (parent = parent.substring(lastsep + 1)) + "." + fileName;
        if (LocalQuery.dom_collection.containsKey(fileName)) {
            return (Document)LocalQuery.dom_collection.get(fileName);
        }
        DocumentBuilder parser = Morpho.createDomParser();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL catalogURL = cl.getResource(catalogPath);
            myCatalog.parseCatalog(catalogURL.toString());
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            Log.debug(11, "Problem creating Catalog in packagewizardshell.handleFinishAction!" + e.toString());
            throw new Exception(e.getMessage());
        }
        parser.setEntityResolver(cer);
        try {
            fs = new FileReader(file);
            in = new InputSource(fs);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
            throw new Exception(fnf.getMessage());
        }
        try {
            doc = parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            throw new Exception(e1.getMessage());
        }
        long stop_time = System.currentTimeMillis();
        Log.debug(10, "Time for getDoc: " + (stop_time - start_time));
        return doc;
    }

    public static Document getDoc(File file, Morpho morpho) throws SAXException, Exception {
        Document doc;
        InputSource in;
        FileReader fs;
        DocumentBuilder parser = Morpho.createDomParser();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            ConfigXML config = morpho.getConfiguration();
            String catalogPath = config.get("local_catalog_path", 0);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL catalogURL = cl.getResource(catalogPath);
            myCatalog.parseCatalog(catalogURL.toString());
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            Log.debug(11, "Problem creating Catalog in packagewizardshell.handleFinishAction!" + e.toString());
            throw new Exception(e.getMessage());
        }
        parser.setEntityResolver(cer);
        try {
            fs = new FileReader(file);
            in = new InputSource(fs);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
            throw new Exception(fnf.getMessage());
        }
        try {
            doc = parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            throw new Exception(e1.getMessage());
        }
        return doc;
    }

    public static String print(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node == null) {
            return null;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                sb.append("<?xml version=\"1.0\"?>");
                PackageUtil.print(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                sb.append('<');
                sb.append(node.getNodeName());
                Attr[] attrs = PackageUtil.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    sb.append(' ');
                    sb.append(attr.getNodeName());
                    sb.append("=\"");
                    sb.append(XMLUtil.normalize(attr.getNodeValue()));
                    sb.append('\"');
                }
                sb.append('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    sb.append(PackageUtil.print(children.item(i)));
                }
                break;
            }
            case 5: {
                sb.append('&');
                sb.append(node.getNodeName());
                sb.append(';');
                break;
            }
            case 4: {
                sb.append("<![CDATA[");
                sb.append(node.getNodeValue());
                sb.append("]]>");
                break;
            }
            case 3: {
                sb.append(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                sb.append("<?");
                sb.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    sb.append(' ');
                    sb.append(data);
                }
                sb.append("?>");
                break;
            }
        }
        if (type == 1) {
            sb.append("</");
            sb.append(node.getNodeName());
            sb.append('>');
        }
        return sb.toString();
    }

    protected static Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    public static String printDoctype(Document doc) {
        DocumentType dt = doc.getDoctype();
        String publicid = dt.getPublicId();
        String systemid = dt.getSystemId();
        String nameid = dt.getName();
        String docString = "<?xml version=\"1.0\"?>";
        docString = docString + "\n<!DOCTYPE " + nameid + " PUBLIC \"" + publicid + "\" \"" + systemid + "\">\n";
        return docString;
    }

    public static File openFile(String name, Morpho morpho) throws FileNotFoundException, CacheAccessException {
        return PackageUtil.openFile(name, null, morpho);
    }

    public static File openFile(String name, String location, Morpho morpho) throws FileNotFoundException, CacheAccessException {
        if (location == null) {
            try {
                FileSystemDataStore fsds = new FileSystemDataStore(morpho);
                File f = fsds.openFile(name);
                return f;
            }
            catch (FileNotFoundException fnfe) {
                try {
                    MetacatDataStore mds = new MetacatDataStore(morpho);
                    File f = mds.openFile(name);
                    return f;
                }
                catch (FileNotFoundException fnfe2) {
                    throw new FileNotFoundException(fnfe2.getMessage());
                }
                catch (CacheAccessException cae2) {
                    throw new CacheAccessException(cae2.getMessage());
                }
            }
        }
        try {
            if (location.equals("local") || location.equals("localmetacat")) {
                FileSystemDataStore fsds = new FileSystemDataStore(morpho);
                File f = fsds.openFile(name);
                return f;
            }
            MetacatDataStore mds = new MetacatDataStore(morpho);
            File f = mds.openFile(name);
            return f;
        }
        catch (FileNotFoundException fnfe3) {
            throw new FileNotFoundException(fnfe3.getMessage());
        }
        catch (CacheAccessException cae3) {
            throw new CacheAccessException(cae3.getMessage());
        }
    }

    public static EditorInterface getEditor(Morpho morpho) {
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(EditorInterface.class);
            EditorInterface editor = (EditorInterface)((Object)provider);
            return editor;
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(0, "Could not capture the editor in PackageUtil.getEditor(): " + snhe.getMessage());
            return null;
        }
    }

    public static String getStringFromFile(File xmlFile) {
        StringBuffer sb = new StringBuffer();
        try {
            FileReader fr = new FileReader(xmlFile);
            int c = fr.read();
            while (c != -1) {
                sb.append((char)c);
                c = fr.read();
            }
            fr.close();
            return sb.toString();
        }
        catch (Exception e) {
            Log.debug(0, "Error reading file in PackageUtil.getStringFromFile(): " + e.getMessage());
            return null;
        }
    }

    public static String addTriplesToTriplesFile(TripleCollection triples, DataPackage dataPackage, Morpho morpho) {
        InputSource in;
        FileInputStream fs;
        String triplesTag = morpho.getConfiguration().get("triplesTag", 0);
        File packageFile = dataPackage.getTriplesFile();
        Document doc = null;
        DocumentBuilder parser = Morpho.createDomParser();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            ConfigXML config = morpho.getConfiguration();
            String catalogPath = config.get("local_catalog_path", 0);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL catalogURL = cl.getResource(catalogPath);
            myCatalog.parseCatalog(catalogURL.toString());
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            Log.debug(9, "Problem creating Catalog in PackageUtil.updateTriplesFile" + e.toString());
        }
        parser.setEntityResolver(cer);
        try {
            fs = new FileInputStream(packageFile);
            in = new InputSource(fs);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
            return null;
        }
        try {
            doc = parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            System.err.println("File: " + packageFile.getPath() + " : parse threw (3): " + e1.toString());
        }
        NodeList tripleNodeList = triples.getNodeList();
        NodeList docTriplesNodeList = null;
        try {
            docTriplesNodeList = XPathAPI.selectNodeList((Node)doc, (String)triplesTag);
        }
        catch (TransformerException se) {
            System.err.println("File: " + packageFile.getPath() + " : parse threw (4): " + se.toString());
        }
        Element docNode = doc.getDocumentElement();
        for (int j = 0; j < tripleNodeList.getLength(); ++j) {
            Node n = doc.importNode(tripleNodeList.item(j), true);
            int end = docTriplesNodeList.getLength() - 1;
            Node triplesNode = docTriplesNodeList.item(end);
            Node parent = triplesNode.getParentNode();
            if (triplesNode.getNextSibling() == null) {
                parent.appendChild(n);
                continue;
            }
            parent.insertBefore(n, triplesNode.getNextSibling());
        }
        String docString = PackageUtil.printDoctype(doc);
        docString = docString + PackageUtil.print(doc.getDocumentElement());
        return docString;
    }

    public static String addTriplesToTriplesString(TripleCollection triples, String dataPackageString, Morpho morpho) {
        InputSource in;
        StringReader sr;
        String triplesTag = morpho.getConfiguration().get("triplesTag", 0);
        Document doc = null;
        DocumentBuilder parser = Morpho.createDomParser();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            ConfigXML config = morpho.getConfiguration();
            String catalogPath = config.get("local_catalog_path", 0);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL catalogURL = cl.getResource(catalogPath);
            myCatalog.parseCatalog(catalogURL.toString());
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            Log.debug(9, "Problem creating Catalog in PackageUtil.updateTriplesFile" + e.toString());
        }
        parser.setEntityResolver(cer);
        try {
            sr = new StringReader(dataPackageString);
            in = new InputSource(sr);
        }
        catch (Exception fnf) {
            fnf.printStackTrace();
            return null;
        }
        try {
            doc = parser.parse(in);
            sr.close();
        }
        catch (Exception e1) {
            System.err.println(e1.toString());
        }
        NodeList tripleNodeList = triples.getNodeList();
        NodeList docTriplesNodeList = null;
        try {
            docTriplesNodeList = XPathAPI.selectNodeList((Node)doc, (String)triplesTag);
        }
        catch (TransformerException se) {
            System.err.println(se.toString());
        }
        Element docNode = doc.getDocumentElement();
        for (int j = 0; j < tripleNodeList.getLength(); ++j) {
            Node n = doc.importNode(tripleNodeList.item(j), true);
            int end = docTriplesNodeList.getLength() - 1;
            Node triplesNode = docTriplesNodeList.item(end);
            Node parent = triplesNode.getParentNode();
            if (triplesNode.getNextSibling() == null) {
                parent.appendChild(n);
                continue;
            }
            parent.insertBefore(n, triplesNode.getNextSibling());
        }
        String docString = PackageUtil.printDoctype(doc);
        docString = docString + PackageUtil.print(doc.getDocumentElement());
        return docString;
    }

    public static String deleteTriplesInTriplesFile(String searchstring, DataPackage dataPackage, Morpho morpho) {
        InputSource in;
        FileInputStream fs;
        String triplesTag = morpho.getConfiguration().get("triplesTag", 0);
        File packageFile = dataPackage.getTriplesFile();
        Document doc = null;
        DocumentBuilder parser = Morpho.createDomParser();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            ConfigXML config = morpho.getConfiguration();
            String catalogPath = config.get("local_catalog_path", 0);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL catalogURL = cl.getResource(catalogPath);
            myCatalog.parseCatalog(catalogURL.toString());
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            Log.debug(9, "Problem creating Catalog in PackageUtil.updateTriplesFile" + e.toString());
        }
        parser.setEntityResolver(cer);
        try {
            fs = new FileInputStream(packageFile);
            in = new InputSource(fs);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
            return null;
        }
        try {
            doc = parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            System.err.println("File: " + packageFile.getPath() + " : parse threw (5): " + e1.toString());
        }
        NodeList docTriplesNodeList = null;
        try {
            docTriplesNodeList = XPathAPI.selectNodeList((Node)doc, (String)triplesTag);
        }
        catch (TransformerException se) {
            System.err.println("File: " + packageFile.getPath() + " : parse threw (6): " + se.toString());
        }
        for (int i = 0; i < docTriplesNodeList.getLength(); ++i) {
            Node triple = docTriplesNodeList.item(i);
            Node parent = triple.getParentNode();
            NodeList children = triple.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node o;
                Node n = children.item(j);
                if (!n.getNodeName().equals("subject") && !n.getNodeName().equals("object") || !(o = n.getFirstChild()).getNodeValue().trim().equals(searchstring)) continue;
                NodeList countTriples = null;
                try {
                    countTriples = XPathAPI.selectNodeList((Node)doc, (String)triplesTag);
                }
                catch (TransformerException se2) {
                    System.err.println("File: " + packageFile.getPath() + " : parse threw (7): " + se2.toString());
                }
                if (countTriples.getLength() == 1) {
                    for (int k = 0; k < children.getLength(); ++k) {
                        Node lastchild = children.item(k);
                        if (!lastchild.getNodeName().equals("subject") && !lastchild.getNodeName().equals("relationship") && !lastchild.getNodeName().equals("object")) continue;
                        lastchild.getFirstChild().setNodeValue(" ");
                    }
                    continue;
                }
                parent.removeChild(triple);
            }
        }
        String docString = PackageUtil.printDoctype(doc);
        docString = docString + PackageUtil.print(doc.getDocumentElement());
        return docString;
    }

    public static Hashtable getConfigFileTypeAttributes(Morpho morpho, String hashby) {
        Hashtable returnhash = new Hashtable();
        NodeList filetypes = morpho.getConfiguration().getPathContent("//newxmlfiletypes/file");
        for (int i = 0; i < filetypes.getLength(); ++i) {
            Node n = filetypes.item(i);
            NodeList children = n.getChildNodes();
            Hashtable<String, String> h = new Hashtable<String, String>();
            for (int j = 0; j < children.getLength(); ++j) {
                Node n2 = children.item(j);
                String nodename = n2.getNodeName();
                if (nodename.equals("label")) {
                    h.put("label", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("xmlfiletype")) {
                    h.put("xmlfiletype", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("tooltip")) {
                    h.put("tooltip", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("name")) {
                    h.put("name", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("relatedto")) {
                    h.put("relatedto", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("rootnode")) {
                    h.put("rootnode", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("displaypath")) {
                    h.put("displaypath", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("editexisting")) {
                    h.put("editexisting", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equals("visible")) {
                    h.put("visible", n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (!nodename.equals("idpath")) continue;
                h.put("idpath", n2.getFirstChild().getNodeValue());
            }
            returnhash.put(h.get(hashby), h);
        }
        return returnhash;
    }

    public static void save(String filename, Document doc, String doctype, Morpho morpho) {
        PackageUtil.saveDOM(filename, doc, doctype, morpho);
    }

    public static void saveDOM(String fileName, Document doc, String doctype, Morpho morpho) {
        PrintWriter out = null;
        Element nd = doc.getDocumentElement();
        File outfile = new File(fileName);
        try {
            out = new PrintWriter(new FileWriter(fileName));
        }
        catch (Exception e) {
            // empty catch block
        }
        out.println("<?xml version=\"1.0\"?>");
        String dt = doctype;
        if (doctype == null) {
            dt = "";
        }
        out.println(dt);
        PackageUtil.print(nd, out);
        out.close();
    }

    private static void print(Node node, PrintWriter out) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\"?>");
                PackageUtil.print(((Document)node).getDocumentElement(), out);
                out.flush();
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                Attr[] attrs = PackageUtil.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    out.print(' ');
                    out.print(attr.getNodeName());
                    out.print("=\"");
                    out.print(XMLUtil.normalize(attr.getNodeValue()));
                    out.print('\"');
                }
                out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    PackageUtil.print(children.item(i), out);
                }
                break;
            }
            case 5: {
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.print("?>");
                break;
            }
        }
        if (type == 1) {
            out.print("</");
            out.print(node.getNodeName());
            out.println('>');
        }
        out.flush();
    }
}

