/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLErrorHandler;
import edu.ucsb.nceas.morpho.util.XMLUtil;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EML200DataPackage
extends AbstractDataPackage {
    public static final String LATEST_EML_VER = "eml-2.0.1";

    public void serialize(String location) throws MetacatUploadException {
        Morpho morpho = Morpho.thisStaticInstance;
        String temp = XMLUtil.getDOMTreeAsString(this.getMetadataNode().getOwnerDocument());
        StringReader sr = new StringReader(temp);
        StringReader sr1 = new StringReader(temp);
        if (location.equals("local") || location.equals("localmetacat")) {
            FileSystemDataStore fsds = new FileSystemDataStore(morpho);
            fsds.saveFile(this.getAccessionNumber(), sr);
        }
        if (location.equals("metacat") || location.equals("localmetacat")) {
            String temp1;
            MetacatDataStore mds = new MetacatDataStore(morpho);
            String temp2 = temp1 = this.getAccessionNumber();
            int lastperiod = temp1.lastIndexOf(".");
            if (lastperiod > -1) {
                temp1 = temp1.substring(lastperiod + 1, temp1.length());
                temp2 = temp2.substring(0, lastperiod);
            }
            boolean existsFlag = mds.exists(temp2 + ".1");
            boolean updateFlag = !temp1.equals("1");
            try {
                if (this.getLocation().equals("metacat") || this.getLocation().equals("localmetacat") || existsFlag && updateFlag) {
                    mds.saveFile(this.getAccessionNumber(), sr1);
                } else {
                    if (!existsFlag) {
                        String temp_an = this.getAccessionNumber();
                        this.setAccessionNumber(temp2 + ".1");
                        String tempout = XMLUtil.getDOMTreeAsString(this.getMetadataNode().getOwnerDocument());
                        StringReader sr2 = new StringReader(tempout);
                        mds.newFile(temp2 + ".1", sr2);
                        this.setAccessionNumber(temp_an);
                    }
                    if (updateFlag) {
                        mds.saveFile(this.getAccessionNumber(), sr1);
                    }
                }
            }
            catch (MetacatUploadException mue) {
                Log.debug(20, "MetacatUpload Exception in EML200DataPackage!\n" + mue.getMessage());
                throw mue;
            }
            catch (Exception e) {
                Log.debug(5, "Problem with saving to metacat in EML200DataPackage!");
            }
        }
    }

    private Vector getAssociatedDataFiles() {
        String urlinfo = null;
        Vector<String> res = new Vector<String>();
        Entity[] ents = this.getEntityArray();
        if (ents == null) {
            return res;
        }
        for (int i = 0; i < ents.length; ++i) {
            if (this.getDistributionUrl(i, 0, 0).length() <= 0 || !(urlinfo = this.getDistributionUrl(i, 0, 0)).startsWith("ecogrid://")) continue;
            int indx2 = urlinfo.indexOf("//");
            if (indx2 > -1) {
                urlinfo = urlinfo.substring(indx2 + 2);
            }
            if ((indx2 = urlinfo.indexOf("/")) > -1) {
                urlinfo = urlinfo.substring(indx2 + 1);
            }
            if ((indx2 = urlinfo.indexOf("/")) > -1) {
                urlinfo = urlinfo.substring(0, indx2);
            }
            if (urlinfo.length() <= 0) continue;
            res.addElement(urlinfo);
        }
        return res;
    }

    public void load(String location, String identifier, Morpho morpho) {
        File packagefile;
        this.location = location;
        this.id = identifier;
        this.config = Morpho.getConfiguration();
        Log.debug(20, "Creating new DataPackage Object");
        Log.debug(20, "id: " + this.id);
        Log.debug(20, "location: " + location);
        morpho = Morpho.thisStaticInstance;
        this.fileSysDataStore = new FileSystemDataStore(morpho);
        this.metacatDataStore = new MetacatDataStore(morpho);
        try {
            packagefile = this.getFileWithID(this.id, morpho);
        }
        catch (Throwable t) {
            return;
        }
        DocumentBuilder parser = Morpho.createDomParser();
        Object doc = null;
        if (packagefile == null) {
            Log.debug(1, "packagefile is NULL!");
        }
        try {
            FileInputStream fs = new FileInputStream(packagefile);
            this.load(new InputSource(fs));
            fs.close();
        }
        catch (IOException ioe) {
            Log.debug(15, "IOException: " + ioe.getMessage());
        }
    }

    public void load(InputSource in) {
        DocumentBuilder parser = Morpho.createDomParser();
        Document doc = null;
        try {
            parser.setErrorHandler(new XMLErrorHandler());
            doc = parser.parse(in);
        }
        catch (Exception e1) {
            Log.debug(4, "Parsing threw: " + e1.toString());
            e1.printStackTrace();
        }
        if (doc == null) {
            Log.debug(1, "doc is NULL!");
        }
        this.setDocument(doc);
        try {
            this.metadataPathNode = XMLUtilities.getXMLAsDOMTreeRootNode((String)"/eml200KeymapConfig.xml");
        }
        catch (Exception e2) {
            Log.debug(4, "getting DOM for Paths threw error: " + e2.toString());
            e2.printStackTrace();
        }
    }

    private void setDocument(Document doc) {
        this.setMetadataNode(doc.getDocumentElement());
        EML200DataPackage.doc = doc;
    }

    public String getAuthor() {
        String temp = "";
        String surNameXpath = "/eml:eml/dataset/creator/individualName/surName";
        String givenNameXpath = "/eml:eml/dataset/creator/individualName/givenName";
        String salutationXpath = "/eml:eml/dataset/creator/individualName/salutation";
        NodeList authorNodes = null;
        try {
            authorNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)surNameXpath);
        }
        catch (Exception w) {
            Log.debug(4, "Problem with getting Nodelist");
        }
        if (authorNodes == null) {
            return "";
        }
        int numAuthors = authorNodes.getLength();
        String surName = "";
        String givenName = "";
        String salutation = "";
        for (int i = 1; i < numAuthors + 1; ++i) {
            surName = this.getXPathValue("(" + surNameXpath + ")[" + i + "]");
            givenName = this.getXPathValue("(" + givenNameXpath + ")[" + i + "]");
            salutation = this.getXPathValue("(" + salutationXpath + ")[" + i + "]");
            if (temp.length() > 0) {
                temp = temp + ", ";
            }
            temp = temp + salutation + " " + givenName + " " + surName;
        }
        return temp;
    }

    private Node getRootNode() {
        String emlXpath = "/eml:eml";
        NodeList nodes = null;
        try {
            nodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)emlXpath);
        }
        catch (Exception w) {
            Log.debug(30, "Problem with getting root node with path " + emlXpath + " -- " + w.toString());
        }
        if (nodes == null) {
            return null;
        }
        if (nodes.getLength() > 0) {
            return nodes.item(0);
        }
        return null;
    }

    private NamedNodeMap getRootNodeAttributes() {
        Node n = this.getRootNode();
        if (n == null) {
            return null;
        }
        return n.getAttributes();
    }

    public String getXMLNamespace() {
        return XMLUtil.getAttributeValue(this.getRootNodeAttributes(), "xmlns:eml");
    }

    public String getEMLVersion() {
        String xmlns = this.getXMLNamespace();
        int pos = xmlns.lastIndexOf(47);
        if (pos != -1) {
            return xmlns.substring(pos + 1);
        }
        return "";
    }

    public void setEMLVersion(String newVersion) {
        NamedNodeMap rootNodeAtts = this.getRootNodeAttributes();
        String oldXmlns = XMLUtil.getAttributeValue(rootNodeAtts, "xmlns:eml");
        int pos = oldXmlns.lastIndexOf(47);
        if (pos != -1) {
            String oldVersion = oldXmlns.substring(pos + 1);
            if (!oldVersion.equals(newVersion)) {
                String newXmlns = oldXmlns.substring(0, pos + 1) + newVersion;
                Log.debug(30, "XXXXX setting new xmlns: " + newXmlns);
                Node xmlnsNode = rootNodeAtts.getNamedItem("xmlns:eml");
                xmlnsNode.setNodeValue(newXmlns);
                String oldSchemaLocation = XMLUtil.getAttributeValue(rootNodeAtts, "xsi:schemaLocation");
                int spacePos = oldSchemaLocation.indexOf(32);
                String oldSchemaHome = oldSchemaLocation.substring(oldSchemaLocation.lastIndexOf(47, spacePos) + 1, spacePos);
                String newSchemaLocation = oldSchemaLocation.replaceAll(oldSchemaHome, newVersion);
                Node schemaLocationNode = rootNodeAtts.getNamedItem("xsi:schemaLocation");
                schemaLocationNode.setNodeValue(newSchemaLocation);
                Log.debug(30, "----DONE setting new EML version");
            }
        } else {
            Log.debug(15, "invalid xmlns while setting EML version: " + oldXmlns);
        }
    }

    public AbstractDataPackage upload(String id, boolean updatePackageId) throws MetacatUploadException {
        Morpho morpho = Morpho.thisStaticInstance;
        this.load("local", id, morpho);
        String nextid = id;
        if (updatePackageId) {
            AccessionNumber an = new AccessionNumber(morpho);
            nextid = an.getNextId();
            this.setAccessionNumber(nextid);
            this.serialize("local");
        }
        try {
            this.serialize("metacat");
            this.setLocation("metacat");
            this.serializeData();
        }
        catch (MetacatUploadException mcue) {
            throw mcue;
        }
        catch (Exception w) {
            Log.debug(5, "error in uploading!");
        }
        return this;
    }

    public AbstractDataPackage download(String id) {
        Morpho morpho = Morpho.thisStaticInstance;
        try {
            this.serialize("local");
        }
        catch (Exception w) {
            Log.debug(5, "Exception serializing local package in 'download'");
        }
        Vector idlist = this.getAssociatedDataFiles();
        Enumeration e = idlist.elements();
        MetacatDataStore mds = new MetacatDataStore(morpho);
        FileSystemDataStore fds = new FileSystemDataStore(morpho);
        while (e.hasMoreElements()) {
            String curid = (String)e.nextElement();
            try {
                File datafile = mds.openDataFile(curid);
                FileReader fr = new FileReader(datafile);
                fds.saveFile(curid, fr);
            }
            catch (Exception q3) {
                Log.debug(5, "Exception opening datafile from metacat and saving locally");
            }
        }
        return this;
    }

    public Node getReferencedNode(Node node) {
        Node referencedNode = node;
        try {
            String refpath = "references";
            NodeList refs = XMLUtilities.getNodeListWithXPath((Node)node, (String)refpath);
            while (refs != null && refs.getLength() > 0) {
                String id = XMLUtilities.getTextNodeWithXPath((Node)node, (String)"references").getNodeValue();
                Element rootNode = node.getOwnerDocument().getDocumentElement();
                NodeList refs2 = XMLUtilities.getNodeListWithXPath((Node)rootNode, (String)("//*[@id='" + id + "']"));
                referencedNode = refs2.item(0);
                refs = XMLUtilities.getNodeListWithXPath((Node)referencedNode, (String)refpath);
            }
        }
        catch (Exception w) {
            Log.debug(25, "Exception trying to follow references!");
        }
        return referencedNode;
    }

    public Node getSubtreeAtReference(String refID) {
        Node refdNode = null;
        try {
            refdNode = this.getSubtreeAtReferenceNoClone(refID);
            if (refdNode == null) {
                return null;
            }
            Node deepClone = refdNode.cloneNode(true);
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", "tempRoot", null);
            Node importedClone = doc.importNode(deepClone, true);
            Element tempRoot = doc.getDocumentElement();
            doc.replaceChild(importedClone, tempRoot);
            return importedClone;
        }
        catch (Throwable w) {
            Log.debug(25, "Exception trying to follow references (in getSubtreeAtReference)! " + w);
            w.printStackTrace();
            return null;
        }
    }

    public List getSubtreesThatReference(String refID) {
        ArrayList<Node> returnList = new ArrayList<Node>();
        try {
            String refpath = "//*/references";
            NodeList refs = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)refpath);
            if (refs == null || refs.getLength() < 1) {
                Log.debug(12, "getSubtreesThatReference() found no subtrees that reference " + refID);
                return returnList;
            }
            for (int i = 0; i < refs.getLength(); ++i) {
                Node nd = refs.item(i);
                String val = nd.getFirstChild().getNodeValue();
                if (!(val = val.trim()).equals(refID.trim())) continue;
                returnList.add(nd.getParentNode());
            }
        }
        catch (Exception w) {
            w.printStackTrace();
            Log.debug(12, "Problem in 'getSubtreesThatReference. " + w);
        }
        return returnList;
    }

    public Node replaceSubtreeAtReference(String refID, Node newSubtreeRoot) {
        Document doc = this.getMetadataNode().getOwnerDocument();
        try {
            Node oldSubtreeRoot = this.getSubtreeAtReferenceNoClone(refID);
            if (oldSubtreeRoot == null) {
                return null;
            }
            Node newIDAttr = newSubtreeRoot.getAttributes().getNamedItem("id");
            if (newIDAttr != null && newIDAttr.getNodeType() == 2) {
                Log.debug(45, "replaceSubtreeAtReference() - newID=" + newIDAttr.getNodeValue());
                if (!newIDAttr.getNodeValue().equals(refID)) {
                    Log.debug(25, "new Subtree ID (" + newIDAttr.getNodeValue() + ") will be changed to agree with original subtree ID (" + refID + ")");
                    newIDAttr.setNodeValue(refID);
                }
            }
            Node importedSubtree = doc.importNode(newSubtreeRoot, true);
            oldSubtreeRoot.getParentNode().replaceChild(importedSubtree, oldSubtreeRoot);
            return importedSubtree;
        }
        catch (Throwable w) {
            Log.debug(25, "Exception in replaceSubtreeAtReference)! " + w);
            w.printStackTrace();
            return null;
        }
    }

    public Node getSubtreeAtReferenceNoClone(String refID) {
        try {
            Node rootNode = this.getMetadataNode();
            NodeList refs2 = XMLUtilities.getNodeListWithXPath((Node)rootNode, (String)("//*[@id='" + refID + "']"));
            if (refs2 == null) {
                return null;
            }
            Node referencedNode = refs2.item(0);
            return this.getReferencedNode(referencedNode);
        }
        catch (TransformerException w) {
            Log.debug(25, "TransformerException trying to follow references (in getSubtreeAtReference)! " + w);
            w.printStackTrace();
            return null;
        }
    }

    public boolean ignoreConsecutiveDelimiters(int entityIndex, int physicalIndex) {
        boolean ret = false;
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            Log.debug(20, "No such entity!");
            return ret;
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            Log.debug(20, "no physicals!");
            return ret;
        }
        if (physicalIndex > physicals.length - 1) {
            Log.debug(20, "physical index too large!!");
            return ret;
        }
        Node physical = physicals[physicalIndex];
        try {
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)"@id");
            if (aNodes == null) {
                Log.debug(30, "aNodes is null!");
                return ret;
            }
            if (aNodes.getLength() < 1) {
                Log.debug(30, "aNodes is <1");
                return ret;
            }
            Node attr = aNodes.item(0);
            String id = attr.getNodeValue();
            Log.debug(40, "id: " + id);
            NodeList amd = XPathAPI.selectNodeList((Node)this.getMetadataNode(), (String)"additionalMetadata/describes");
            if (amd == null || amd.getLength() < 1) {
                return ret;
            }
            for (int j = 0; j < amd.getLength(); ++j) {
                Node desNode = amd.item(j);
                String txt = desNode.getFirstChild().getNodeValue();
                if (!(txt = txt.trim()).equals(id)) continue;
                return true;
            }
        }
        catch (Exception eee) {
            Log.debug(1, "exception in EML200");
        }
        return ret;
    }
}

