/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.AddAccessCommand;
import edu.ucsb.nceas.morpho.datapackage.AddAdditionalPartyCommand;
import edu.ucsb.nceas.morpho.datapackage.AddContactCommand;
import edu.ucsb.nceas.morpho.datapackage.AddCreatorCommand;
import edu.ucsb.nceas.morpho.datapackage.AddDocumentationCommand;
import edu.ucsb.nceas.morpho.datapackage.AddGeographicCovCommand;
import edu.ucsb.nceas.morpho.datapackage.AddKeywordCommand;
import edu.ucsb.nceas.morpho.datapackage.AddMethodCommand;
import edu.ucsb.nceas.morpho.datapackage.AddResearchProjectCommand;
import edu.ucsb.nceas.morpho.datapackage.AddTaxonomicCovCommand;
import edu.ucsb.nceas.morpho.datapackage.AddTemporalCovCommand;
import edu.ucsb.nceas.morpho.datapackage.AddTitleAbstractCommand;
import edu.ucsb.nceas.morpho.datapackage.AddUsageRightsCommand;
import edu.ucsb.nceas.morpho.datapackage.CreateNewDataPackageCommand;
import edu.ucsb.nceas.morpho.datapackage.DataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataPackageFactory;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DeleteColumnCommand;
import edu.ucsb.nceas.morpho.datapackage.DeleteRowCommand;
import edu.ucsb.nceas.morpho.datapackage.DeleteTableCommand;
import edu.ucsb.nceas.morpho.datapackage.EditColumnMetaDataCommand;
import edu.ucsb.nceas.morpho.datapackage.ImportDataCommand;
import edu.ucsb.nceas.morpho.datapackage.InsertColumnCommand;
import edu.ucsb.nceas.morpho.datapackage.InsertRowCommand;
import edu.ucsb.nceas.morpho.datapackage.OpenPreviousDialog;
import edu.ucsb.nceas.morpho.datapackage.RevertAllCommand;
import edu.ucsb.nceas.morpho.datapackage.RevertCommand;
import edu.ucsb.nceas.morpho.datapackage.SavePackageCommand;
import edu.ucsb.nceas.morpho.datapackage.SavePackageCopyCommand;
import edu.ucsb.nceas.morpho.datapackage.SortDataTableCommand;
import edu.ucsb.nceas.morpho.datapackage.TableCopyCommand;
import edu.ucsb.nceas.morpho.datapackage.TableCutCommand;
import edu.ucsb.nceas.morpho.datapackage.TablePasteCommand;
import edu.ucsb.nceas.morpho.datapackage.ViewDocumentationCommand;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.ButterflyFlapCoordinator;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;

public class DataPackagePlugin
implements PluginInterface,
ServiceProvider,
DataPackageInterface {
    private Morpho morpho = null;
    public static final String FILE_MENU_LABEL = "File";
    public static final String EDIT_MENU_LABEL = "Edit";
    public static final String METADATA_MENU_LABEL = "Documentation";
    public static final String DATA_MENU_LABEL = "Data";
    public static final int DOCUMENTATIONMENUPOSITION = 3;
    public static final int DATAMENUPOSITION = 4;
    public static final int EDITMENUPOSITION = 1;
    public static final String COPYKEY = "control c";
    public static final String CUTKEY = "control x";
    public static final String PASTEKEY = "control v";

    public DataPackagePlugin() {
    }

    public DataPackagePlugin(Morpho morpho) {
        this.morpho = morpho;
    }

    public void initialize(Morpho morpho) {
        this.morpho = morpho;
        this.loadConfigurationParameters();
        this.initializeActions();
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(DataPackageInterface.class, this);
            Log.debug(20, "Service added: DataPackageInterface.");
        }
        catch (ServiceExistsException see) {
            Log.debug(6, "Service registration failed: DataPackageInterface.");
            Log.debug(6, see.toString());
        }
        Log.debug(20, "Init DataPackage Plugin");
    }

    private void initializeActions() {
        UIController controller = UIController.getInstance();
        GUIAction saveAction = new GUIAction("Save...", UISettings.SAVE_ICON, new SavePackageCommand());
        saveAction.setMenuItemPosition(4);
        saveAction.setToolTipText("Save...");
        saveAction.setMenu(FILE_MENU_LABEL, 0);
        saveAction.setToolbarPosition(2);
        saveAction.setEnabled(false);
        saveAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        saveAction.setEnabledOnStateChange(StateChangeEvent.CREATE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(saveAction);
        GUIAction saveCopyAction = new GUIAction("Save Duplicate...", UISettings.DUPLICATE_ICON, new SavePackageCopyCommand());
        saveCopyAction.setMenuItemPosition(5);
        saveCopyAction.setToolTipText("Duplicate this data package and save locally...");
        saveCopyAction.setMenu(FILE_MENU_LABEL, 0);
        saveCopyAction.setToolbarPosition(3);
        saveCopyAction.setEnabled(false);
        saveCopyAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        saveCopyAction.setEnabledOnStateChange(StateChangeEvent.CREATE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(saveCopyAction);
        GUIAction revertTab = new GUIAction("Revert Entity to Saved Version", null, new RevertCommand());
        revertTab.setToolTipText("Revert to original data shown in current tab");
        revertTab.setMenuItemPosition(0);
        revertTab.setMenu(EDIT_MENU_LABEL, 1);
        revertTab.setEnabled(false);
        revertTab.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        revertTab.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        revertTab.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        revertTab.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(revertTab);
        GUIAction revertAll = new GUIAction("Revert All Entities to Saved Version", null, new RevertAllCommand());
        revertAll.setToolTipText("Revert to original data shown in all tabs");
        revertAll.setMenuItemPosition(1);
        revertAll.setMenu(EDIT_MENU_LABEL, 1);
        revertAll.setEnabled(false);
        revertAll.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        revertAll.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        revertAll.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        revertAll.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(revertAll);
        GUIAction cut = new GUIAction("Cut", null, new TableCutCommand());
        cut.setToolTipText("Cut value in data table cells");
        cut.setSmallIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif")));
        cut.setAcceleratorKeyString(CUTKEY);
        cut.setMenuItemPosition(2);
        cut.setSeparatorPosition(Morpho.SEPARATOR_PRECEDING);
        cut.setMenu(EDIT_MENU_LABEL, 1);
        cut.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        cut.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        cut.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        cut.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(cut);
        GUIAction copy = new GUIAction("Copy", null, new TableCopyCommand());
        copy.setToolTipText("Copy value in data table cells");
        copy.setSmallIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif")));
        copy.setAcceleratorKeyString(COPYKEY);
        copy.setMenuItemPosition(3);
        copy.setMenu(EDIT_MENU_LABEL, 1);
        copy.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        copy.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        copy.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        copy.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(copy);
        GUIAction paste = new GUIAction("Paste", null, new TablePasteCommand());
        paste.setToolTipText("Paste value in data table cells");
        paste.setSmallIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif")));
        paste.setAcceleratorKeyString(PASTEKEY);
        paste.setMenuItemPosition(4);
        paste.setMenu(EDIT_MENU_LABEL, 1);
        paste.setEnabledOnStateChange(StateChangeEvent.CLIPBOARD_HAS_DATA_TO_PASTE, true, 100);
        paste.setEnabledOnStateChange(StateChangeEvent.CLIPBOARD_HAS_NO_DATA_TO_PASTE, false, 100);
        paste.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        paste.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        paste.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(paste);
        copy.setEnabled(false);
        cut.setEnabled(false);
        paste.setEnabled(false);
        int i = 0;
        GUIAction addDocumentation = new GUIAction("Add/Edit Documentation...", null, new AddDocumentationCommand());
        addDocumentation.setToolTipText("Add/Edit XML documentation...");
        addDocumentation.setMenuItemPosition(i);
        addDocumentation.setMenu(METADATA_MENU_LABEL, 3);
        addDocumentation.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        addDocumentation.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        controller.addGuiAction(addDocumentation);
        GUIAction viewDocumentation = new GUIAction("View Documentation...", null, new ViewDocumentationCommand());
        viewDocumentation.setToolTipText("View Documentation as HTML...");
        viewDocumentation.setMenuItemPosition(++i);
        viewDocumentation.setMenu(METADATA_MENU_LABEL, 3);
        viewDocumentation.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        viewDocumentation.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        viewDocumentation.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        controller.addGuiAction(viewDocumentation);
        GUIAction addTitleAbstractAction = new GUIAction("Title & Abstract...", null, new AddTitleAbstractCommand());
        addTitleAbstractAction.setToolTipText("Edit Title & Abstract...");
        addTitleAbstractAction.setMenuItemPosition(++i);
        addTitleAbstractAction.setMenu(METADATA_MENU_LABEL, 3);
        addTitleAbstractAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addTitleAbstractAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addTitleAbstractAction);
        GUIAction addKeywordAction = new GUIAction("Keywords...", null, new AddKeywordCommand());
        addKeywordAction.setToolTipText("Add, edit or delete Keywords...");
        addKeywordAction.setMenuItemPosition(++i);
        addKeywordAction.setMenu(METADATA_MENU_LABEL, 3);
        addKeywordAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addKeywordAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addKeywordAction);
        GUIAction addCreatorAction = new GUIAction("Owners...", null, new AddCreatorCommand());
        addCreatorAction.setToolTipText("Add, edit or delete Owners...");
        addCreatorAction.setMenuItemPosition(++i);
        addCreatorAction.setMenu(METADATA_MENU_LABEL, 3);
        addCreatorAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addCreatorAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addCreatorAction);
        GUIAction addContactAction = new GUIAction("Contacts...", null, new AddContactCommand());
        addContactAction.setToolTipText("Add, edit or delete Contacts...");
        addContactAction.setMenuItemPosition(++i);
        addContactAction.setMenu(METADATA_MENU_LABEL, 3);
        addContactAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addContactAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addContactAction);
        GUIAction addAdditionalPartyAction = new GUIAction("Associated Parties...", null, new AddAdditionalPartyCommand());
        addAdditionalPartyAction.setToolTipText("Add, edit or delete Associated Parties...");
        addAdditionalPartyAction.setMenuItemPosition(++i);
        addAdditionalPartyAction.setMenu(METADATA_MENU_LABEL, 3);
        addAdditionalPartyAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addAdditionalPartyAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addAdditionalPartyAction);
        GUIAction addResearchProjectAction = new GUIAction("Research Project...", null, new AddResearchProjectCommand());
        addResearchProjectAction.setToolTipText("Edit Research Project details...");
        addResearchProjectAction.setMenuItemPosition(++i);
        addResearchProjectAction.setMenu(METADATA_MENU_LABEL, 3);
        addResearchProjectAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addResearchProjectAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addResearchProjectAction);
        GUIAction addUsageRightsAction = new GUIAction("Usage Rights...", null, new AddUsageRightsCommand());
        addUsageRightsAction.setToolTipText("Edit Usage Rights...");
        addUsageRightsAction.setMenuItemPosition(++i);
        addUsageRightsAction.setMenu(METADATA_MENU_LABEL, 3);
        addUsageRightsAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addUsageRightsAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addUsageRightsAction);
        GUIAction addGeographicCovAction = new GUIAction("Geographic Coverage...", null, new AddGeographicCovCommand());
        addGeographicCovAction.setToolTipText("Geographic Coverage...");
        addGeographicCovAction.setMenuItemPosition(++i);
        addGeographicCovAction.setMenu(METADATA_MENU_LABEL, 3);
        addGeographicCovAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addGeographicCovAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addGeographicCovAction);
        GUIAction addTemporalCovAction = new GUIAction("Temporal Coverage...", null, new AddTemporalCovCommand());
        addTemporalCovAction.setToolTipText("Temporal Coverage...");
        addTemporalCovAction.setMenuItemPosition(++i);
        addTemporalCovAction.setMenu(METADATA_MENU_LABEL, 3);
        addTemporalCovAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addTemporalCovAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addTemporalCovAction);
        GUIAction addTaxonomicCovAction = new GUIAction("Taxonomic Coverage...", null, new AddTaxonomicCovCommand());
        addTaxonomicCovAction.setToolTipText("Taxonomic Coverage...");
        addTaxonomicCovAction.setMenuItemPosition(++i);
        addTaxonomicCovAction.setMenu(METADATA_MENU_LABEL, 3);
        addTaxonomicCovAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addTaxonomicCovAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addTaxonomicCovAction);
        GUIAction addMethodAction = new GUIAction("Methods...", null, new AddMethodCommand());
        addMethodAction.setToolTipText("Edit Methods...");
        addMethodAction.setMenuItemPosition(++i);
        addMethodAction.setMenu(METADATA_MENU_LABEL, 3);
        addMethodAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addMethodAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addMethodAction);
        GUIAction addAccessAction = new GUIAction("Access Information...", null, new AddAccessCommand());
        addAccessAction.setToolTipText("Add, edit or delete Access Permissions...");
        addAccessAction.setMenuItemPosition(++i);
        addAccessAction.setMenu(METADATA_MENU_LABEL, 3);
        addAccessAction.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        addAccessAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        controller.addGuiAction(addAccessAction);
        i = 0;
        GUIAction createNewDatatable = new GUIAction("Create/Import New Data Table...", null, new ImportDataCommand());
        createNewDatatable.setToolTipText("Add a new table");
        createNewDatatable.setMenuItemPosition(i);
        createNewDatatable.setMenu(DATA_MENU_LABEL, 4);
        createNewDatatable.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        createNewDatatable.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        controller.addGuiAction(createNewDatatable);
        GUIAction deleteDatatable = new GUIAction("Delete Current Data Table", null, new DeleteTableCommand());
        deleteDatatable.setToolTipText("Remove the currently displayed table");
        deleteDatatable.setMenuItemPosition(++i);
        deleteDatatable.setMenu(DATA_MENU_LABEL, 4);
        deleteDatatable.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        deleteDatatable.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        deleteDatatable.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        deleteDatatable.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        deleteDatatable.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(deleteDatatable);
        GUIAction sortBySelectedColumn = new GUIAction("Sort by Selected Column", null, new SortDataTableCommand());
        sortBySelectedColumn.setToolTipText("Sort table by selected column");
        sortBySelectedColumn.setMenuItemPosition(i += 2);
        sortBySelectedColumn.setMenu(DATA_MENU_LABEL, 4);
        sortBySelectedColumn.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        sortBySelectedColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        sortBySelectedColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        sortBySelectedColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        sortBySelectedColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(sortBySelectedColumn);
        GUIAction insertRowAfter = new GUIAction("Insert Row After Selection", null, new InsertRowCommand("after"));
        insertRowAfter.setToolTipText("Insert a row after selected row");
        insertRowAfter.setMenuItemPosition(i += 2);
        insertRowAfter.setMenu(DATA_MENU_LABEL, 4);
        insertRowAfter.setAcceleratorKeyString("control I");
        insertRowAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        insertRowAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        insertRowAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        insertRowAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(insertRowAfter);
        GUIAction insertRowBefore = new GUIAction("Insert Row Before Selection", null, new InsertRowCommand("before"));
        insertRowBefore.setToolTipText("Insert a row before selected row");
        insertRowBefore.setMenuItemPosition(++i);
        insertRowBefore.setMenu(DATA_MENU_LABEL, 4);
        insertRowBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        insertRowBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        insertRowBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        insertRowBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(insertRowBefore);
        GUIAction deleteRow = new GUIAction("Delete Selected Row", null, new DeleteRowCommand());
        deleteRow.setToolTipText("Delete a selected row");
        deleteRow.setMenuItemPosition(++i);
        deleteRow.setMenu(DATA_MENU_LABEL, 4);
        deleteRow.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        deleteRow.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        deleteRow.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        deleteRow.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        deleteRow.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(deleteRow);
        GUIAction insertColumnAfter = new GUIAction("Insert Column After Selection", null, new InsertColumnCommand("after"));
        insertColumnAfter.setToolTipText("Insert a column after selected column");
        insertColumnAfter.setMenuItemPosition(i += 2);
        insertColumnAfter.setMenu(DATA_MENU_LABEL, 4);
        insertColumnAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        insertColumnAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        insertColumnAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        insertColumnAfter.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(insertColumnAfter);
        GUIAction insertColumnBefore = new GUIAction("Insert Column Before Selection", null, new InsertColumnCommand("before"));
        insertColumnBefore.setToolTipText("Insert a column before selected column");
        insertColumnBefore.setMenuItemPosition(++i);
        insertColumnBefore.setMenu(DATA_MENU_LABEL, 4);
        insertColumnBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        insertColumnBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        insertColumnBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        insertColumnBefore.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(insertColumnBefore);
        GUIAction deleteColumn = new GUIAction("Delete Selected Column", null, new DeleteColumnCommand());
        deleteColumn.setToolTipText("Delete a selected column");
        deleteColumn.setMenuItemPosition(++i);
        deleteColumn.setMenu(DATA_MENU_LABEL, 4);
        deleteColumn.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        deleteColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_EDITABLE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        deleteColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        deleteColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        deleteColumn.setEnabledOnStateChange(StateChangeEvent.CREATE_NONEDITABLE_ENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(deleteColumn);
        GUIAction editColumnMetadata = new GUIAction("Edit Column Documentation", null, new EditColumnMetaDataCommand());
        editColumnMetadata.setToolTipText("Edit selected column Documentation");
        editColumnMetadata.setMenuItemPosition(i += 2);
        editColumnMetadata.setMenu(DATA_MENU_LABEL, 4);
        editColumnMetadata.setEnabledOnStateChange(StateChangeEvent.CREATE_ENTITY_DATAPACKAGE_FRAME, true, 100);
        editColumnMetadata.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        editColumnMetadata.setEnabledOnStateChange(StateChangeEvent.CREATE_NOENTITY_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(editColumnMetadata);
        addDocumentation.setEnabled(false);
        viewDocumentation.setEnabled(false);
        createNewDatatable.setEnabled(false);
        deleteDatatable.setEnabled(false);
        addTitleAbstractAction.setEnabled(false);
        addKeywordAction.setEnabled(false);
        addCreatorAction.setEnabled(false);
        addContactAction.setEnabled(false);
        addAdditionalPartyAction.setEnabled(false);
        addResearchProjectAction.setEnabled(false);
        addUsageRightsAction.setEnabled(false);
        addGeographicCovAction.setEnabled(false);
        addTemporalCovAction.setEnabled(false);
        addTaxonomicCovAction.setEnabled(false);
        addMethodAction.setEnabled(false);
        addAccessAction.setEnabled(false);
        sortBySelectedColumn.setEnabled(false);
        insertRowAfter.setEnabled(false);
        insertRowBefore.setEnabled(false);
        deleteRow.setEnabled(false);
        insertColumnBefore.setEnabled(false);
        insertColumnAfter.setEnabled(false);
        deleteColumn.setEnabled(false);
        editColumnMetadata.setEnabled(false);
        GUIAction createNewDataPackage = new GUIAction("New Data Package...", UISettings.NEW_DATAPACKAGE_ICON, new CreateNewDataPackageCommand(this.morpho));
        createNewDataPackage.setSmallIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif")));
        createNewDataPackage.setToolTipText("Create a new data package");
        createNewDataPackage.setMenuItemPosition(1);
        createNewDataPackage.setMenu(FILE_MENU_LABEL, 0);
        createNewDataPackage.setToolbarPosition(0);
        controller.addGuiAction(createNewDataPackage);
    }

    private void loadConfigurationParameters() {
    }

    public void openDataPackage(String location, String identifier, Vector relations, ButterflyFlapCoordinator coordinator, String doctype) {
        AbstractDataPackage adp = null;
        Log.debug(11, "DataPackage: Got service request to open: " + identifier + " from " + location + ".");
        boolean metacat = false;
        boolean local = false;
        if (location.equals("metacat") || location.equals("localmetacat")) {
            metacat = true;
        }
        if (location.equals("local") || location.equals("localmetacat")) {
            local = true;
        }
        adp = DataPackageFactory.getDataPackage(identifier, metacat, local);
        long starttime = System.currentTimeMillis();
        final MorphoFrame packageWindow = UIController.getInstance().addWindow("Data Package: " + identifier);
        packageWindow.setBusy(true);
        packageWindow.setVisible(true);
        packageWindow.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Log.debug(50, "Processing window activated event");
                if (DataPackagePlugin.this.hasClipboardData(packageWindow)) {
                    StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(packageWindow, StateChangeEvent.CLIPBOARD_HAS_DATA_TO_PASTE));
                } else {
                    StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(packageWindow, StateChangeEvent.CLIPBOARD_HAS_NO_DATA_TO_PASTE));
                }
            }
        });
        if (coordinator != null) {
            coordinator.stopFlap();
        }
        long stoptime = System.currentTimeMillis();
        Log.debug(20, "ViewContainer startUp time: " + (stoptime - starttime));
        long starttime1 = System.currentTimeMillis();
        DataViewContainerPanel dvcp = null;
        dvcp = new DataViewContainerPanel(adp);
        dvcp.setFramework(this.morpho);
        dvcp.init();
        long stoptime1 = System.currentTimeMillis();
        Log.debug(20, "DVCP startUp time: " + (stoptime1 - starttime1));
        dvcp.setSize(packageWindow.getDefaultContentAreaSize());
        dvcp.setPreferredSize(packageWindow.getDefaultContentAreaSize());
        packageWindow.setMainContentPane(dvcp);
        dvcp.broadcastStoredStateChangeEvent();
        StateChangeMonitor monitor = StateChangeMonitor.getInstance();
        String packageLocation = location;
        if (packageLocation.equals("localmetacat")) {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_SYNCHRONIZED));
        } else {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_UNSYNCHRONIZED));
        }
        int lastDot = identifier.lastIndexOf(".");
        String verNum = identifier.substring(lastDot + 1, identifier.length());
        if (verNum.equals("1")) {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_NO_VERSIONS));
        } else {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_VERSIONS));
        }
        monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME));
        adp.loadCustomUnits();
        packageWindow.setBusy(false);
    }

    public void openNewDataPackage(AbstractDataPackage adp, ButterflyFlapCoordinator coordinator) {
        Log.debug(11, "DataPackage: Got service request to open a newly created AbstractDataPackage");
        boolean metacat = false;
        boolean local = false;
        long starttime = System.currentTimeMillis();
        final MorphoFrame packageWindow = UIController.getInstance().addWindow("Data Package: " + adp.getAccessionNumber());
        packageWindow.setBusy(true);
        packageWindow.setVisible(true);
        packageWindow.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Log.debug(50, "Processing window activated event");
                if (DataPackagePlugin.this.hasClipboardData(packageWindow)) {
                    StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(packageWindow, StateChangeEvent.CLIPBOARD_HAS_DATA_TO_PASTE));
                } else {
                    StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(packageWindow, StateChangeEvent.CLIPBOARD_HAS_NO_DATA_TO_PASTE));
                }
            }
        });
        if (coordinator != null) {
            coordinator.stopFlap();
        }
        long stoptime = System.currentTimeMillis();
        Log.debug(20, "ViewContainer startUp time: " + (stoptime - starttime));
        long starttime1 = System.currentTimeMillis();
        DataViewContainerPanel dvcp = null;
        dvcp = new DataViewContainerPanel(adp);
        dvcp.setFramework(this.morpho);
        dvcp.init();
        long stoptime1 = System.currentTimeMillis();
        Log.debug(20, "DVCP startUp time: " + (stoptime1 - starttime1));
        dvcp.setSize(packageWindow.getDefaultContentAreaSize());
        dvcp.setPreferredSize(packageWindow.getDefaultContentAreaSize());
        packageWindow.setMainContentPane(dvcp);
        dvcp.broadcastStoredStateChangeEvent();
        StateChangeMonitor monitor = StateChangeMonitor.getInstance();
        monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_UNSYNCHRONIZED));
        String identifier = adp.getAccessionNumber();
        int lastDot = identifier.lastIndexOf(".");
        String verNum = identifier.substring(lastDot + 1, identifier.length());
        if (verNum.equals("1")) {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_NO_VERSIONS));
        } else {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_VERSIONS));
        }
        monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME));
        adp.loadCustomUnits();
        packageWindow.setBusy(false);
    }

    public void openHiddenNewDataPackage(AbstractDataPackage adp, ButterflyFlapCoordinator coordinator) {
        Log.debug(11, "DataPackage: Got service request to open a newly created AbstractDataPackage");
        boolean metacat = false;
        boolean local = false;
        long starttime = System.currentTimeMillis();
        final MorphoFrame packageWindow = UIController.getInstance().addHiddenWindow("Data Package: " + adp.getAccessionNumber());
        packageWindow.setBusy(true);
        packageWindow.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Log.debug(50, "Processing window activated event");
                if (DataPackagePlugin.this.hasClipboardData(packageWindow)) {
                    StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(packageWindow, StateChangeEvent.CLIPBOARD_HAS_DATA_TO_PASTE));
                } else {
                    StateChangeMonitor.getInstance().notifyStateChange(new StateChangeEvent(packageWindow, StateChangeEvent.CLIPBOARD_HAS_NO_DATA_TO_PASTE));
                }
            }
        });
        if (coordinator != null) {
            coordinator.stopFlap();
        }
        long stoptime = System.currentTimeMillis();
        Log.debug(20, "ViewContainer startUp time: " + (stoptime - starttime));
        long starttime1 = System.currentTimeMillis();
        DataViewContainerPanel dvcp = null;
        dvcp = new DataViewContainerPanel(adp);
        dvcp.setFramework(this.morpho);
        dvcp.init();
        long stoptime1 = System.currentTimeMillis();
        Log.debug(20, "DVCP startUp time: " + (stoptime1 - starttime1));
        dvcp.setSize(packageWindow.getDefaultContentAreaSize());
        dvcp.setPreferredSize(packageWindow.getDefaultContentAreaSize());
        packageWindow.setMainContentPane(dvcp);
        dvcp.broadcastStoredStateChangeEvent();
        StateChangeMonitor monitor = StateChangeMonitor.getInstance();
        monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_UNSYNCHRONIZED));
        String identifier = adp.getAccessionNumber();
        int lastDot = identifier.lastIndexOf(".");
        String verNum = identifier.substring(lastDot + 1, identifier.length());
        if (verNum.equals("1")) {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_NO_VERSIONS));
        } else {
            monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME_VERSIONS));
        }
        monitor.notifyStateChange(new StateChangeEvent(dvcp, StateChangeEvent.CREATE_DATAPACKAGE_FRAME));
        packageWindow.setBusy(false);
        UIController.getInstance().setCurrentActiveWindow(packageWindow);
    }

    public String upload(String docid, boolean updateIds) throws MetacatUploadException {
        AbstractDataPackage adp = DataPackageFactory.getDataPackage(docid, false, true);
        AbstractDataPackage newadp = adp.upload(docid, updateIds);
        return newadp.getPackageId();
    }

    public void download(String docid) {
        AbstractDataPackage adp = DataPackageFactory.getDataPackage(docid, true, false);
        AbstractDataPackage newadp = adp.download(docid);
    }

    public void delete(String docid, String location) throws Exception {
        AbstractDataPackage adp;
        boolean metacat = false;
        boolean local = false;
        if (location.equals("metacat")) {
            metacat = true;
        }
        if (location.equals("local")) {
            local = true;
        }
        if (location.equals("localmetacat")) {
            metacat = true;
            local = true;
        }
        if ((adp = DataPackageFactory.getDataPackage(docid, metacat, local)) != null) {
            adp.delete(location);
        }
    }

    public void export(String docid, String path, String location) {
        boolean local = false;
        boolean metacat = false;
        if (location.equals("local")) {
            local = true;
        } else if (location.equals("metacat")) {
            metacat = true;
        } else if (location.equals("localmetacat")) {
            local = true;
            metacat = true;
        }
        AbstractDataPackage adp = DataPackageFactory.getDataPackage(docid, metacat, local);
        adp.export(path);
    }

    public void exportToEml2(String docid, String path, String location) {
        DataPackage dp = new DataPackage(location, docid, null, this.morpho, false);
        dp.exportToEml2(path);
    }

    public void exportToZip(String docid, String path, String location) {
        boolean local = false;
        boolean metacat = false;
        if (location.equals("local")) {
            local = true;
        } else if (location.equals("metacat")) {
            metacat = true;
        } else if (location.equals("localmetacat")) {
            local = true;
            metacat = true;
        }
        AbstractDataPackage adp = DataPackageFactory.getDataPackage(docid, metacat, local);
        adp.exportToZip(path);
    }

    public void createOpenPreviousVersionDialog(String title, int numOfVersion, Morpho morpho, boolean local) {
        OpenPreviousDialog open = new OpenPreviousDialog(title, numOfVersion, morpho, local);
        open.setVisible(true);
    }

    public String getNextId(Morpho morpho) {
        String identifier = null;
        AccessionNumber accession = new AccessionNumber(morpho);
        identifier = accession.getNextId();
        return identifier;
    }

    public String getDocIdFromMorphoFrame(MorphoFrame morphoFrame) {
        String docid = null;
        AbstractDataPackage adp = this.getAbstractDataPackageFromMorphoFrame(morphoFrame);
        docid = adp.getPackageId();
        Log.debug(50, "docid is: " + docid);
        return docid;
    }

    public boolean isDataPackageInLocal(MorphoFrame morphoFrame) {
        String location = null;
        boolean flagInLocal = false;
        DataViewContainerPanel dvcp = morphoFrame.getDataViewContainerPanel();
        AbstractDataPackage adp = dvcp.getAbstractDataPackage();
        location = adp.getLocation();
        if (location.equals("local") || location.equals("localmetacat")) {
            flagInLocal = true;
            Log.debug(50, "docid is in local");
        }
        return flagInLocal;
    }

    public boolean isDataPackageInNetwork(MorphoFrame morphoFrame) {
        String location = null;
        boolean flagInNetwork = false;
        DataViewContainerPanel dvcp = morphoFrame.getDataViewContainerPanel();
        AbstractDataPackage adp = dvcp.getAbstractDataPackage();
        location = adp.getLocation();
        if (location.equals("metacat") || location.equals("localmetacat")) {
            flagInNetwork = true;
            Log.debug(50, "docid is in network");
        }
        return flagInNetwork;
    }

    private AbstractDataPackage getAbstractDataPackageFromMorphoFrame(MorphoFrame morphoFrame) {
        AbstractDataPackage data = null;
        DataViewContainerPanel resultPane = null;
        if (morphoFrame != null) {
            resultPane = morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null) {
            data = resultPane.getAbstractDataPackage();
        }
        return data;
    }

    private boolean hasClipboardData(Component c) {
        boolean ret = true;
        Transferable t = c.getToolkit().getSystemClipboard().getContents(null);
        if (t == null) {
            ret = false;
        } else {
            String sel = "";
            try {
                sel = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                Log.debug(40, "Problem getting data from clipboard");
                ret = false;
            }
            if (sel == null || sel.length() < 1) {
                ret = false;
            }
        }
        return ret;
    }

    public Command getCommandObject(int commandIdentifier) throws ClassNotFoundException {
        switch (commandIdentifier) {
            case 10: {
                return new CreateNewDataPackageCommand(this.morpho);
            }
            case 20: {
                return new ImportDataCommand();
            }
        }
        ClassNotFoundException e = new ClassNotFoundException("command with ID=" + commandIdentifier + " not found");
        e.fillInStackTrace();
        throw e;
    }
}

