/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddTitleAbstractCommand
implements Command {
    private final String DATAPACKAGE_TITLE_GENERIC_NAME = "title";
    private final String DATAPACKAGE_ABSTRACT_GENERIC_NAME = "abstract";
    private Node titleRoot;
    private Node abstractRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage titleAbstractPage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (this.showTitleAbstractDialog()) {
            try {
                this.insertTitleAbstract();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(15, "Exception trying to modify title and abstract DOM: " + w);
                w.printStackTrace();
                Log.debug(5, "Unable to add title and abstract details!");
            }
        }
    }

    private boolean showTitleAbstractDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.titleAbstractPage = dpwPlugin.getPage("GENERAL");
        OrderedMap existingValuesMap = null;
        this.titleRoot = this.adp.getSubtree("title", 0);
        this.abstractRoot = this.adp.getSubtree("abstract", 0);
        if (this.titleRoot != null) {
            existingValuesMap = XMLUtilities.getDOMTreeAsXPathMap((Node)this.titleRoot);
        }
        if (this.abstractRoot != null) {
            existingValuesMap.putAll((Map)XMLUtilities.getDOMTreeAsXPathMap((Node)this.abstractRoot));
        }
        Log.debug(45, "sending previous data to titleAbstractPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.titleAbstractPage.setPageData(existingValuesMap, null);
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("title", 0);
            return false;
        }
        dialog = new ModalDialog(this.titleAbstractPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertTitleAbstract() {
        OrderedMap map = this.titleAbstractPage.getPageData("");
        OrderedMap titleMap = new OrderedMap();
        OrderedMap abstractMap = new OrderedMap();
        boolean insertAbstract = false;
        Log.debug(45, "\n insertTitleAbstract() Got title & abstract details from Title and Abstract page -\n" + map.toString());
        if (map == null || map.isEmpty()) {
            Log.debug(5, "Unable to get title & abstract details from input!");
            return;
        }
        titleMap.put((Object)"/title[1]", map.get((Object)"/title[1]"));
        map.remove((Object)"/title[1]");
        if (!map.isEmpty()) {
            String abstractKey = "/abstract/para[1]";
            String abstractValue = (String)map.get((Object)abstractKey);
            if (abstractValue == null || abstractValue.equals("")) {
                abstractMap.remove((Object)abstractKey);
                this.adp.deleteSubtree("abstract", 0);
            } else {
                abstractMap.put((Object)abstractKey, map.get((Object)abstractKey));
                insertAbstract = true;
            }
        }
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        Document doc = impl.createDocument("", "title", null);
        this.titleRoot = doc.getDocumentElement();
        try {
            XMLUtilities.getXPathMapAsDOMTree((Map)titleMap, (Node)this.titleRoot);
        }
        catch (TransformerException w) {
            Log.debug(5, "Unable to add title details to package!");
            Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(titleMap, titleRoot) with \n" + "map = " + titleMap + " and titleRoot = " + this.titleRoot);
            return;
        }
        this.adp.deleteSubtree("title", 0);
        Node check = this.adp.insertSubtree("title", this.titleRoot, 0);
        if (check != null) {
            Log.debug(45, "added new title details to package...");
        } else {
            Log.debug(5, "** ERROR: Unable to add new title details to package **");
        }
        if (insertAbstract) {
            DOMImplementation abstractImpl = DOMImplementationImpl.getDOMImplementation();
            Document abstractDoc = abstractImpl.createDocument("", "abstract", null);
            this.abstractRoot = abstractDoc.getDocumentElement();
            try {
                XMLUtilities.getXPathMapAsDOMTree((Map)abstractMap, (Node)this.abstractRoot);
            }
            catch (TransformerException w) {
                Log.debug(5, "Unable to add abstract details to package!");
                Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(abstractMap, abstractRoot) with \n" + "map = " + abstractMap + " and abstractRoot = " + this.abstractRoot);
                return;
            }
            this.adp.deleteSubtree("abstract", 0);
            check = this.adp.insertSubtree("abstract", this.abstractRoot, 0);
            if (check != null) {
                Log.debug(45, "added new abstract details to package...");
            } else {
                Log.debug(5, "** ERROR: Unable to add new abstract details to package **");
            }
        }
    }
}

