/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddAdditionalPartyCommand
implements Command {
    private final String DATAPACKAGE_ASSOCIATED_PARTY_GENERIC_NAME = "associatedParty";
    private List exsitingAssociatedPartyRoot;
    private Node associatedPartyRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage associatedPartyPage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        this.exsitingAssociatedPartyRoot = this.adp.getSubtrees("associatedParty");
        if (this.showAdditionalPartyDialog()) {
            try {
                this.insertAdditionalParty();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(15, "Exception trying to modify additionalParty DOM: " + w);
                w.printStackTrace();
                Log.debug(5, "Unable to add additionalParty details!");
            }
        } else {
            this.adp.deleteAllSubtrees("associatedParty");
            if (!this.exsitingAssociatedPartyRoot.isEmpty()) {
                Object nextXPathObj = null;
                int count = this.exsitingAssociatedPartyRoot.size();
                DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
                for (int i = count - 1; i > -1; --i) {
                    this.associatedPartyRoot = (Node)this.exsitingAssociatedPartyRoot.get(i);
                    Node check = this.adp.insertSubtree("associatedParty", this.associatedPartyRoot, 0);
                    if (check != null) {
                        Log.debug(45, "added new creator details to package...");
                        continue;
                    }
                    Log.debug(5, "** ERROR: Unable to add new creator details to package **");
                }
            }
        }
    }

    private boolean showAdditionalPartyDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.associatedPartyPage = dpwPlugin.getPage("PARTY_ASSOCIATED_PAGE");
        OrderedMap existingValuesMap = new OrderedMap();
        List additionalPartyList = this.adp.getSubtrees("associatedParty");
        if (!additionalPartyList.isEmpty()) {
            Iterator listIt = additionalPartyList.iterator();
            Object nextObj = null;
            Object nextTempObj2 = null;
            String nextTempString = null;
            int count = 1;
            while (listIt.hasNext()) {
                nextObj = listIt.next();
                OrderedMap tempMap = XMLUtilities.getDOMTreeAsXPathMap((Node)nextObj);
                for (Object nextTempObj2 : tempMap.keySet()) {
                    nextTempString = nextTempObj2;
                    if (nextTempString == null) continue;
                    existingValuesMap.put((Object)("/associatedParty[" + count + "]" + nextTempString.substring("associatedParty".length() + 1, nextTempString.length())), tempMap.get(nextTempObj2));
                }
                ++count;
            }
        }
        Log.debug(45, "sending previous data to associatedPartyPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.associatedPartyPage.setPageData(existingValuesMap, null);
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("associatedParty", 0);
            return false;
        }
        dialog = new ModalDialog(this.associatedPartyPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertAdditionalParty() {
        OrderedMap additionalPartyMap;
        OrderedMap map = this.associatedPartyPage.getPageData("/associatedParty[");
        Log.debug(45, "\n insertAdditionalParty() Got additionalParty details from additionalParty page -\n" + map.toString());
        if (map == null) {
            Log.debug(5, "Unable to get additionalParty details from input!");
            return;
        }
        if (map.isEmpty()) {
            Log.debug(45, "Deleting all associated party details!");
        }
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        this.adp.deleteAllSubtrees("associatedParty");
        Iterator additionalPartyIt = map.keySet().iterator();
        Object nextXPathObj2 = null;
        String nextXPath = null;
        HashMap<String, OrderedMap> additionalPartySetMap = new HashMap<String, OrderedMap>();
        while (additionalPartyIt.hasNext()) {
            nextXPathObj2 = additionalPartyIt.next();
            if (nextXPathObj2 == null) continue;
            nextXPath = nextXPathObj2;
            String temp = nextXPath.substring("associatedParty".length() + 2, nextXPath.length());
            temp = temp.substring(0, temp.indexOf("]"));
            nextXPath = nextXPath.replaceFirst(temp, "1");
            if (additionalPartySetMap.containsKey(temp)) {
                additionalPartyMap = (OrderedMap)additionalPartySetMap.get(temp);
                additionalPartyMap.put((Object)nextXPath, map.get(nextXPathObj2));
                continue;
            }
            additionalPartyMap = new OrderedMap();
            additionalPartyMap.put((Object)nextXPath, map.get(nextXPathObj2));
            additionalPartySetMap.put(temp, additionalPartyMap);
        }
        for (Object nextXPathObj2 : additionalPartySetMap.keySet()) {
            additionalPartyMap = (OrderedMap)additionalPartySetMap.get(nextXPathObj2);
            Document doc = impl.createDocument("", "associatedParty", null);
            this.associatedPartyRoot = doc.getDocumentElement();
            try {
                XMLUtilities.getXPathMapAsDOMTree((Map)additionalPartyMap, (Node)this.associatedPartyRoot);
            }
            catch (TransformerException w) {
                Log.debug(5, "Unable to add additionalParty details to package!");
                Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, associatedPartyRoot) with \n" + "map = " + map + " and associatedPartyRoot = " + this.associatedPartyRoot);
                return;
            }
            Node check = this.adp.insertSubtree("associatedParty", this.associatedPartyRoot, 0);
            if (check != null) {
                Log.debug(45, "added new additionalParty details to package...");
                continue;
            }
            Log.debug(5, "** ERROR: Unable to add new additionalParty details to package **");
        }
    }
}

