/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;
import org.w3c.dom.Element;

public class KeyEventData
extends AbstractKeyEventData {
    private Component m_comp = null;
    private int m_keyCode = 0;

    public KeyEventData() {
    }

    public KeyEventData(JFCTestCase testCase, Component comp, int keyCode) {
        this(testCase, comp, keyCode, 0, 300L);
    }

    public KeyEventData(JFCTestCase testCase, Component comp, int keyCode, long sleepTime) {
        this(testCase, comp, keyCode, 0, sleepTime);
    }

    public KeyEventData(JFCTestCase testCase, Component comp, int keyCode, int modifiers, long sleepTime) {
        this.setTestCase(testCase);
        this.setSource(comp);
        this.setModifiers(modifiers);
        this.setKeyCode(keyCode);
        this.setSleepTime(sleepTime);
        this.setValid(true);
    }

    public final void setKeyCode(int keyCode) {
        this.m_keyCode = keyCode;
        this.setupKeyStrokes();
    }

    public final int getKeyCode() {
        return this.m_keyCode;
    }

    public final void setSource(Component comp) {
        this.m_comp = comp;
    }

    public final Component getSource() {
        return this.m_comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public boolean canConsume(AWTEvent ae) {
        if (!(ae instanceof KeyEvent)) {
            return false;
        }
        if (this.isValid()) {
            return false;
        }
        char c = ((KeyEvent)ae).getKeyChar();
        return super.canConsume(ae) && (c == '\uffff' || Character.isISOControl(c));
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        this.setSource((Component)ae.getSource());
        this.setModifiers(((KeyEvent)ae).getModifiers());
        char c = ((KeyEvent)ae).getKeyChar();
        if (Character.isISOControl(c)) {
            this.setKeyCode(c);
        } else {
            this.setKeyCode(((KeyEvent)ae).getKeyCode());
        }
        this.setSleepTime(this.getDefaultSleepTime());
        this.setValid(true);
        return true;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("code", "" + this.m_keyCode);
    }

    public String toString() {
        return "KeyEventData:" + this.m_keyCode + " on " + this.getSource() + " " + this.getModifiers() + " " + this.getSleepTime();
    }

    protected void setupKeyStrokes() {
        KeyMapping km = TestHelper.getKeyMapping();
        this.clearKeyStrokes();
        JFCKeyStroke[] strokes = km.getKeyStrokes(this.m_keyCode);
        this.addKeyStrokes(strokes);
        this.applyModifier(this.getModifiers());
    }
}

