/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.OutputUni;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.Utility;
import phelps.lang.Integers;

public class Encrypt {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.3 of $Date: 2005/07/26 21:16:21 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Encrypt [<options>] <PDF-file...>\n\t[-user <password>] [-owner <password>] [-password <existing-owner>]\n\t[-rest[rictions] [pPcCmtfa]]   [-perm[issions] [pPcCmtfa]]\n\t[-compat] [-keylen <multiple-of-8>\n\t[-inplace]";
    private static final String PERMS = "  Pmct  fCap";
    private String ownerpassword_ = null;
    private String userpassword_ = null;
    private int permissions_ = -4;
    private int keylen_ = 128;
    private boolean fverbose_ = false;
    private boolean fquiet_ = false;
    private String password_ = null;
    private boolean finplace_ = false;
    private PDFReader pdfr_;

    public Encrypt(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Encrypt(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Encrypt(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Encrypt(PDFReader pDFReader) {
    }

    public boolean setPassword(String string) {
        return this.pdfr_.getEncrypt().getSecurityHandler().authOwner(string);
    }

    public void setOwnerPassword(String string) {
        this.ownerpassword_ = string;
    }

    public void setUserPassword(String string) {
        this.userpassword_ = string;
    }

    public void setKeyLength(int n) throws IllegalArgumentException {
        if (n < 40) {
            throw new IllegalArgumentException("key length must be at least 40");
        }
        if (n % 8 != 0) {
            throw new IllegalArgumentException("key length must be multiple of 8, such as 40 or 128");
        }
        this.keylen_ = n;
    }

    public void setPermissions(int n) {
        this.permissions_ = n;
    }

    public void setPermissions(String string) throws IllegalArgumentException {
        if (string.startsWith("all")) {
            this.permissions_ = -4;
        } else {
            this.permissions_ = 192;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                int n2 = PERMS.indexOf(c);
                if (n2 != -1) {
                    this.permissions_ |= 1 << n2;
                    continue;
                }
                throw new IllegalArgumentException("invalid permission letter: " + c + ".  Valid: pPcCmtfa.");
            }
        }
    }

    public void setRestrictions(String string) throws IllegalArgumentException {
        if (string.startsWith("all")) {
            this.permissions_ = 192;
        } else {
            this.permissions_ = -4;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                int n2 = PERMS.indexOf(c);
                if (n2 != -1) {
                    this.permissions_ &= ~(1 << n2);
                    continue;
                }
                throw new IllegalArgumentException("invalid permission letter: " + c + ".  Valid: pPcCmtfa.");
            }
        }
    }

    public void writeFile(File file) throws IOException, ParseException {
        this.writeUni(OutputUni.getInstance(file, null));
    }

    public byte[] writeBytes() throws IOException, ParseException {
        OutputUni outputUni = OutputUni.getInstance(new byte[this.pdfr_.getObjCnt() * 100], null);
        this.writeUni(outputUni);
        return outputUni.toByteArray();
    }

    public void writeUni(OutputUni outputUni) throws IOException, ParseException {
        this.encrypt(new PDFWriter(outputUni, this.pdfr_));
    }

    public PDFReader writePipe() throws IOException, ParseException {
        return null;
    }

    private Object encrypt(PDFWriter pDFWriter) throws IOException, ParseException {
        if (!this.pdfr_.isAuthorized()) {
            this.setPassword(this.ownerpassword_);
        }
        if (!this.pdfr_.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        SecurityHandler securityHandler = this.pdfr_.getEncrypt().getSecurityHandler();
        if (securityHandler instanceof SecurityHandlerStandard && (((SecurityHandlerStandard)securityHandler).getPerm() & 1) == 0) {
            throw new ParseException("need OWNER password of SOURCE PDF");
        }
        if (this.fverbose_) {
            pDFWriter.setMonitor(true);
        }
        this.encrypt2(pDFWriter);
        Object object = pDFWriter.writePDF();
        this.pdfr_.close();
        this.pdfr_ = null;
        pDFWriter.close();
        return object;
    }

    private void encrypt2(PDFWriter pDFWriter) throws IOException, ParseException {
        StringBuffer stringBuffer;
        this.pdfr_.fault();
        Dict dict = pDFWriter.getTrailer();
        Object[] objectArray = (Object[])pDFWriter.getObject(dict.get("ID"));
        if (objectArray != null && objectArray.length == 2) {
            stringBuffer = (StringBuffer)objectArray[0];
        } else {
            stringBuffer = COS.createID(this.pdfr_.getURI(), this.pdfr_.getInfo());
            objectArray = new Object[]{stringBuffer, stringBuffer};
            dict.put("ID", objectArray);
        }
        if (this.ownerpassword_ == null) {
            this.ownerpassword_ = this.userpassword_;
        }
        int n = this.permissions_;
        int n2 = this.keylen_;
        int n3 = n2 == 40 ? 1 : 2;
        int n4 = n3 == 1 ? 2 : 3;
        Dict dict2 = new Dict(13);
        dict2.put("Filter", "Standard");
        dict2.put("V", Integers.getInteger(n3));
        if (n2 != 40) {
            dict2.put("Length", Integers.getInteger(n2));
        }
        dict2.put("R", Integers.getInteger(n4));
        dict2.put("P", Integers.getInteger(n));
        SecurityHandlerStandard securityHandlerStandard = new SecurityHandlerStandard(stringBuffer, n4, n, n2, this.userpassword_, this.ownerpassword_);
        dict2.put("U", securityHandlerStandard.computeU(this.userpassword_));
        dict2.put("O", securityHandlerStandard.computeO(this.ownerpassword_, this.userpassword_));
        dict.put("Encrypt", pDFWriter.addObject(dict2));
        pDFWriter.setPassword(this.userpassword_);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-own")) {
                this.setOwnerPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-user")) {
                this.setUserPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-rest")) {
                this.setRestrictions(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-perm")) {
                this.setPermissions(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-old") || string.startsWith("compat")) {
                this.setKeyLength(40);
                continue;
            }
            if (string.startsWith("-keylen")) {
                String string2 = stringArray[++n];
                try {
                    int n3 = Integer.parseInt(string2);
                    if (n3 < 40 || n3 % 8 != 0) {
                        Utility.error(n3 + " must be >=40 and a multiple of 8");
                    }
                    this.setKeyLength(n3);
                }
                catch (NumberFormatException numberFormatException) {
                    Utility.error("Couldn't parse '" + string2 + "' as a number");
                }
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.equals("-inplace")) {
                this.finplace_ = true;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Encrypt encrypt = new Encrypt((PDFReader)null);
        int n = encrypt.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                encrypt.pdfr_ = new PDFReader(file);
                encrypt.setPassword(encrypt.password_);
                String string = file.getName();
                if (string.toLowerCase().endsWith(".pdf")) {
                    string = string.substring(0, string.length() - 4);
                }
                encrypt.writeFile(encrypt.finplace_ ? file : new File(string + "-y.pdf"));
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
            finally {
                if (encrypt.pdfr_ == null) continue;
                try {
                    encrypt.pdfr_.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.exit(0);
    }
}

