/*
 * Decompiled with CFR 0.152.
 */
package tool.doc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import multivalent.Browser;
import multivalent.Document;
import multivalent.Multivalent;
import multivalent.node.Root;
import phelps.io.PrintStreams;

public final class View {
    public static final String VERSION = "1.0 of $Date: 2004/01/02 02:32:29 $";
    public static final String USAGE = "java tool.doc.View [<options>] [<file...>]\n\t[-verbose]";
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;

    public View() {
        this.defaults();
    }

    public void defaults() {
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public static void swing() {
        Multivalent multivalent = Multivalent.getInstance();
        final Browser browser = multivalent.getBrowser("name", "Basic", false);
        JFrame jFrame = new JFrame("my app");
        final FileDialog fileDialog = new FileDialog((Frame)jFrame, "Open Document", 0);
        jFrame.setBounds(100, 50, 500, 350);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)browser, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton("<=");
        jButton.addActionListener(new SemanticSender(browser, "backwardDocument", null));
        jPanel.add(jButton);
        jButton = new JButton("=>");
        jButton.addActionListener(new SemanticSender(browser, "forwardDocument", null));
        jPanel.add(jButton);
        JTextField jTextField = new JTextField();
        jTextField.setSize(200, 40);
        jTextField.setText("type URLs here");
        jPanel.add(jTextField);
        jButton = new JButton("<-");
        jButton.addActionListener(new SemanticSender(browser, "previousPage", null));
        jPanel.add(jButton);
        jButton = new JButton("->");
        jButton.addActionListener(new SemanticSender(browser, "nextPage", null));
        jPanel.add(jButton);
        jButton = new JButton("open");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fileDialog.show();
                String string = fileDialog.getFile();
                if (string != null) {
                    browser.eventq("openDocument", new File(new File(fileDialog.getDirectory()), string).toURI());
                }
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("exit");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel.add(jButton);
        container.add((Component)jPanel, "North");
        jFrame.pack();
        jFrame.setVisible(true);
        Root root = browser.getRoot();
        Document document = (Document)root.findBFS("content");
        document.setScrollbarShowPolicy((byte)0);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.equals("-label")) continue;
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        View view = new View();
        int n = view.commandLine(stringArray);
        view.swing();
    }

    static class SemanticSender
    implements ActionListener {
        Browser br_;
        String cmd_;
        Object arg_;

        SemanticSender(Browser browser, String string, Object object) {
            this.br_ = browser;
            this.cmd_ = string;
            this.arg_ = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.br_.eventq(this.cmd_, this.arg_);
        }
    }
}

