/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import com.pt.crypto.RC4;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.SecurityHandler;
import phelps.lang.StringBuffers;
import phelps.lang.Strings;

public class SecurityHandlerStandard
extends SecurityHandler {
    static final boolean DEBUG = false;
    public static final int PERM_ALL = -4;
    public static final int PERM_NONE = 192;
    public static final int PERM_PRINT = 4;
    public static final int PERM_MODIFY = 8;
    public static final int PERM_COPY = 16;
    public static final int PERM_ANNO = 32;
    public static final int PERM_FILL = 256;
    public static final int PERM_COPY_R3 = 512;
    public static final int PERM_ASSEMBLE = 1024;
    public static final int PERM_PRINT_GOOD = 2048;
    public static final int PERM_DECRYPT = 1;
    private static final byte[] PADDING;
    private int Length_;
    private int R_;
    private int perm_ = 192;
    private int P_;
    private byte[] O_;
    private byte[] U_;
    private byte[] ID0_;
    private byte[] key_ = null;
    private RC4 rc4_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SecurityHandlerStandard(Dict dict, COSSource cOSSource) throws ParseException {
        super(dict, cOSSource);
        if (!($assertionsDisabled || cOSSource != null && dict != null)) {
            throw new AssertionError();
        }
        Dict dict2 = cOSSource.getTrailer();
        Object object = dict.get("Length");
        int n = this.Length_ = object != null ? ((Number)object).intValue() : 40;
        if (!($assertionsDisabled || this.Length_ > 0 && this.Length_ % 8 == 0)) {
            throw new AssertionError(this.Length_);
        }
        this.R_ = ((Number)dict.get("R")).intValue();
        this.O_ = StringBuffers.getBytes8((StringBuffer)dict.get("O"));
        this.U_ = StringBuffers.getBytes8((StringBuffer)dict.get("U"));
        this.P_ = ((Number)dict.get("P")).intValue();
        Object[] objectArray = (Object[])dict2.get("ID");
        if (!$assertionsDisabled && objectArray == null) {
            throw new AssertionError();
        }
        this.ID0_ = StringBuffers.getBytes8((StringBuffer)objectArray[0]);
        this.validate();
    }

    public SecurityHandlerStandard(StringBuffer stringBuffer, int n, int n2, int n3, String string, String string2) {
        super(null, null);
        this.Length_ = n3;
        this.R_ = n;
        this.P_ = n2;
        this.ID0_ = StringBuffers.getBytes8(stringBuffer);
        this.O_ = StringBuffers.getBytes8(this.computeO(string2, string));
        this.U_ = StringBuffers.getBytes8(this.computeU(string));
        this.validate();
        this.key_ = this.computeKey(string);
        if (!$assertionsDisabled && !this.authUser(string)) {
            throw new AssertionError();
        }
    }

    public SecurityHandlerStandard(byte[] byArray) {
        super(null, null);
        this.key_ = byArray;
        this.Length_ = this.key_.length;
    }

    public Object clone() {
        SecurityHandlerStandard securityHandlerStandard = (SecurityHandlerStandard)super.clone();
        this.rc4_ = null;
        return securityHandlerStandard;
    }

    private void validate() {
        if (2 > this.R_ || this.R_ > 4) {
            throw new IllegalArgumentException("Invalid revision of Standard security handler " + this.R_);
        }
        if (!($assertionsDisabled || this.O_.length == 32 && this.U_.length == 32)) {
            throw new AssertionError((Object)(this.O_.length + ", " + this.U_.length));
        }
    }

    public int getLength() {
        return this.Length_;
    }

    public int getR() {
        return this.R_;
    }

    public int getP() {
        return this.P_;
    }

    public int getPerm() {
        return this.perm_;
    }

    public byte[] getKey() {
        return this.key_;
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) {
        return this.decrypt(byArray, n, n2);
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) {
        this.rc4_.decrypt(byArray, n, n2);
        return byArray;
    }

    public boolean isAuthorized() {
        return this.key_ != null;
    }

    public SecurityHandler reset(int n, int n2) {
        int n3 = this.key_.length;
        byte[] byArray = new byte[n3 + 5];
        System.arraycopy(this.key_, 0, byArray, 0, n3);
        byArray[n3] = (byte)(n & 0xFF);
        byArray[n3 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n3 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 & 0xFF);
        byArray[n3 + 4] = (byte)(n2 >> 8 & 0xFF);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.update(byArray);
        byte[] byArray2 = new byte[Math.min(n3 + 5, 16)];
        System.arraycopy(messageDigest.digest(), 0, byArray2, 0, byArray2.length);
        this.rc4_ = new RC4(byArray2);
        return this;
    }

    public static byte[] encrypt(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        if (!($assertionsDisabled || byArray != null && n3 >= 0 && n4 >= 0)) {
            throw new AssertionError();
        }
        SecurityHandlerStandard securityHandlerStandard = new SecurityHandlerStandard(byArray);
        ((SecurityHandler)securityHandlerStandard).reset(n3, n4);
        return ((SecurityHandler)securityHandlerStandard).encrypt(byArray2, n, n2);
    }

    public byte[] computeKey(String string) {
        int n = this.R_ == 2 ? 5 : (this.R_ >= 3 ? this.Length_ / 8 : -1);
        return this.computeKey(string, n);
    }

    public byte[] computeKey(String string, int n) {
        byte[] byArray = SecurityHandlerStandard.pad(string);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.update(byArray);
        messageDigest.update(this.O_);
        int n2 = 0;
        int n3 = this.P_;
        while (n2 < 4) {
            messageDigest.update((byte)n3);
            ++n2;
            n3 >>= 8;
        }
        byArray = messageDigest.digest(this.ID0_);
        if (this.R_ >= 3) {
            for (n2 = 0; n2 < 50; ++n2) {
                byArray = messageDigest.digest(byArray);
            }
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    protected static byte[] pad(String string) {
        byte[] byArray = new byte[32];
        if (string == null) {
            string = "";
        }
        int n = Math.min(string.length(), 32);
        System.arraycopy(Strings.getBytes8(string), 0, byArray, 0, n);
        System.arraycopy(PADDING, 0, byArray, n, 32 - n);
        return byArray;
    }

    public StringBuffer computeO(String string, String string2) {
        byte[] byArray = SecurityHandlerStandard.pad(string);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byArray = messageDigest.digest(byArray);
        if (this.R_ >= 3) {
            for (int i = 0; i < 50; ++i) {
                byArray = messageDigest.digest(byArray);
            }
        }
        int n = this.R_ == 2 ? 5 : (this.R_ >= 3 ? this.Length_ / 8 : -1);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray = SecurityHandlerStandard.pad(string2);
        RC4 rC4 = new RC4(byArray2);
        rC4.encrypt(byArray);
        if (this.R_ >= 3) {
            byte[] byArray3 = new byte[byArray2.length];
            for (int i = 1; i <= 19; ++i) {
                int n2 = byArray3.length;
                for (int j = 0; j < n2; ++j) {
                    byArray3[j] = (byte)(byArray2[j] ^ i);
                }
                RC4 rC42 = new RC4(byArray3);
                rC42.encrypt(byArray);
            }
        }
        return StringBuffers.valueOf(byArray);
    }

    public StringBuffer computeU(String string) {
        byte[] byArray;
        if (this.R_ == 2) {
            byte[] byArray2 = this.computeKey(string);
            byArray = (byte[])PADDING.clone();
            RC4 rC4 = new RC4(byArray2);
            rC4.encrypt(byArray);
        } else {
            if (!$assertionsDisabled && this.R_ < 3) {
                throw new AssertionError(this.R_);
            }
            byte[] byArray3 = this.computeKey(string);
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            messageDigest.update(PADDING);
            byte[] byArray4 = messageDigest.digest(this.ID0_);
            if (!$assertionsDisabled && byArray4.length != 16) {
                throw new AssertionError();
            }
            RC4 rC4 = new RC4(byArray3);
            rC4.encrypt(byArray4);
            byte[] byArray5 = new byte[byArray3.length];
            for (int i = 1; i <= 19; ++i) {
                int n = byArray5.length;
                for (int j = 0; j < n; ++j) {
                    byArray5[j] = (byte)(byArray3[j] ^ i);
                }
                RC4 rC42 = new RC4(byArray5);
                rC42.encrypt(byArray4);
            }
            byArray = new byte[32];
            System.arraycopy(byArray4, 0, byArray, 0, 16);
            System.arraycopy(PADDING, 0, byArray, 16, 16);
        }
        return StringBuffers.valueOf(byArray);
    }

    public boolean authUser(String string) {
        byte[] byArray = StringBuffers.getBytes8(this.computeU(string));
        boolean bl = true;
        for (int i = 0; i < 16; ++i) {
            if (byArray[i] == this.U_[i]) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.key_ = this.computeKey(string);
            this.perm_ = this.P_ & 0xFFFFFFFC;
        }
        return bl;
    }

    public boolean authOwner(String string) {
        Object object;
        byte[] byArray = SecurityHandlerStandard.pad(string);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byArray = messageDigest.digest(byArray);
        if (this.R_ >= 3) {
            for (int i = 0; i < 50; ++i) {
                byArray = messageDigest.digest(byArray);
            }
        }
        int n = this.R_ == 2 ? 5 : (this.R_ >= 3 ? this.Length_ / 8 : -1);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray = (byte[])this.O_.clone();
        if (this.R_ == 2) {
            object = new RC4(byArray2);
            ((RC4)object).decrypt(byArray);
        } else {
            if (!$assertionsDisabled && this.R_ < 3) {
                throw new AssertionError();
            }
            object = new byte[byArray2.length];
            for (int i = 19; i >= 0; --i) {
                int n2 = ((Object)object).length;
                for (int j = 0; j < n2; ++j) {
                    object[j] = (byte)(byArray2[j] ^ i);
                }
                RC4 rC4 = new RC4((byte[])object);
                rC4.decrypt(byArray);
            }
        }
        boolean bl = this.authUser(Strings.valueOf(byArray));
        if (bl) {
            this.perm_ = -3;
        }
        return bl;
    }

    static {
        $assertionsDisabled = !SecurityHandlerStandard.class.desiredAssertionStatus();
        PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    }
}

