/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import com.pt.awt.NFont;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.List;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.CLGeneral;
import multivalent.Context;
import multivalent.ContextListener;
import multivalent.Document;
import multivalent.INode;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.StyleSheet;
import multivalent.gui.VRadiobox;
import multivalent.gui.VRadiogroup;
import multivalent.node.FixedLeafImage;

public class OcrView
extends Behavior
implements ImageObserver {
    static final boolean DEBUG = false;
    public static final String MENU_CATEGORY = "OCR";
    public static final String MSG_IMAGE_OCR = "viewImageOCR";
    public static final String MSG_OCR = "viewOCR";
    public static final String MSG_IMAGE = "viewImage";
    public static final String MODE_IMAGE_ONLY = "image-only";
    public static final String VAR_FULLIMAGE = "OCRimage";
    static NFont smallfont = NFont.getInstance("Times", 400, 66, 12.0f);
    static NFont bigfont = NFont.getInstance("Times", 700, 2, 24.0f);
    FixedLeafImage[] frags_ = null;
    INode ocrroot_ = null;
    boolean alldone_ = false;
    String[] modes_ = new String[]{"image", "ocr", "image-only"};
    String mode_ = "image";
    CLGeneral rootStyle_ = null;
    static String[] titles = new String[]{"Image + OCR", "viewImageOCR", "OCR only", "viewOCR", "Image only", "viewImage"};

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            VRadiogroup vRadiogroup = new VRadiogroup();
            int n = 3;
            for (int i = 0; i < n; ++i) {
                VRadiobox vRadiobox = (VRadiobox)this.createUI("radiobox", titles[i * 2], "event " + titles[i * 2 + 1], iNode, MENU_CATEGORY, false);
                vRadiobox.setRadiogroup(vRadiogroup);
                if (this.mode_ != this.modes_[i]) continue;
                vRadiogroup.setActive(vRadiobox);
            }
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        boolean bl = true;
        String string2 = null;
        if (MSG_IMAGE_OCR == string) {
            string2 = "image";
        } else if (MSG_OCR == string) {
            string2 = "ocr";
        } else if (MSG_IMAGE == string) {
            string2 = MODE_IMAGE_ONLY;
        } else {
            bl = false;
        }
        if (string2 != null && this.ocrroot_ != null) {
            this.mode_ = string2;
            if (this.rootStyle_ == null) {
                System.out.println("rootStyle_=null in semEvAf");
                System.exit(1);
            }
            this.rootStyle_.setSignal("viewOcrAs", string2);
        }
        if (bl) {
            this.getBrowser().repaint();
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Browser browser = this.getBrowser();
        boolean bl = this.alldone_ = (n & 0x60) != 0;
        if ((n & 1) == 0 || (n & 2) != 0) {
            // empty if block
        }
        if ((n & 0x20) != 0) {
            this.formatAfter(this.ocrroot_);
            browser.repaint(100L);
        }
        return !this.alldone_;
    }

    public void buildAfter(Document document) {
        Object object;
        if (!(document.childAt(0) instanceof INode)) {
            return;
        }
        this.ocrroot_ = (INode)document.childAt(0);
        Object object2 = document.getVar(VAR_FULLIMAGE);
        if (object2 instanceof FixedLeafImage) {
            this.frags_ = new FixedLeafImage[1];
            this.frags_[0] = (FixedLeafImage)object2;
        } else if (object2 instanceof List) {
            object = (List)object2;
            this.frags_ = object.toArray(new FixedLeafImage[object.size()]);
        }
        object = this.getBrowser();
        int n = this.frags_.length;
        for (int i = 0; i < n; ++i) {
        }
        StyleSheet styleSheet = document.getStyleSheet();
        String string = this.ocrroot_.getName();
        this.rootStyle_ = (CLGeneral)styleSheet.get(string);
        if (this.rootStyle_ == null) {
            this.rootStyle_ = new CLGeneral();
            styleSheet.put(string, (ContextListener)this.rootStyle_);
        }
        this.mode_ = document.getRoot().getAttr("viewOcrAs", "image");
        this.rootStyle_.setSignal("viewOcrAs", this.mode_);
        this.alldone_ = false;
        this.ocrroot_.addObserver(this);
    }

    public boolean formatAfter(Node node) {
        if (this.frags_ != null) {
            int n = this.frags_.length;
            for (int i = 0; i < n; ++i) {
                FixedLeafImage fixedLeafImage = this.frags_[i];
                Image image = fixedLeafImage.getImage();
                int n2 = image.getWidth(this);
                int n3 = image.getHeight(this);
                Rectangle rectangle = fixedLeafImage.getIbbox();
                if (n2 == -1 || n3 == -1) continue;
                node.bbox.add(rectangle.x + n2, rectangle.y + n3);
            }
        }
        return false;
    }

    public boolean paintBefore(Context context, Node node) {
        context.reset();
        Graphics2D graphics2D = context.g;
        String string = (String)context.signal.get("viewOcrAs");
        if (this.ocrroot_.size() == 0) {
            bigfont.drawString(graphics2D, "This page intentionally left blank", 20.0f, 100.0f);
            return true;
        }
        if (!"ocr".equals(string)) {
            if (MODE_IMAGE_ONLY.equals(string)) {
                if (this.frags_ != null) {
                    int n = this.frags_.length;
                    for (int i = 0; i < n; ++i) {
                        FixedLeafImage fixedLeafImage = this.frags_[i];
                        Rectangle rectangle = fixedLeafImage.getIbbox();
                        graphics2D.drawImage(fixedLeafImage.getImage(), rectangle.x, rectangle.y, context.background, this);
                    }
                }
                return true;
            }
            if ("image".equals(string)) {
                Document document = node.getDocument();
                if (document.getAttr("fixed") == null) {
                    if (this.frags_ != null) {
                        int n = this.frags_.length;
                        for (int i = 0; i < n; ++i) {
                            FixedLeafImage fixedLeafImage = this.frags_[i];
                            Rectangle rectangle = fixedLeafImage.getIbbox();
                            graphics2D.drawImage(fixedLeafImage.getImage(), rectangle.x, rectangle.y, context.background, this);
                        }
                    }
                } else {
                    graphics2D.setColor(Color.RED);
                    smallfont.drawString(graphics2D, "Parts of image not recognized by OCR not shown; use View/Full Image Only to see.", 10.0f, 15.0f);
                }
            }
        }
        return false;
    }
}

