/*
 * Decompiled with CFR 0.152.
 */
package com.pt.lang;

import com.pt.lang.UnicodeBlock;
import java.math.BigInteger;

public class UnicodeBlocks {
    private static final UnicodeBlocks[] UNITARY;
    public static final UnicodeBlocks NONE;
    public static final UnicodeBlocks ALL;
    public static final UnicodeBlocks SYMBOL;
    public static final UnicodeBlocks DINGBATS;
    public static final UnicodeBlocks LATIN;
    public static final UnicodeBlocks MIDDLE_EAST;
    public static final UnicodeBlocks EASTERN_EUROPE;
    public static final UnicodeBlocks SOUTH_ASIA;
    public static final UnicodeBlocks SOUTHEAST_ASIA;
    public static final UnicodeBlocks EAST_ASIA;
    public static final UnicodeBlocks MODERN;
    public static final UnicodeBlocks ARCHAIC;
    public static final UnicodeBlocks SYMBOLS;
    private BigInteger blocks_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UnicodeBlocks(String string) {
        this.blocks_ = new BigInteger(string, 16);
    }

    public UnicodeBlocks(BigInteger bigInteger) {
        this.blocks_ = bigInteger;
    }

    public static UnicodeBlocks getInstance(UnicodeBlock unicodeBlock) {
        return UNITARY[unicodeBlock.getBit()];
    }

    private UnicodeBlocks(String[] stringArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            UnicodeBlock unicodeBlock = UnicodeBlock.getInstance(string);
            if (!$assertionsDisabled && unicodeBlock == null) {
                throw new AssertionError((Object)string);
            }
            if (unicodeBlock == null) continue;
            bigInteger = bigInteger.or(UnicodeBlocks.UNITARY[unicodeBlock.getBit()].blocks_);
        }
        this.blocks_ = bigInteger;
    }

    public UnicodeBlocks or(UnicodeBlocks unicodeBlocks) {
        return unicodeBlocks != null ? new UnicodeBlocks(this.blocks_.or(unicodeBlocks.blocks_)) : this;
    }

    public UnicodeBlocks and(UnicodeBlocks unicodeBlocks) {
        return unicodeBlocks != null ? new UnicodeBlocks(this.blocks_.and(unicodeBlocks.blocks_)) : NONE;
    }

    public int bitCount() {
        return this.blocks_.bitCount();
    }

    public boolean covers(UnicodeBlock unicodeBlock) {
        return unicodeBlock != null && this.blocks_.testBit(unicodeBlock.getBit());
    }

    public UnicodeBlock[] getBlocks() {
        UnicodeBlock[] unicodeBlockArray = new UnicodeBlock[this.blocks_.bitCount()];
        int n = this.blocks_.bitLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.blocks_.testBit(i)) continue;
            unicodeBlockArray[n2++] = UnicodeBlock.ALL[i];
        }
        return unicodeBlockArray;
    }

    public String[] getNames() {
        String[] stringArray = new String[this.blocks_.bitCount()];
        int n = this.blocks_.bitLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.blocks_.testBit(i)) continue;
            stringArray[n2++] = UnicodeBlock.ALL[i].toString();
        }
        return stringArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof UnicodeBlocks)) {
            return false;
        }
        return this.blocks_.equals(((UnicodeBlocks)object).blocks_);
    }

    public String toString() {
        return this.blocks_.toString(16);
    }

    static {
        $assertionsDisabled = !UnicodeBlocks.class.desiredAssertionStatus();
        UnicodeBlock[] unicodeBlockArray = UnicodeBlock.getBlocks();
        int n = unicodeBlockArray.length;
        UNITARY = new UnicodeBlocks[n];
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = 0; i < n; ++i) {
            UnicodeBlock unicodeBlock = unicodeBlockArray[i];
            UnicodeBlocks.UNITARY[i] = new UnicodeBlocks(bigInteger);
            bigInteger = bigInteger.shiftLeft(1);
        }
        NONE = new UnicodeBlocks(BigInteger.ZERO);
        ALL = new UnicodeBlocks(BigInteger.ONE.shiftLeft(UnicodeBlock.COUNT).subtract(BigInteger.ONE));
        SYMBOL = new UnicodeBlocks("Greek and Coptic | Letterlike Symbols | Arrows | Mathematical Operators".split("\\s*\\|\\s*"));
        DINGBATS = new UnicodeBlocks("Enclosed Alphanumerics | Miscellaneous Symbols and Arrows | Dingbats".split("\\s*\\|\\s*"));
        LATIN = new UnicodeBlocks("Basic Latin, Latin 1 Supplement, Latin Extended-A, Latin Extended-B, Latin Extended Additional".split(",\\s*"));
        MIDDLE_EAST = new UnicodeBlocks("Hebrew, Arabic, Arabic Supplement, Syriac, Arabic Presentation Forms-A, Arabic Presentation Forms-B, Syriac, Thaana".split(",\\s*"));
        EASTERN_EUROPE = new UnicodeBlocks("Cyrillic, Cyrillic Supplementary, Georgian".split(",\\s*"));
        SOUTH_ASIA = new UnicodeBlocks("Devanagari, Bengali, Gurmukhi, Gujarati, Oriya, Tamil, Telugu, Kannada, Malayalam, Sinhala, Tibetan, Limbu".split(",\\s*"));
        SOUTHEAST_ASIA = new UnicodeBlocks("Thai, Lao, Myanmar, Tai Le, Khmer, Khmer Symbols, Tagalog, Hanunoo, Buhid, Tagbanwa".split(",\\s*"));
        EAST_ASIA = new UnicodeBlocks("CJK Radicals Supplement, CJK Symbols and Punctuation, Hiragana, Katakana, Enclosed CJK Letters and Months, CJK Compatibility, CJK Unified Ideographs Extension A, CJK Unified Ideographs, CJK Compatibility Ideographs, CJK Compatibility Forms, CJK Unified Ideographs Extension B, CJK Compatibility Ideographs Supplement, Bopomofo, Bopomofo Extended, Hiragana, Katakana, Hangul Jamo, Hangul Compatibility Jamo, Hangul Syllables, Yi Syllables, Yi Radicals".split(",\\s*"));
        MODERN = new UnicodeBlocks("Ethiopic, Ethiopic Extended, Mongolian, Osmanya, Cherokee, Unified Canadian Aboriginal Syllabics, Deseret, Shavian".split(",\\s*"));
        ARCHAIC = new UnicodeBlocks("Ogham, Old Italic, Runic, Gothic, Ugaritic, Linear B Syllabary, Linear B Ideograms, Cypriot Syllabary".split(",\\s*"));
        SYMBOLS = new UnicodeBlocks("Currency Symbols | Letterlike Symbols | Number Forms | Superscripts and Subscripts | Mathematical Operators | Miscellaneous Mathematical Symbols-A | Miscellaneous Mathematical Symbols-B | Arrows | Supplemental Mathematical Operators | Control Pictures | Miscellaneous Technical | Optical Character Recognition | Box Drawing | Block Elements | Geometric Shapes | Miscellaneous Symbols | Dingbats | Yijing Hexagram Symbols | Tai Xuan Jing Symbols | Enclosed Alphanumerics | Enclosed CJK Letters and Months | Braille Patterns | Byzantine Musical Symbols | Musical Symbols".split("\\s*\\|\\s*"));
    }
}

