/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.Cache;
import com.pt.io.CacheFile;
import com.pt.io.CacheMemory;
import com.pt.io.FileSystem;
import com.pt.io.InputStreamTee;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.InputUniFileSystem;
import com.pt.io.InputUniInputStream;
import com.pt.io.InputUniRandomAccess;
import com.pt.io.InputUniString;
import com.pt.io.InputUniURI;
import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessByteArray;
import com.pt.net.HTTP;
import com.pt.net.MIME;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import phelps.io.Files;
import phelps.io.InputStreams;
import phelps.lang.Classes;
import phelps.net.URIs;
import phelps.net.URLs;

public abstract class InputUni {
    public static final InputUni DEVNULL;
    public static final Logger LOGGER;
    static Cache cachedef_;
    private static Map<String, String> scheme_;
    private static final Class[] UNI_SIG;
    URI logical_;
    private Cache cache_;
    private List<String> attrs_ = null;
    private String type_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void registerScheme(String string, String string2) {
        scheme_.put(string.toLowerCase(), string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputUni getInstance(Object object, URI uRI, Cache cache) {
        InputUni inputUni;
        block19: {
            int n;
            URI uRI2;
            block23: {
                block26: {
                    block25: {
                        block24: {
                            block22: {
                                String string;
                                block21: {
                                    if (cache == null) {
                                        cache = Cache.NONE;
                                    }
                                    if (object instanceof URL) {
                                        try {
                                            object = URLs.toURI((URL)object);
                                        }
                                        catch (URISyntaxException uRISyntaxException) {
                                            // empty catch block
                                        }
                                    }
                                    if (object != null) break block21;
                                    inputUni = DEVNULL;
                                    break block19;
                                }
                                if (object instanceof URI && (string = scheme_.get(((URI)object).getScheme())) != null) {
                                    try {
                                        Class<?> clazz = Class.forName(string);
                                        Object obj = clazz.getConstructor(UNI_SIG).newInstance(object, uRI, cache);
                                        inputUni = (InputUni)obj;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        LOGGER.severe(exception.getMessage());
                                        throw new UnsupportedOperationException(exception.getMessage());
                                    }
                                }
                                if (!(object instanceof URI) || !((URI)object).isOpaque()) break block22;
                                inputUni = new InputUniURI((URI)object, cache);
                                break block19;
                            }
                            if (object instanceof URI) break block23;
                            if (!(object instanceof byte[])) break block24;
                            inputUni = new InputUniByteArray((byte[])object, uRI, cache);
                            break block19;
                        }
                        if (!(object instanceof File)) break block25;
                        inputUni = new InputUniFile((File)object, uRI, cache);
                        break block19;
                    }
                    if (!(object instanceof String)) break block26;
                    inputUni = new InputUniString((String)object, null, uRI, cache);
                    break block19;
                }
                if (object instanceof RandomAccess) {
                    inputUni = new InputUniRandomAccess((RandomAccess)object, uRI, cache);
                    break block19;
                } else if (object instanceof InputStream) {
                    inputUni = new InputUniInputStream((InputStream)object, uRI, cache);
                    break block19;
                } else {
                    inputUni = null;
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)(object + " of type " + object.getClass().getName() + " -- unsupported input class type"));
                    }
                }
                break block19;
            }
            inputUni = null;
            uRI = uRI2 = (URI)object;
            String string = uRI2.toString();
            String string2 = uRI2.getScheme();
            String string3 = uRI2.getAuthority();
            String string4 = uRI2.getFragment();
            int n2 = n = string2.length() + (string3 != null ? string3.length() + "//".length() : 0) + 1;
            int n3 = string.length();
            while (n2 != -1) {
                block20: {
                    block27: {
                        String string5 = null;
                        n2 = n;
                        while (!(n2 == -1 || (n2 = string.indexOf(33, n2 + 1)) != -1 && n2 + 1 < n3 && FileSystem.isFileSystem(string5 = string.substring(n, n2)))) {
                        }
                        if (n2 == -1) break block27;
                        URI uRI3 = URI.create(string.substring(0, n2));
                        inputUni = cache.getInputUni(uRI3, null, "general");
                        if (inputUni != null) break block20;
                        if (inputUni == null) {
                            inputUni = "file".equals(string2) ? new InputUniFile(new File(uRI3.getPath()), uRI, cache) : new InputUniURI(uRI3, cache);
                            break block20;
                        } else {
                            try {
                                FileSystem fileSystem = FileSystem.getInstance(inputUni);
                                inputUni = cache.getInputUni(uRI3, null, "general");
                                if (!$assertionsDisabled && inputUni == null) {
                                    throw new AssertionError();
                                }
                                break block20;
                            }
                            catch (Exception exception) {
                                System.err.println("couldn't create FileSystem on " + inputUni + ": " + exception);
                                inputUni = null;
                                break;
                            }
                        }
                    }
                    inputUni = inputUni != null ? new InputUniFileSystem(string.substring(n), inputUni, uRI, cache) : ("file".equals(string2) ? new InputUniFile(new File(uRI2.getPath()), uRI, cache) : new InputUniURI(uRI2, cache));
                }
                n = n2 + 1;
            }
        }
        LOGGER.log(uRI != null ? Level.FINE : Level.FINER, "open " + uRI + " => " + inputUni);
        return inputUni;
    }

    public static InputUni getInstance(Object object, URI uRI) {
        return InputUni.getInstance(object, uRI, cachedef_);
    }

    public static void setCacheDefault(Cache cache) {
        cachedef_ = cache;
    }

    public InputUni(URI uRI, Cache cache) {
        this.logical_ = URIs.canonicalize(uRI);
        Cache cache2 = this.cache_ = cache != null ? cache : Cache.NONE;
        if (this.logical_ != null) {
            this.cache_.setSeen(this.logical_);
        }
    }

    public abstract Object getSource();

    public URI getURI() {
        return this.logical_;
    }

    public Cache getCache() {
        return this.cache_;
    }

    public long length() throws IOException {
        long l = -1L;
        String string = this.getAttr("Content-Length");
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public long lastModified() throws IOException {
        long l = -1L;
        String string = this.getAttr("Last-Modified");
        if (string == null) {
            string = this.getAttr("Date");
        }
        if ("NOW".equals(string)) {
            l = System.currentTimeMillis();
        } else if (string != null) {
            try {
                l = HTTP.parseDate(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return l;
    }

    public String getAttr(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        String string2 = null;
        if (this.attrs_ != null) {
            string = string.toLowerCase();
            int n = this.attrs_.size();
            for (int i = 0; i < n; i += 2) {
                if (!string.equals(this.attrs_.get(i))) continue;
                string2 = this.attrs_.get(i + 1);
                break;
            }
        }
        return string2;
    }

    public void putAttr(String string, String string2) {
        int n;
        if (this.attrs_ == null) {
            this.attrs_ = new ArrayList<String>(4);
        }
        string = string.toLowerCase();
        int n2 = this.attrs_.size();
        for (n = 0; n < n2; n += 2) {
            if (!string.equals(this.attrs_.get(n))) continue;
            this.attrs_.set(n + 1, string2);
            break;
        }
        if (n == n2) {
            this.attrs_.add(string);
            this.attrs_.add(string2);
        }
    }

    public void clearAttrs() {
        this.attrs_ = null;
    }

    public void setContentType(String string) {
        this.type_ = string;
    }

    public String getContentType() {
        int n;
        String string = this.type_;
        if (string == null && (string = this.getAttr("Content-Type")) != null && (n = string.indexOf(59)) != -1) {
            string = string.substring(0, n).trim();
        }
        URI uRI = this.getURI();
        if (string == null && uRI != null && (string = MIME.guessContentType(this.getURI().getPath())) == null) {
            String string2 = uRI.getScheme();
        }
        if (string == null) {
            // empty if block
        }
        LOGGER.finest(this.getURI() + " / " + this.getAttr("Content-Type") + "->" + this.type_ + " => " + string);
        return string;
    }

    public InputStreamTee getInputStream() throws IOException {
        InputStream inputStream = this.getInputStreamRaw();
        return (inputStream = InputStreams.uncompress(inputStream, this.getEncoding())) instanceof InputStreamTee ? (InputStreamTee)inputStream : new InputStreamTee(inputStream, this.length());
    }

    public abstract InputStream getInputStreamRaw() throws IOException;

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public RandomAccess getRandomAccess() throws IOException {
        RandomAccess randomAccess;
        URI uRI = this.getURI();
        Cache cache = this.getCache();
        if ("identity".equals(this.getEncoding())) {
            randomAccess = this.getRandomAccessRaw();
        } else {
            InputUni inputUni = cache.getInputUni(uRI, null, "tmp");
            if (inputUni != null) {
                randomAccess = inputUni.getRandomAccess();
            } else {
                LOGGER.finer(uRI + ": uncompressing RA");
                if (this.length() < 51200L) {
                    randomAccess = new RandomAccessByteArray(this.toByteArray(), "r");
                } else {
                    InputStreams.copy(this.getInputStream(), cache.getOutputStream(uRI, null, "tmp"), true);
                    randomAccess = cache.getInputUni(uRI, null, "tmp").getRandomAccess();
                }
            }
        }
        return randomAccess;
    }

    public abstract RandomAccess getRandomAccessRaw() throws IOException;

    private String getEncoding() {
        String string = this.getAttr("Content-Encoding");
        URI uRI = this.getURI();
        if (string == null && uRI != null) {
            String string2 = uRI.getPath();
            if (!uRI.isOpaque() && string2 != null && string2.length() >= "x.Z".length()) {
                string = Files.getEncoding(string2);
            }
        }
        return string;
    }

    public byte[] toByteArray() throws IOException {
        int n = (int)this.length();
        if (n == -1) {
            n = 8192;
        }
        byte[] byArray = InputStreams.toByteArray(this.getInputStream(), n);
        return byArray;
    }

    public void close() throws IOException {
        if (this.getURI() != null) {
            LOGGER.fine(this.getURI().toString());
        }
    }

    public String toString() {
        return Classes.getTail(this.getClass()) + " " + this.getSource();
    }

    static {
        $assertionsDisabled = !InputUni.class.desiredAssertionStatus();
        DEVNULL = new InputUni(URI.create("devnull:///"), null){

            public Object getSource() {
                return null;
            }

            public long length() {
                return 0L;
            }

            public long lastModified() {
                return 0L;
            }

            public void putAttr(String string, String string2) {
            }

            public InputStream getInputStreamRaw() {
                return InputStreams.DEVNULL;
            }

            public RandomAccess getRandomAccessRaw() {
                return RandomAccess.DEVNULL;
            }
        };
        LOGGER = Logger.getLogger("com.pt.io.InputUni");
        cachedef_ = null;
        File file = new File(new File(System.getProperty("java.io.tmpdir")), "v");
        if (file.canWrite()) {
            try {
                cachedef_ = new CacheFile(file, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (cachedef_ == null) {
            cachedef_ = new CacheMemory();
        }
        scheme_ = new HashMap<String, String>(5);
        UNI_SIG = new Class[]{URI.class, URI.class, Cache.class};
    }
}

