/*
 * Decompiled with CFR 0.152.
 */
package com.pt.doc;

import com.pt.io.FileList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import phelps.lang.Strings;

public class PrettyPrint {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2004/09/20 07:52:15 $";
    private static final String USAGE = "java com.pt.doc.PrettyPrint [options] <Java-source-file...>\n[-prettyprint] [-html]\n[-header <string>] [-lineend unix|dos|native|keep]\n[-nocomments] [-noassert] [-nologging] [-nogenerics]\n[-help] [-version]";
    private static final String HTML_HEADER = "<html>\n<head>\n<style><!--\n pre { font-family:helvetica,monospace; font-size:9pt; }\n .keyword { font-weight:bold; }\n .string { color:blue; }\n .comment { color:green; }\n .javadoc { color:darkgreen }\n-->\n</style>\n</head>\n<body>\n<pre>\n";
    private static final String HTML_FOOTER = "</pre>\n</body>\n</html>\n";
    private static final int TYPE_FILE_END = -1;
    private static final int TYPE_WHITESPACE = 32;
    private static final int TYPE_LINE_END = 10;
    private static final int TYPE_STATEMENT_END = 59;
    private static final int TYPE_BLOCK_START = 123;
    private static final int TYPE_BLOCK_END = 125;
    private static final int TYPE_COMMENT_JAVADOC = 0;
    private static final int TYPE_COMMENT_MULTI = 1;
    private static final int TYPE_COMMENT_SINGLE = 2;
    private static final int TYPE_STRING = 3;
    private static final int TYPE_CHAR = 4;
    private static final int TYPE_NUMBER_REAL = 5;
    private static final int TYPE_NUMBER_INT = 6;
    private static final int TYPE_KEYWORD = 20;
    private static final int TYPE_TEXT = 21;
    private static final int TYPE_OPERATOR = 25;
    private static final String[] KEYWORDS;
    private static final Map<String, String> KEYWORDS_MAP;
    private boolean fprettyprint_ = false;
    private boolean fhtml_ = false;
    private boolean fobsfucate_ = false;
    private boolean fassert_ = true;
    private boolean fgenerics_ = true;
    private boolean flogging_ = true;
    private boolean fcomments_ = true;
    private String eol_ = null;
    private String indent_ = null;
    private String header_ = null;
    private String footer_ = null;
    private PushbackReader r_;
    private String unreadtok_ = null;
    private int type_;
    private int unreadtype_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setPrettyPrint(boolean bl) {
        this.fprettyprint_ = bl;
    }

    public void setHTML(boolean bl) {
        this.fhtml_ = bl;
        if (this.fhtml_) {
            this.setHeader(HTML_HEADER);
            this.setFooter(HTML_FOOTER);
            this.setLineEnd("unix");
            this.setIndent("   ");
        }
    }

    public void setAssert(boolean bl) {
        this.fassert_ = bl;
    }

    public void setGenerics(boolean bl) {
        this.fgenerics_ = bl;
    }

    public void setLogging(boolean bl) {
        this.flogging_ = bl;
    }

    public void setComments(boolean bl) {
        this.fcomments_ = bl;
    }

    public void setHeader(String string) {
        this.header_ = string;
    }

    public void setFooter(String string) {
        this.footer_ = string;
    }

    public void setLineEnd(String string) {
        String string2 = string = string == null ? "" : string.toLowerCase();
        this.eol_ = "unix".equals(string) || string.startsWith("mac") || string.startsWith("osx") ? "\n" : ("dos".equals(string) || string.startsWith("win") ? "\r\n" : ("native".equals(string) ? System.getProperty("line.separator") : null));
    }

    public void setIndent(String string) {
        this.indent_ = "tap".equals(string) ? "tap" : string;
    }

    private void setTAP() {
    }

    public String nextToken() throws IOException {
        String string;
        int n;
        if (this.unreadtok_ != null) {
            String string2 = this.unreadtok_;
            this.unreadtok_ = null;
            this.type_ = this.unreadtype_;
            return string2;
        }
        PushbackReader pushbackReader = this.r_;
        int n2 = pushbackReader.read();
        if (n2 == -1 || n2 == 65535) {
            n = -1;
            string = null;
        } else if (n2 == 13 || n2 == 10) {
            n = 10;
            if (n2 == 10) {
                string = "\n";
            } else {
                n2 = pushbackReader.read();
                if (n2 == 10) {
                    string = "\r\n";
                } else {
                    pushbackReader.unread(n2);
                    string = "\r";
                }
            }
        } else if (n2 == 59) {
            n = 59;
            string = ";";
        } else if (n2 == 123) {
            n = 123;
            string = "{";
        } else if (n2 == 125) {
            n = 125;
            string = "}";
        } else if (n2 == 47) {
            n2 = pushbackReader.read();
            if (n2 == 47) {
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append("//");
                while ((n2 = pushbackReader.read()) != -1 && n2 != 10 && n2 != 13) {
                    stringBuffer.append((char)n2);
                }
                pushbackReader.unread(n2);
                n = 2;
                string = stringBuffer.toString();
            } else if (n2 == 42) {
                n2 = pushbackReader.read();
                n = n2 == 42 ? 0 : 1;
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append("/*").append((char)n2);
                while ((n2 = pushbackReader.read()) != -1 && (n2 != 47 || stringBuffer.charAt(stringBuffer.length() - 1) != '*')) {
                    stringBuffer.append((char)n2);
                }
                stringBuffer.append("/");
                string = stringBuffer.toString();
            } else {
                pushbackReader.unread(n2);
                n = 25;
                string = "/";
            }
        } else if (Character.isWhitespace((char)n2)) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n2);
            while ((n2 = pushbackReader.read()) != -1 && Character.isWhitespace((char)n2)) {
                stringBuffer.append((char)n2);
            }
            pushbackReader.unread(n2);
            n = 32;
            string = stringBuffer.toString();
        } else if (Character.isLetter((char)n2)) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append((char)n2);
            while ((n2 = pushbackReader.read()) != -1 && (Character.isLetter((char)n2) || Character.isDigit((char)n2) || n2 == 95)) {
                stringBuffer.append((char)n2);
            }
            pushbackReader.unread(n2);
            string = stringBuffer.toString();
            n = KEYWORDS_MAP.get(string) != null ? 20 : 21;
        } else if (48 <= n2 && n2 <= 57) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n2);
            while ((n2 = pushbackReader.read()) != -1 && (Character.isDigit((char)n2) || n2 == 46 || n2 == 101 || n2 == 69 || n2 == 120)) {
                stringBuffer.append((char)n2);
            }
            pushbackReader.unread(n2);
            string = stringBuffer.toString();
            n = string.indexOf(46) != -1 ? 5 : 6;
        } else if (n2 == 34) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append((char)n2);
            while ((n2 = pushbackReader.read()) != -1 && n2 != 34) {
                if (n2 == 92) {
                    stringBuffer.append((char)n2);
                    n2 = pushbackReader.read();
                }
                stringBuffer.append((char)n2);
            }
            stringBuffer.append('\"');
            n = 3;
            string = stringBuffer.toString();
        } else if (n2 == 39) {
            StringBuffer stringBuffer = new StringBuffer(5);
            stringBuffer.append((char)n2);
            while ((n2 = pushbackReader.read()) != -1 && n2 != 39) {
                if (n2 == 92) {
                    stringBuffer.append((char)n2);
                    n2 = pushbackReader.read();
                }
                stringBuffer.append((char)n2);
            }
            stringBuffer.append('\'');
            n = 4;
            string = stringBuffer.toString();
        } else {
            n = 25;
            string = Strings.valueOf((char)n2);
        }
        this.type_ = n;
        return string;
    }

    public void unreadToken(String string, int n) {
        this.unreadtok_ = string;
        this.unreadtype_ = n;
    }

    public void rewrite(File file, File file2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        this.rewrite(bufferedReader, bufferedWriter);
        ((Reader)bufferedReader).close();
        ((Writer)bufferedWriter).close();
    }

    public void rewrite(Reader reader, Writer writer) throws IOException {
        String string;
        if (this.header_ != null) {
            writer.write(this.header_);
        }
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        int n2 = 1;
        this.r_ = new PushbackReader(reader, 5);
        StringBuffer stringBuffer = new StringBuffer(80);
        boolean bl3 = false;
        boolean bl4 = true;
        while ((string = this.nextToken()) != null) {
            int n3 = this.type_;
            switch (n3) {
                case 0: {
                    if (this.fobsfucate_) break;
                    if (this.fhtml_) {
                        stringBuffer.append("<span class='javadoc'>").append(this.quote(string)).append("</span>");
                        break;
                    }
                    stringBuffer.append(string);
                    break;
                }
                case 1: {
                    int n4;
                    String string2;
                    if (this.fobsfucate_ || !this.fcomments_) {
                        string2 = this.nextToken();
                        n4 = this.type_;
                        if (32 == n4) break;
                        this.unreadToken(string2, n4);
                        break;
                    }
                    if (this.fhtml_) {
                        stringBuffer.append("<span class='comment'>").append(this.quote(string)).append("</span>");
                        break;
                    }
                    stringBuffer.append(string);
                    break;
                }
                case 2: {
                    if (this.fobsfucate_ || !this.fcomments_) break;
                    if (this.fhtml_) {
                        stringBuffer.append("<span class='comment'>").append(this.quote(string)).append("</span>");
                        break;
                    }
                    stringBuffer.append(string);
                    break;
                }
                case 10: {
                    for (int i = stringBuffer.length() - 1; i >= 0 && Character.isWhitespace(stringBuffer.charAt(i)); --i) {
                        stringBuffer.setLength(i);
                    }
                    if (stringBuffer.length() > 0 || bl3 || bl4) {
                        if (!this.fobsfucate_) {
                            stringBuffer.append(this.eol_ == null ? string : this.eol_);
                            ++n2;
                        }
                        writer.write(stringBuffer.toString());
                    }
                    bl3 = false;
                    stringBuffer = new StringBuffer(80);
                    break;
                }
                case 59: {
                    stringBuffer.append(string);
                    break;
                }
                case 32: {
                    if (this.fobsfucate_) break;
                    String string2 = this.nextToken();
                    int n4 = this.type_;
                    if (10 == n4 || -1 == n4) {
                        if (bl4) {
                            bl3 = true;
                        }
                    } else if (59 != n4) {
                        if (bl4 && this.indent_ != null) {
                            int n5;
                            int n6 = n - (125 == n4 ? 1 : 0);
                            if ("tap" == this.indent_) {
                                if (n > 0) {
                                    stringBuffer.append("  ");
                                }
                                for (n5 = 1; n5 < n6; ++n5) {
                                    stringBuffer.append("\t");
                                }
                            } else {
                                for (n5 = 0; n5 < n6; ++n5) {
                                    stringBuffer.append(this.indent_);
                                }
                            }
                        } else {
                            stringBuffer.append(string);
                        }
                    }
                    this.unreadToken(string2, n4);
                    break;
                }
                case 20: {
                    if (!this.fassert_ && "assert".equals(string)) {
                        while ((string = this.nextToken()) != null && 59 != this.type_) {
                        }
                        break;
                    }
                    if (this.fhtml_) {
                        stringBuffer.append("<span class='keyword'>").append(string).append("</span>");
                        break;
                    }
                    stringBuffer.append(string);
                    break;
                }
                case 21: {
                    stringBuffer.append(string);
                    break;
                }
                case 123: {
                    stringBuffer.append(string);
                    ++n;
                    break;
                }
                case 125: {
                    stringBuffer.append(string);
                    --n;
                    break;
                }
                case 3: {
                    if (this.fhtml_) {
                        stringBuffer.append("<span class='string'>").append(this.quote(string)).append("</span>");
                        break;
                    }
                    stringBuffer.append(string);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 25: {
                    if (this.fhtml_) {
                        stringBuffer.append(this.quote(string));
                        break;
                    }
                    stringBuffer.append(string);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(n3);
                    }
                    break;
                }
            }
            bl4 = 10 == n3;
        }
        if (!bl) {
            writer.write(this.eol_);
        }
        if (this.footer_ != null) {
            writer.write(this.footer_);
        }
        writer.flush();
    }

    private String quote(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('>' == c) {
                stringBuffer.append("&gt;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-pretty")) {
                this.setPrettyPrint(true);
                continue;
            }
            if (string.startsWith("-html")) {
                this.setHTML(true);
                continue;
            }
            if (string.equals("-tap")) {
                this.setTAP();
                continue;
            }
            if (string.startsWith("-noass")) {
                this.setAssert(false);
                continue;
            }
            if (string.startsWith("-nogen")) {
                this.setGenerics(false);
                continue;
            }
            if (string.startsWith("-nolog")) {
                this.setLogging(false);
                continue;
            }
            if (string.startsWith("-nocom")) {
                this.setComments(false);
                continue;
            }
            if (string.startsWith("-head")) {
                this.setHeader(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-foot")) {
                this.setFooter(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-line")) {
                this.setLineEnd(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-indent")) {
                this.setIndent(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        PrettyPrint prettyPrint = new PrettyPrint();
        int n = prettyPrint.commandLine(stringArray);
        if (n == stringArray.length) {
            n = 0;
            stringArray = new String[]{"~/prj/Multivalent/src/com/pt/imageio/plugins/Fax.java"};
        }
        Iterator<File> iterator = new FileList(stringArray, n, null).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            prettyPrint.rewrite(new FileReader(file), new OutputStreamWriter(System.out));
        }
    }

    static {
        $assertionsDisabled = !PrettyPrint.class.desiredAssertionStatus();
        KEYWORDS = new String[]{"package", "import", "class", "interface", "extends", "implements", "instanceof", "public", "private", "protected", "static", "final", "abstract", "native", "strictfp", "synchronized", "transient", "volatile", "void", "boolean", "byte", "short", "char", "int", "long", "float", "double", "true", "false", "null", "new", "super", "this", "throw", "throws", "try", "catch", "finally", "for", "while", "continue", "if", "else", "do", "return", "switch", "case", "default", "break", "assert", "const", "goto"};
        KEYWORDS_MAP = new HashMap<String, String>(KEYWORDS.length * 2);
        String[] stringArray = KEYWORDS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            KEYWORDS_MAP.put(string, string);
        }
    }
}

