/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.NFont;
import com.pt.awt.font.CMap;
import com.pt.awt.font.Encoding;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;

public abstract class NFontSimple
extends NFont {
    protected Encoding encoding_ = Encoding.IDENTITY;
    private static final Rectangle2D BBOX_DEFAULT = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    protected Encoding intrinsic_ = null;
    protected int[] newwidths_ = null;
    protected boolean[] pdfbad_ = null;
    protected int firstch_ = 0;
    protected int lastch_ = 255;
    protected int missingwidth_ = -1;
    protected int newascent_ = 0;
    protected int newdescent_ = 0;
    protected AffineTransform m_;
    protected Rectangle2D bbox_ = BBOX_DEFAULT;

    protected NFontSimple(URL uRL) {
        super(uRL);
    }

    public NFontSimple deriveFont(int[] nArray, int n, int n2, int n3, int n4, Rectangle2D rectangle2D) {
        NFontSimple nFontSimple = (NFontSimple)this.deriveFont(this.size_);
        int n5 = n;
        if (nArray != null) {
            n5 += nArray.length - 1;
            boolean[] blArray = new boolean[nArray.length];
            Encoding encoding = this.getEncoding();
            for (int i = n; i <= n5; ++i) {
                char c = Encoding.WIN_ANSI.getChar(encoding.getName(i));
                if (('\u00c0' > c || c > '\u00ff') && ('\u0091' > c || c > '\u0094')) continue;
                blArray[i - n] = true;
            }
            nFontSimple.pdfbad_ = blArray;
        }
        nFontSimple.newwidths_ = nArray;
        nFontSimple.firstch_ = n;
        nFontSimple.lastch_ = n5;
        nFontSimple.missingwidth_ = n2;
        nFontSimple.newascent_ = n3;
        nFontSimple.newdescent_ = n4;
        if (rectangle2D != null) {
            double d = 0.001 / this.m_.getScaleX();
            double d2 = 0.001 / this.m_.getScaleY();
            nFontSimple.bbox_ = new Rectangle2D.Double(rectangle2D.getX() * d, rectangle2D.getY() * d2, rectangle2D.getWidth() * d, rectangle2D.getHeight() * d2);
        }
        return nFontSimple;
    }

    public NFontSimple deriveFont(Encoding encoding, CMap cMap) {
        NFontSimple nFontSimple = (NFontSimple)this.deriveFont(this.size_);
        if (encoding != null) {
            nFontSimple.encoding_ = encoding;
        }
        nFontSimple.touni_ = cMap != null ? cMap : (nFontSimple.encoding_ != null ? nFontSimple.encoding_.guessToUnicode() : CMap.IDENTITY);
        return nFontSimple;
    }

    public Encoding getEncoding() {
        return this.encoding_;
    }

    public Rectangle2D getMaxCharBounds() {
        double[] dArray = new double[]{this.bbox_.getX() * (double)this.size_, this.bbox_.getY() * (double)this.size_, this.bbox_.getWidth() * (double)this.size_, this.bbox_.getHeight() * (double)this.size_};
        this.m_.deltaTransform(dArray, 0, dArray, 0, 2);
        this.at_.deltaTransform(dArray, 0, dArray, 0, 2);
        if (dArray[3] < 0.0) {
            dArray[1] = -dArray[1];
            dArray[3] = -dArray[3];
        }
        return new Rectangle2D.Double(dArray[0], -dArray[3], dArray[2] - dArray[0], dArray[3] - dArray[1]);
    }
}

