/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.query.CancelCommand;
import edu.ucsb.nceas.morpho.query.ExportCommand;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class ExportDialog
extends JDialog {
    private JButton executeButton = null;
    private JButton cancelButton = null;
    private GUIAction executeAction = new GUIAction("Export", null, null);
    private JRadioButton exportToDir = new JRadioButton("Export to a Directory...");
    private JRadioButton exportToZip = new JRadioButton("Export to a Zip File...");
    private static final int PADDINGWIDTH = 8;
    private static String WARNING = "\nPlease choose the type of export function desired and click the Export button.";
    MorphoFrame morphoFrame = null;
    String morphoFrameType = null;
    OpenDialogBox openDialog = null;
    String selectDocId = null;
    private boolean inLocal = false;
    private boolean inNetwork = false;

    public ExportDialog(MorphoFrame myParent, String frameType, String mySelectedDocId, boolean myInLocal, boolean myInNetwork) {
        super(myParent);
        this.morphoFrame = myParent;
        this.morphoFrameType = frameType;
        this.selectDocId = mySelectedDocId;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
        this.initialize(this.morphoFrame);
    }

    public ExportDialog(OpenDialogBox myParent, MorphoFrame grandParent, String mySelectedDocId, boolean myInLocal, boolean myInNetwork) {
        super(myParent);
        this.openDialog = myParent;
        this.morphoFrame = grandParent;
        this.selectDocId = mySelectedDocId;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
        this.initialize(this.openDialog);
    }

    private void initialize(Window parent) {
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int dialogWidth = 400;
        int dialogHeight = 270;
        this.setSize(dialogWidth, dialogHeight);
        this.setResizable(false);
        double parentX = parent.getLocation().getX();
        double parentY = parent.getLocation().getY();
        double centerX = parentX + 0.5 * (double)parentWidth;
        double centerY = parentY + 0.5 * (double)parentHeight;
        int dialogX = new Double(centerX - 0.5 * (double)dialogWidth).intValue();
        int dialogY = new Double(centerY - 0.5 * (double)dialogHeight).intValue();
        this.setLocation(dialogX, dialogY);
        this.setTitle("Export");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("East", Box.createHorizontalStrut(8));
        this.getContentPane().add("West", Box.createHorizontalStrut(8));
        this.exportToDir.setEnabled(true);
        this.exportToZip.setEnabled(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.exportToDir);
        group.add(this.exportToZip);
        Vector<JRadioButton> enabledRadioButtonList = new Vector<JRadioButton>();
        enabledRadioButtonList.add(this.exportToDir);
        enabledRadioButtonList.add(this.exportToZip);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        Box noteBox = Box.createVerticalBox();
        noteBox.add(Box.createVerticalStrut(8));
        JTextArea note = new JTextArea(WARNING);
        note.setEditable(false);
        note.setLineWrap(true);
        note.setWrapStyleWord(true);
        note.setOpaque(false);
        note.setFont(new Font("SansSerif", 0, 11));
        noteBox.add(note);
        noteBox.add(Box.createVerticalStrut(8));
        mainPanel.add("North", noteBox);
        Box radioBox = Box.createVerticalBox();
        radioBox.add(this.exportToDir);
        radioBox.add(this.exportToZip);
        Box centerBox = Box.createHorizontalBox();
        centerBox.add(Box.createHorizontalGlue());
        centerBox.add(radioBox);
        centerBox.add(Box.createHorizontalGlue());
        mainPanel.add("Center", centerBox);
        this.getContentPane().add("Center", mainPanel);
        Box bottomBox = Box.createVerticalBox();
        this.getContentPane().add("South", bottomBox);
        bottomBox.add(Box.createVerticalStrut(8));
        Box controlButtonsBox = Box.createHorizontalBox();
        controlButtonsBox.add(Box.createHorizontalGlue());
        this.executeAction.setEnabled(false);
        this.executeButton = new JButton(this.executeAction);
        controlButtonsBox.add(this.executeButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        GUIAction cancelAction = new GUIAction("Cancel", null, new CancelCommand(this));
        this.cancelButton = new JButton(cancelAction);
        controlButtonsBox.add(this.cancelButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        bottomBox.add(controlButtonsBox);
        bottomBox.add(Box.createVerticalStrut(10));
        if (enabledRadioButtonList.size() > 0) {
            Object obj = enabledRadioButtonList.elementAt(0);
            JRadioButton selectedRadioButton = (JRadioButton)obj;
            selectedRadioButton.setSelected(true);
            this.enableExecuteButton(selectedRadioButton, this);
        }
        RadioButtonListener listener = new RadioButtonListener(this);
        this.exportToDir.addItemListener(listener);
        this.exportToZip.addItemListener(listener);
        this.setVisible(false);
    }

    private void enableExecuteButton(Object object, JDialog dialog) {
        if (object == this.exportToDir) {
            Log.debug(20, "In export branch");
            this.executeAction.setEnabled(true);
            if (this.openDialog != null) {
                this.executeAction.setCommand(new ExportCommand(this.openDialog, "REGULAR", this));
            } else {
                this.executeAction.setCommand(new ExportCommand(null, "REGULAR", this));
            }
        } else if (object == this.exportToZip) {
            Log.debug(20, "In export to zip branch");
            this.executeAction.setEnabled(true);
            if (this.openDialog != null) {
                this.executeAction.setCommand(new ExportCommand(this.openDialog, "ZIP", this));
            } else {
                this.executeAction.setCommand(new ExportCommand(null, "ZIP", this));
            }
        }
    }

    private class RadioButtonListener
    implements ItemListener {
        private JDialog dialogs = null;

        public RadioButtonListener(JDialog myDialog) {
            this.dialogs = myDialog;
        }

        public void itemStateChanged(ItemEvent event) {
            ItemSelectable obj = event.getItemSelectable();
            ExportDialog.this.enableExecuteButton(obj, this.dialogs);
        }
    }
}

