/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class MethodsPage
extends AbstractUIPage {
    private final String pageID = "METHODS_PAGE";
    private final String nextPageID = "";
    private final String pageNumber = "";
    private final String title = "Methods Page";
    private final String subtitle = "";
    private final String EMPTY_STRING = "";
    private JPanel middlePanel;
    private JLabel titleLabel;
    private JLabel descLabel;
    private JTextArea descField;
    private JLabel instLabel;
    private JTextArea instField;
    private JTextField titleField;
    private String xPathRoot = "/eml:eml/dataset/methods/methodStep/description/section";
    private OrderedMap returnMap = new OrderedMap();

    public MethodsPage() {
        this.init();
    }

    private void init() {
        this.middlePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 1));
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc = WidgetFactory.makeHTMLLabel("<font size=\"4\"><b>Enter Method Step Information:</b></font>", 1);
        this.middlePanel.add(desc);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel titleDesc = WidgetFactory.makeHTMLLabel("<b>Enter title</b> ", 1);
        this.middlePanel.add(titleDesc);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel titlePanel = WidgetFactory.makePanel(1);
        this.titleLabel = WidgetFactory.makeLabel(" Title", false);
        titlePanel.add(this.titleLabel);
        this.titleField = WidgetFactory.makeOneLineTextField();
        titlePanel.add(this.titleField);
        titlePanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.middlePanel.add(titlePanel);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel descTitle = WidgetFactory.makeHTMLLabel("<b>Enter description</b> ", 1);
        this.middlePanel.add(descTitle);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel descPanel = WidgetFactory.makePanel(25);
        this.descLabel = WidgetFactory.makeLabel("Description:", true);
        descPanel.add(this.descLabel);
        this.descField = WidgetFactory.makeTextArea("", 7, true);
        JScrollPane jSampleScrl = new JScrollPane(this.descField);
        descPanel.add(jSampleScrl);
        descPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.middlePanel.add(descPanel);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel instrumentationTitle = WidgetFactory.makeHTMLLabel("<b>Enter Instrumentation Details</b> ", 1);
        this.middlePanel.add(instrumentationTitle);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel instPanel = WidgetFactory.makePanel(25);
        this.instLabel = WidgetFactory.makeLabel("Instrumentation:", false);
        instPanel.add(this.instLabel);
        this.instField = WidgetFactory.makeTextArea("", 7, true);
        JScrollPane jInstruPane = new JScrollPane(this.instField);
        instPanel.add(jInstruPane);
        instPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.middlePanel.add(instPanel);
        this.middlePanel.setBorder(new EmptyBorder(0, 20, 35, 40));
        this.add((Component)this.middlePanel, "Center");
    }

    public boolean onAdvanceAction() {
        String desc = this.descField.getText().trim();
        if (desc.compareTo("") == 0) {
            WidgetFactory.hiliteComponent(this.descLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.descLabel);
        return true;
    }

    public List getSurrogate() {
        ArrayList<String> surrogate = new ArrayList<String>();
        String title = this.titleField.getText().trim();
        if (title == null) {
            title = "";
        }
        surrogate.add(title);
        String desc = this.descField.getText().trim();
        if (desc == null) {
            desc = "";
        }
        surrogate.add(desc);
        String inst = this.instField.getText().trim();
        if (inst == null) {
            inst = "";
        }
        surrogate.add(inst);
        return surrogate;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String xPathRoot) {
        String inst;
        String desc;
        this.returnMap.clear();
        String title = this.titleField.getText().trim();
        if (title != null && !title.equals("")) {
            this.returnMap.put((Object)(xPathRoot + "/description/section/title"), (Object)title);
        }
        if ((desc = this.descField.getText().trim()) != null && !desc.equals("")) {
            StringTokenizer st = new StringTokenizer(desc, "\n");
            int count = 0;
            while (st.hasMoreTokens()) {
                this.returnMap.put((Object)(xPathRoot + "/description/section/para[" + ++count + "]"), (Object)st.nextToken());
            }
        }
        if ((inst = this.instField.getText().trim()) != null && !inst.equals("")) {
            StringTokenizer st = new StringTokenizer(inst, "\n");
            int count = 0;
            while (st.hasMoreTokens()) {
                this.returnMap.put((Object)(xPathRoot + "/instrumentation[" + ++count + "]"), (Object)st.nextToken());
            }
        }
        return this.returnMap;
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Methods Page";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    public boolean setPageData(OrderedMap map, String xPathRoot) {
        Log.debug(45, "MethodsPage.setPageData() called with xPathRoot = " + xPathRoot + "\n Map = \n" + map);
        if (xPathRoot != null && xPathRoot.trim().length() > 0) {
            this.xPathRoot = xPathRoot;
        }
        String xpathRootNoPredicates = XMLUtilities.removeAllPredicates((String)this.xPathRoot);
        while (xpathRootNoPredicates.endsWith("/")) {
            xpathRootNoPredicates = xpathRootNoPredicates.substring(0, xpathRootNoPredicates.length() - 1);
        }
        Log.debug(45, "MethodsPage.setPageData() XMLUtilities.removeAllPredicates(xPathRoot) = " + xpathRootNoPredicates);
        map = this.removeAllButLastPredicatesFromMapKeys(map);
        Log.debug(45, "PartyPage.setPageData() after removeAllButLastPredicatesFromMapKeys. map = \n" + map);
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        while (keyIt.hasNext()) {
            String prevVal;
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug(10, "MethodsPage:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal);
            if (nextXPath.startsWith("/methods/methodStep/description/section/para[")) {
                prevVal = this.descField.getText();
                if (prevVal.compareTo("") != 0) {
                    nextVal = prevVal + "\n\n" + nextVal;
                }
                this.descField.setText(nextVal);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.startsWith("/methods/methodStep/description/section/title[1]")) {
                this.titleField.setText(nextVal);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (!nextXPath.startsWith("/methods/methodStep/instrumentation[")) continue;
            prevVal = this.instField.getText();
            if (prevVal.compareTo("") != 0) {
                nextVal = prevVal + "\n\n" + nextVal;
            }
            this.instField.setText(nextVal);
            toDeleteList.add(nextXPathObj);
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "PartyPage.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal;
    }

    private OrderedMap removeAllButLastPredicatesFromMapKeys(OrderedMap map) {
        OrderedMap newMap = new OrderedMap();
        for (String key : map.keySet()) {
            String val = (String)map.get((Object)key);
            String firstPart = null;
            String lastPart = null;
            int lastOpenBracketIndex = key.lastIndexOf("[");
            if (lastOpenBracketIndex > -1 && lastOpenBracketIndex < key.length()) {
                firstPart = key.substring(0, lastOpenBracketIndex);
                lastPart = key.substring(lastOpenBracketIndex);
            }
            firstPart = XMLUtilities.removeAllPredicates(firstPart);
            newMap.put((Object)(firstPart + lastPart), (Object)val);
        }
        return newMap;
    }
}

