/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.HelpMetadataIntroCommand;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.HyperlinkButton;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Introduction
extends AbstractUIPage {
    public final String pageID = "INTRODUCTION";
    public final String nextPageID = "GENERAL";
    public final String pageNumber = "1";
    private JComponent metadataIntroLink;
    public final String title = "Welcome to the New Data Package Wizard";
    public final String subtitle = " ";

    public Introduction() {
        this.init();
    }

    private void init() {
        this.add(WidgetFactory.makeHalfSpacer());
        JLabel desc1 = WidgetFactory.makeHTMLLabel("<p>This wizard creates a <i>Data Package</i>, consisting of the structured documentation that describes your data (i.e., metadata), and the data themselves. <br></br></p>If you wish to improve your understanding of metadata and related concepts, you should start by reading ", 3);
        JLabel desc2 = WidgetFactory.makeHTMLLabel("which provides background information and examples of metadata. The wizard uses a subset of EML to describe your data. If additional documentation is needed to adequately document your data, use <i>Morpho Editor</i> (after you finish this wizard, choose \"Add/Edit Documentation\" from the \"Documentation\" menu on the main Morpho screen).<br></br></p><p>Before beginning you should have your data (electronic or hardcopy format) available. You can provide the following types of information using this wizard: </p><li><b>Title and abstract</b><br></br></li><li><b>Keywords</b><br></br></li><li><b>People and Organizations</b><br></br></li><li><b>Usage Rights</b><br></br></li><li><b>Research Project Information</b><br></br></li><li><b>Coverage Details</b><br></br></li><li><b>Methods and Sampling</b><br></br></li><li><b>Access Information</b></li></ul><p><b>Note:</b> Required information includes the title and personnel information for your data set.  The rest of the information collected here is optional, however it is highly recommended that you fill in as much as possible.</p>", 19);
        this.setLayout(new BoxLayout(this, 1));
        this.add(desc1);
        this.add(this.getMetadataIntroLink());
        this.add(desc2);
        this.add(Box.createVerticalGlue());
        desc1.setAlignmentX(-1.0f);
        desc2.setAlignmentX(-1.0f);
    }

    private JComponent getMetadataIntroLink() {
        if (this.metadataIntroLink == null) {
            GUIAction newDataTableAction = new GUIAction("An Introduction to Ecological Metadata Language (EML) ", null, new Command(){

                public void execute(ActionEvent ae) {
                    new HelpMetadataIntroCommand().execute(ae);
                }
            });
            this.metadataIntroLink = new HyperlinkButton(newDataTableAction);
            Dimension DIM = new Dimension(400, 15);
            this.metadataIntroLink.setMinimumSize(DIM);
            this.metadataIntroLink.setPreferredSize(DIM);
            this.metadataIntroLink.setMaximumSize(DIM);
        }
        return this.metadataIntroLink;
    }

    public void onLoadAction() {
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public OrderedMap getPageData() {
        return null;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    public String getPageID() {
        return "INTRODUCTION";
    }

    public String getTitle() {
        return "Welcome to the New Data Package Wizard";
    }

    public String getSubtitle() {
        return " ";
    }

    public String getNextPageID() {
        return "GENERAL";
    }

    public String getPageNumber() {
        return "1";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }
}

