/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.utilities.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class General
extends AbstractUIPage {
    private final String pageID = "GENERAL";
    private final String nextPageID = "KEYWORDS";
    private final String title = "Title and Abstract";
    private final String subtitle = "";
    public final String pageNumber = "2";
    private String xPathRoot = "/eml:eml/dataset/";
    private final String TITLE_REL_XPATH = "/title";
    private final String ABSTRACT_REL_XPATH = "/abstract/para[1]";
    private JTextField titleField;
    private JTextArea absField;
    private JLabel titleLabel;
    private OrderedMap returnMap = new OrderedMap();

    public General() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        General vbox = this;
        vbox.add(WidgetFactory.makeHalfSpacer());
        JLabel titleDesc = WidgetFactory.makeHTMLLabel("<b>Enter the title of the data package.</b> The title field provides a description of the data that is long enough to differentiate it from other similar data. e.g. Vernal Pool Amphibian Density Data, Isla Vista, CA USA, 1990-1996", 3);
        vbox.add(titleDesc);
        JPanel titlePanel = WidgetFactory.makePanel(1);
        this.titleLabel = WidgetFactory.makeLabel(" Title:", true);
        titlePanel.add(this.titleLabel);
        this.titleField = WidgetFactory.makeOneLineTextField();
        titlePanel.add(this.titleField);
        titlePanel.setBorder(new EmptyBorder(0, 0, 0, 25));
        vbox.add(titlePanel);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        JLabel absDesc = WidgetFactory.makeHTMLLabel("<b>Enter an abstract that describes the data package.</b> This abstract is a paragraph or more that describes the particular data that are being documented. You may want to describe the objectives, key aspects, design or methods of the study.", 3);
        vbox.add(absDesc);
        JPanel abstractPanel = WidgetFactory.makePanel();
        JLabel absLabel = WidgetFactory.makeLabel(" Abstract:", false);
        absLabel.setVerticalAlignment(1);
        absLabel.setAlignmentY(1.0f);
        abstractPanel.add(absLabel);
        this.absField = WidgetFactory.makeTextArea("", 15, true);
        JScrollPane jscrl = new JScrollPane(this.absField);
        abstractPanel.add(jscrl);
        abstractPanel.setBorder(new EmptyBorder(0, 0, 0, 25));
        vbox.add(abstractPanel);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        vbox.add(WidgetFactory.makeDefaultSpacer());
    }

    public void onLoadAction() {
        WidgetFactory.unhiliteComponent(this.titleLabel);
        if (this.titleField.getText().length() == 0) {
            this.titleField.requestFocus();
        }
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        if (this.titleField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.titleLabel);
            this.titleField.requestFocus();
            return false;
        }
        return true;
    }

    public OrderedMap getPageData() {
        this.returnMap.clear();
        this.returnMap.put((Object)"/eml:eml/dataset/title[1]", (Object)this.titleField.getText().trim());
        this.returnMap.put((Object)"/eml:eml/dataset/abstract/para[1]", (Object)this.absField.getText().trim());
        return this.returnMap;
    }

    public OrderedMap getPageData(String rootXPath) {
        this.returnMap.clear();
        this.returnMap.put((Object)(rootXPath + "/title[1]"), (Object)this.titleField.getText().trim());
        this.returnMap.put((Object)(rootXPath + "/abstract/para[1]"), (Object)this.absField.getText().trim());
        return this.returnMap;
    }

    public String getPageID() {
        return "GENERAL";
    }

    public String getTitle() {
        return "Title and Abstract";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        return "KEYWORDS";
    }

    public String getPageNumber() {
        return "2";
    }

    private void resetBlankData() {
        this.titleField.setText("");
        this.absField.setText("");
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if (map == null || map.isEmpty()) {
            this.resetBlankData();
            return true;
        }
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug((int)45, (String)("General:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal));
            if (nextXPath.startsWith("/title")) {
                this.titleField.setText(nextVal);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (!nextXPath.startsWith("/abstract/para[1]")) continue;
            this.absField.setText(nextVal);
            toDeleteList.add(nextXPathObj);
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug((int)20, (String)("Project.setPageData returning FALSE! Map still contains:" + map));
        }
        return returnVal;
    }
}

