/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.ColumnarTable;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomHeaderRenderer;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomTablePopupListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CustomTable
extends JPanel {
    private ColumnarTable table;
    private JScrollPane scrollPane = null;

    public CustomTable(Vector headerNames, Vector colValues) {
        if (headerNames.size() == 0) {
            return;
        }
        this.table = new ColumnarTable(headerNames, colValues);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(20, 30);
        this.scrollPane.getViewport().removeAll();
        this.scrollPane.getViewport().add(this.table);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.add((Component)this.scrollPane, "Center");
    }

    public void addPopupListener(CustomTablePopupListener l) {
        this.table.addPopupListener(l);
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public List getColumnData(int colIdx) {
        return this.table.getColumnData(colIdx);
    }

    public int[] getSelectedColumns() {
        return this.table.getSelectedColumns();
    }

    public void setSelectedColumns(int[] selectedCols) {
        this.table.setSelectedColumns(selectedCols);
    }

    public Vector getColumnHeaderStrings(int colIdx) {
        return this.table.getColumnHeaderStrings(colIdx);
    }

    public void setColumnHeaderStrings(int colIdx, Vector colHeader) {
        this.table.setColumnHeaderStrings(colIdx, colHeader);
    }

    public void setExtraColumnHeaderInfo(int colIdx, String info) {
        this.table.setExtraColumnHeaderInfo(colIdx, info);
    }

    public int getHeaderHeight() {
        TableColumnModel columnModel = this.table.getColumnModel();
        if (columnModel.getColumnCount() < 1) {
            return 0;
        }
        TableColumn column = columnModel.getColumn(0);
        CustomHeaderRenderer chr = (CustomHeaderRenderer)column.getHeaderRenderer();
        return (int)chr.getTableCellRendererComponent(this.table, "", false, false, 0, 0).getSize().getHeight();
    }
}

