/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class StatusBar
extends JPanel {
    private final String CONN_YES_ICONPATH = "connect_yes.gif";
    private final String CONN_NO_ICONPATH = "connect_no.gif";
    private final String LOGIN_YES_ICONPATH = "login_yes.gif";
    private final String LOGIN_NO_ICONPATH = "login_no.gif";
    private final String SSL_YES_ICONPATH = "ssl_yes.gif";
    private final String SSL_NO_ICONPATH = "ssl_no.gif";
    private final String CONN_YES_TEXT = "network connection is available";
    private final String CONN_NO_TEXT = "network connection NOT available";
    private final String LOGIN_YES_TEXT = "logged into network";
    private final String LOGIN_NO_TEXT = "NOT logged into network";
    private final String SSL_YES_TEXT = "using secure connection";
    private final String SSL_NO_TEXT = "NOT using secure connection";
    private final Color TEXT_COLOR = new Color(102, 102, 153);
    private final Font TEXT_FONT = new Font("Dialog", 0, 12);
    private static final int PADDING = 5;
    private static final int RHS_PADDING = 15;
    private JLabel messageLabel;
    private JLabel connectStatusLabel;
    private JLabel loginStatusLabel;
    private JLabel sslStatusLabel;
    private ImageIcon connect_YesIcon;
    private ImageIcon connect_NoIcon;
    private ImageIcon login_YesIcon;
    private ImageIcon login_NoIcon;
    private ImageIcon ssl_YesIcon;
    private ImageIcon ssl_NoIcon;

    public StatusBar() {
        this.initializeComponents();
        this.buildStatusBar();
    }

    private void initializeComponents() {
        this.connect_YesIcon = new ImageIcon(this.getClass().getResource("connect_yes.gif"));
        this.connect_NoIcon = new ImageIcon(this.getClass().getResource("connect_no.gif"));
        this.login_YesIcon = new ImageIcon(this.getClass().getResource("login_yes.gif"));
        this.login_NoIcon = new ImageIcon(this.getClass().getResource("login_no.gif"));
        this.ssl_YesIcon = new ImageIcon(this.getClass().getResource("ssl_yes.gif"));
        this.ssl_NoIcon = new ImageIcon(this.getClass().getResource("ssl_no.gif"));
        this.messageLabel = new JLabel("");
        this.connectStatusLabel = new JLabel();
        this.loginStatusLabel = new JLabel();
        this.sslStatusLabel = new JLabel();
        this.messageLabel.setForeground(this.TEXT_COLOR);
        this.messageLabel.setFont(this.TEXT_FONT);
        this.setConnectStatus(false);
        this.setLoginStatus(false);
        this.setSSLStatus(false);
    }

    private void buildStatusBar() {
        this.setLayout(new BorderLayout());
        this.add("West", Box.createHorizontalStrut(5));
        this.add("Center", this.messageLabel);
        JPanel iconPanel = new JPanel();
        iconPanel.add(this.connectStatusLabel);
        iconPanel.add(Box.createHorizontalStrut(5));
        iconPanel.add(this.loginStatusLabel);
        iconPanel.add(Box.createHorizontalStrut(5));
        iconPanel.add(this.sslStatusLabel);
        iconPanel.add(Box.createHorizontalStrut(15));
        this.add("East", iconPanel);
        ToolTipManager.sharedInstance().registerComponent(this.connectStatusLabel);
        ToolTipManager.sharedInstance().registerComponent(this.loginStatusLabel);
        ToolTipManager.sharedInstance().registerComponent(this.sslStatusLabel);
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(1000);
    }

    public void setConnectStatus(boolean status) {
        if (status) {
            this.connectStatusLabel.setIcon(this.connect_YesIcon);
            this.connectStatusLabel.setToolTipText("network connection is available");
        } else {
            this.connectStatusLabel.setIcon(this.connect_NoIcon);
            this.connectStatusLabel.setToolTipText("network connection NOT available");
        }
    }

    public void setLoginStatus(boolean status) {
        if (status) {
            this.loginStatusLabel.setIcon(this.login_YesIcon);
            this.loginStatusLabel.setToolTipText("logged into network");
        } else {
            this.loginStatusLabel.setIcon(this.login_NoIcon);
            this.loginStatusLabel.setToolTipText("NOT logged into network");
        }
    }

    public void setSSLStatus(boolean status) {
        if (status) {
            this.sslStatusLabel.setIcon(this.ssl_YesIcon);
            this.sslStatusLabel.setToolTipText("using secure connection");
        } else {
            this.sslStatusLabel.setIcon(this.ssl_NoIcon);
            this.sslStatusLabel.setToolTipText("NOT using secure connection");
        }
    }

    public void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.messageLabel.setText(message);
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }
}

