/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.ObjectFile;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.UIController;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PersistentVector {
    static int objNum = 0;
    public int firstRow = 0;
    int inMemoryNum = 20000;
    Vector objectList = new Vector(this.inMemoryNum + 1);
    ObjectFile obj;
    String objName = "ObjectFile";
    String field_delimiter = "#x09";
    private Vector headerLinesVector;
    private String tmpDir = null;
    private boolean ignoreConsecutiveDelimiters = false;

    public PersistentVector() {
        ++objNum;
        this.getTempDirFromConfig();
        try {
            this.objName = this.tmpDir != null ? this.tmpDir + this.objName + objNum : this.objName + objNum;
            this.obj = new ObjectFile(this.objName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIgnoreConsecutiveDelimiters(boolean flag) {
        this.ignoreConsecutiveDelimiters = flag;
    }

    private void getTempDirFromConfig() {
        Morpho morpho = UIController.getMorpho();
        ConfigXML config = morpho.getConfiguration();
        ConfigXML profile = morpho.getProfile();
        String profileDirName = config.getConfigDirectory() + File.separator + config.get("profile_directory", 0) + File.separator + profile.get("profilename", 0);
        this.tmpDir = profileDirName + File.separator + profile.get("tempdir", 0) + File.separator;
    }

    public void setFirstRow(int frow) {
        this.firstRow = frow;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public Vector getHeaderLinesVector() {
        return this.headerLinesVector;
    }

    public void setHeaderLinesVector(Vector newHeaderLinesVector) {
        this.headerLinesVector = newHeaderLinesVector;
    }

    public void setTmpDir(String directory) {
        this.tmpDir = directory;
    }

    public void init(String filename) {
        File f = new File(filename);
        try {
            BufferedReader in = new BufferedReader(new FileReader(f));
            int nlines = 0;
            long pos = 0L;
            this.headerLinesVector = new Vector();
            try {
                String temp;
                while ((temp = in.readLine()) != null) {
                    if (temp.length() <= 0) continue;
                    if (++nlines > this.firstRow) {
                        String[] tempA = this.getColumnValues(temp);
                        if (nlines > this.inMemoryNum) {
                            pos = this.obj.writeObject((Serializable)tempA);
                            Long lpos = new Long(pos);
                            this.objectList.addElement(lpos);
                            continue;
                        }
                        this.objectList.addElement(tempA);
                        continue;
                    }
                    this.headerLinesVector.addElement(temp);
                }
                in.close();
            }
            catch (Exception e) {}
        }
        catch (Exception w) {
            // empty catch block
        }
    }

    public void init(File f) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(f));
            int nlines = 0;
            long pos = 0L;
            this.headerLinesVector = new Vector();
            try {
                String temp;
                while ((temp = in.readLine()) != null) {
                    if (temp.length() <= 0) continue;
                    if (++nlines > this.firstRow) {
                        String[] tempA = this.getColumnValues(temp);
                        if (nlines > this.inMemoryNum) {
                            pos = this.obj.writeObject((Serializable)tempA);
                            Long lpos = new Long(pos);
                            this.objectList.addElement(lpos);
                            continue;
                        }
                        this.objectList.addElement(tempA);
                        continue;
                    }
                    this.headerLinesVector.addElement(temp);
                }
                in.close();
            }
            catch (Exception e) {}
        }
        catch (Exception w) {
            // empty catch block
        }
    }

    public void init(File f, int fRow) {
        this.firstRow = fRow;
        this.init(f);
    }

    public void initEmpty(String[] ar, int numEmptyRows) {
        try {
            for (int i = 0; i < numEmptyRows; ++i) {
                long pos = this.obj.writeObject((Serializable)ar);
                Long lpos = new Long(pos);
                this.objectList.addElement(lpos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFieldDelimiter(String s) {
        this.field_delimiter = s.trim();
    }

    public String getFieldDelimiter() {
        return this.field_delimiter;
    }

    public void writeObjects(String filename) {
        File f = new File(filename);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            if (this.headerLinesVector != null) {
                for (int jj = 0; jj < this.headerLinesVector.size(); ++jj) {
                    String hline = (String)this.headerLinesVector.elementAt(jj);
                    out.write(hline, 0, hline.length());
                    out.newLine();
                }
            }
            for (int i = 0; i < this.size(); ++i) {
                String[] s = (String[])this.elementAt(i);
                String sss = s[0];
                for (int ii = 1; ii < s.length; ++ii) {
                    sss = sss + this.getDelimiterString() + s[ii];
                }
                out.write(sss, 0, sss.length());
                out.newLine();
            }
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object elementAt(int iii) {
        Object o = this.objectList.elementAt(iii);
        try {
            if (Long.class.isInstance(o)) {
                Long lll = (Long)this.objectList.elementAt(iii);
                o = this.obj.readObject(lll);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    public void addElement(Serializable o) {
        try {
            if (this.objectList.size() > this.inMemoryNum) {
                long pos = this.obj.writeObject(o);
                Long lpos = new Long(pos);
                this.objectList.addElement(lpos);
            } else {
                this.objectList.addElement(o);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setElementAt(Serializable o, int i) {
        try {
            if (i > this.inMemoryNum) {
                long pos = this.obj.writeObject(o);
                Long lpos = new Long(pos);
                this.objectList.setElementAt(lpos, i);
            } else {
                this.objectList.setElementAt(o, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertElementAt(Serializable o, int i) {
        try {
            long pos = this.obj.writeObject(o);
            Long lpos = new Long(pos);
            this.objectList.insertElementAt(lpos, i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeElementAt(int i) {
        this.objectList.removeElementAt(i);
    }

    public int size() {
        if (this.objectList == null) {
            return 0;
        }
        return this.objectList.size();
    }

    public void removeAllElements() {
        this.objectList.removeAllElements();
        this.obj.delete();
        try {
            this.obj = new ObjectFile(this.objName + objNum);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void delete() {
        this.obj.delete();
        this.objectList = null;
    }

    public void setObjectList(Vector newObjectList) {
        this.objectList = newObjectList;
    }

    private String[] getColumnValues(String str) {
        StringTokenizer st;
        str = str + " ";
        String sDelim = this.getDelimiterString();
        String oldToken = "";
        String token = "";
        Vector<String> res = new Vector<String>();
        if (this.ignoreConsecutiveDelimiters) {
            st = new StringTokenizer(str, sDelim, false);
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                res.addElement(token);
            }
        } else {
            st = new StringTokenizer(str, sDelim, true);
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if (!this.inDelimiterList(token, sDelim)) {
                    res.addElement(token);
                } else if (this.inDelimiterList(oldToken, sDelim) && this.inDelimiterList(token, sDelim)) {
                    res.addElement("");
                }
                oldToken = token;
            }
        }
        String[] vals = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            vals[i] = (String)res.elementAt(i);
        }
        return vals;
    }

    private boolean inDelimiterList(String token, String delim) {
        boolean result = false;
        int test = delim.indexOf(token);
        result = test > -1;
        return result;
    }

    private String getDelimiterString() {
        String str = "";
        String temp = this.field_delimiter;
        if (temp.startsWith("#x")) {
            if ((temp = temp.substring(2)).equals("0A")) {
                str = "\n";
            }
            if (temp.equals("09")) {
                str = "\t";
            }
            if (temp.equals("20")) {
                str = " ";
            }
        } else {
            str = temp;
        }
        return str;
    }

    public void setInMemoryNum(int num) {
        this.inMemoryNum = num;
    }

    public int getInMemoryNum() {
        return this.inMemoryNum;
    }

    public static void main(String[] args) {
        PersistentVector pv = new PersistentVector();
        System.out.println("New Persistent Vector created.");
        pv.init("C:/VisualCafe/Projects/PersistentVector/test.txt");
        System.out.println("Object File has been filled!");
        String s = (String)pv.elementAt(0);
        System.out.println(s);
        String s1 = (String)pv.elementAt(100);
        System.out.println(s1);
        pv.insertElementAt((Serializable)((Object)"DFH DFH DFH"), 3);
        pv.writeObjects("C:/VisualCafe/Projects/PersistentVector/test1.txt");
    }
}

