/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.Attribute;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.datapackage.DelimiterField;
import edu.ucsb.nceas.morpho.datapackage.PersistentTableModel;
import edu.ucsb.nceas.morpho.datapackage.PersistentVector;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardListener;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class InsertColumnCommand
implements Command {
    private boolean beforeFlag = true;
    private MorphoFrame morphoFrame = null;
    public static final String AFTER = "after";
    public static final String BEFORE = "before";
    private boolean columnAddFlag = false;
    private boolean openNewWindow = false;
    private JPanel controlPanel;
    private JButton controlOK;
    private JButton controlCancel;
    private JDialog columnDialog;
    private DataViewContainerPanel resultPane;
    private AbstractUIPage attributePage;
    private DataViewer dataView;
    private OrderedMap map = null;
    private String mScale;
    private String columnName;
    private AbstractDataPackage adp = null;
    private int entityIndex = -1;
    private int selectedCol = -1;
    private String xPath = "/attribute";
    private JTable table;
    private PersistentTableModel ptm;
    private PersistentVector pv;
    private Vector columnLabels;
    private String fieldDelimiter;
    private JPanel tablePanel;
    private Document attributeDoc;

    public InsertColumnCommand(String column) {
        if (column.equals(AFTER)) {
            this.beforeFlag = false;
        }
    }

    public void execute(ActionEvent event) {
        this.resultPane = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            this.resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (this.resultPane != null) {
            this.dataView = this.resultPane.getCurrentDataViewer();
            if (this.dataView != null) {
                this.table = this.dataView.getDataTable();
                this.ptm = (PersistentTableModel)this.table.getModel();
                this.pv = this.dataView.getPV();
                Morpho morph = this.dataView.getMorpho();
                this.attributeDoc = this.dataView.getAttributeDoc();
                this.columnLabels = this.dataView.getColumnLabels();
                this.fieldDelimiter = this.pv.getFieldDelimiter();
                this.tablePanel = this.dataView.getTablePanel();
                this.selectedCol = this.table.getSelectedColumn();
                if (this.selectedCol > -1) {
                    this.showAttributeDialog();
                }
            }
        }
    }

    private void insertEml2Column() {
        if (this.selectedCol < 0) {
            Log.debug(10, "Error inserting Column. selected Column is " + this.selectedCol);
            return;
        }
        try {
            if (this.beforeFlag) {
                this.insertNewAttributeAt(this.selectedCol, this.attributeDoc);
            } else {
                this.insertNewAttributeAt(this.selectedCol + 1, this.attributeDoc);
            }
        }
        catch (Exception w) {
            Log.debug(20, "Exception trying to modify attribute DOM");
        }
        if (this.attributePage == null) {
            return;
        }
        String newHeader = this.columnName;
        if (newHeader.trim().length() == 0) {
            newHeader = "New Column";
        }
        String unit = this.getUnit(this.map, this.xPath);
        String sType = (String)this.map.get((Object)(this.xPath + "/storageType"));
        if (sType == null) {
            sType = this.mScale;
        }
        newHeader = "<html><font face=\"Courier\"><center><small>" + sType + "<br>" + unit + "</small><br><b>" + newHeader + "</b></center></font></html>";
        if (this.beforeFlag) {
            this.columnLabels.insertElementAt(newHeader, this.selectedCol);
            this.ptm.insertColumn(this.selectedCol);
        } else {
            this.columnLabels.insertElementAt(newHeader, this.selectedCol + 1);
            this.ptm.insertColumn(this.selectedCol + 1);
        }
        this.pv = this.ptm.getPersistentVector();
        this.dataView.setPV(this.pv);
        this.dataView.setColumnLabels(this.columnLabels);
        this.table.setModel(this.ptm);
        this.setUpDelimiterEditor();
        this.dataView.saveCurrentTable(true);
        if (this.openNewWindow) {
            try {
                ServiceController services = ServiceController.getInstance();
                ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                DataPackageInterface dataPackageInt = (DataPackageInterface)((Object)provider);
                dataPackageInt.openNewDataPackage(this.adp, null);
            }
            catch (ServiceNotHandledException snhe) {
                Log.debug(6, snhe.getMessage());
            }
            UIController controller = UIController.getInstance();
            this.morphoFrame.setVisible(false);
            controller.removeWindow(this.morphoFrame);
            this.morphoFrame.dispose();
        }
    }

    private String getColumnName(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/attributeName"));
        if (o1 == null) {
            return "";
        }
        return (String)o1;
    }

    private String getMeasurementScale(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Nominal";
        }
        boolean b1 = map.containsKey((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Nominal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/textDomain[1]/definition"));
        if (o1 != null) {
            return "Nominal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Ordinal";
        }
        b1 = map.containsKey((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Ordinal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/textDomain[1]/definition"));
        if (o1 != null) {
            return "Ordinal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/standardUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/customUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/standardUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/customUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/datetime/formatString"));
        if (o1 != null) {
            return "Datetime";
        }
        return "";
    }

    private String getUnit(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/measurementScale/interval" + "/unit/standardUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval" + "/unit/customUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio" + "/unit/standardUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio" + "/unit/customUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        return "";
    }

    void insertNewAttributeAt(int index, Document doc) {
        if (this.map == null) {
            Log.debug(15, "Error retrieving OrderedMap while Inserting Column");
            return;
        }
        this.map.put((Object)"/attribute/@id", (Object)UISettings.getUniqueID());
        Attribute attrObject = new Attribute(this.map);
        if (this.adp == null) {
            this.adp = this.dataView.getAbstractDataPackage();
        }
        if (this.entityIndex == -1) {
            this.entityIndex = this.dataView.getEntityIndex();
        }
        this.adp.insertAttribute(this.entityIndex, attrObject, index);
    }

    private void showAttributeDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
        }
        if (dpwPlugin == null) {
            return;
        }
        this.attributePage = dpwPlugin.getPage("ATTRIBUTE_PAGE");
        ModalDialog wpd = new ModalDialog(this.attributePage, UIController.getInstance().getCurrentActiveWindow(), 770, 570, false);
        wpd.setSize(770, 600);
        wpd.setVisible(true);
        this.entityIndex = this.dataView.getEntityIndex();
        this.adp = this.dataView.getAbstractDataPackage();
        if (wpd.USER_RESPONSE == 10) {
            this.map = this.attributePage.getPageData(this.xPath);
            if (this.entityIndex == -1) {
                Log.debug(10, "Unable to get the Index of the current Entity, in EditColumnMetaData.");
                return;
            }
            this.columnName = this.getColumnName(this.map, this.xPath);
            this.mScale = this.getMeasurementScale(this.map, this.xPath);
            boolean toImport = this.isImportNeeded(this.map, this.xPath, this.mScale);
            if (toImport) {
                String entityName = this.adp.getEntityName(this.entityIndex);
                this.adp.addAttributeForImport(entityName, this.columnName, this.mScale, this.map, "/attribute", false);
                DataPackageWizardListener dpwListener = new DataPackageWizardListener(){

                    public void wizardComplete(Node newDOM) {
                        InsertColumnCommand.this.openNewWindow = true;
                        InsertColumnCommand.this.insertEml2Column();
                    }

                    public void wizardCanceled() {
                    }
                };
                dpwPlugin.startCodeDefImportWizard(dpwListener);
            } else {
                this.insertEml2Column();
            }
        }
    }

    private boolean isImportNeeded(OrderedMap map, String xPath, String mScale) {
        if (!(mScale = mScale.toLowerCase()).equals("nominal") && !mScale.equals("ordinal")) {
            return false;
        }
        String path = xPath + "/measurementScale/" + mScale + "/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference";
        boolean present = map.containsKey((Object)path);
        if (!present) {
            return false;
        }
        String o = (String)map.get((Object)path);
        return o == null || o.trim().equals("");
    }

    private void setUpDelimiterEditor() {
        int columns = this.table.getColumnCount();
        final DelimiterField delimiterField = new DelimiterField(this.tablePanel, this.fieldDelimiter, "", columns);
        delimiterField.setHorizontalAlignment(4);
        DefaultCellEditor delimiterEditor = new DefaultCellEditor(delimiterField){

            public Object getCellEditorValue() {
                return new String(delimiterField.getValue());
            }
        };
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int j = 0; j < columns; ++j) {
            columnModel.getColumn(j).setCellEditor(delimiterEditor);
            columnModel.getColumn(j).setPreferredWidth(85);
        }
    }
}

