/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataPackageFactory;
import edu.ucsb.nceas.morpho.datapackage.ReferenceMapping;
import edu.ucsb.nceas.morpho.datapackage.ReferenceSelectionEvent;
import edu.ucsb.nceas.morpho.datapackage.ReferencesHandler;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.QueryRefreshInterface;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.ColumnSortableTableModel;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.SortableJTable;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.w3c.dom.Node;

public class ExternalRefsPage
extends AbstractUIPage {
    private ReferencesHandler referenceHandler;
    private SortableJTable dataPackageTable;
    private JTable referenceIdTable;
    private JList idList;
    private ColumnSortableTableModel resultsModel;
    private ReferenceSelectionEvent event;
    private String refID;
    private Vector refIDTableCloumnName = new Vector();
    private String currentDataPackageID;
    private String selectedDataPackageID;
    private AbstractDataPackage currentDataPackage;
    private AbstractDataPackage selectedDataPackage;
    private Node referencedSubtree;
    private QueryRefreshInterface queryRefreshInterface;
    private String[] columnNames = new String[]{"Title", "Document ID"};
    private final double[] columnWidth = new double[]{0.75, 0.25};
    private static final int DOCIDINDEX = 1;
    private static final String SELECTPACKAGE = "1) Select a data package";
    private static final int TOPGAP = 0;
    private static final int BOTTOMGAP = 8;
    private static final int BIGSIDEGAP = 16;
    private static final int SMALLSIDEGAP = 8;
    private static final int LABELTOOM = 10;
    private static final Font LABELFONT = new Font("Dialog", 1, 10);

    ExternalRefsPage(ReferencesHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
        this.init();
        this.addingMouseListenerForSearchResultTable();
    }

    protected void setReferenceSelectionEvent(ReferenceSelectionEvent event) {
        this.event = event;
    }

    protected ReferenceSelectionEvent getReferenceSelectionEvent() {
        return this.event;
    }

    protected void setCurrentDataPackageID(String currentDataPackageID) {
        this.currentDataPackageID = currentDataPackageID;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel packageListPanel = new JPanel();
        packageListPanel.setBorder(BorderFactory.createEmptyBorder(0, 16, 8, 8));
        packageListPanel.setLayout(new BorderLayout());
        JLabel selectPackageLabel = new JLabel(SELECTPACKAGE);
        selectPackageLabel.setFont(LABELFONT);
        selectPackageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        packageListPanel.add((Component)selectPackageLabel, "North");
        this.dataPackageTable = new SortableJTable();
        JScrollPane scroll = new JScrollPane(this.dataPackageTable);
        Dimension scrollDimension = scroll.getPreferredSize();
        this.doQueryAndPopulateDialog(new Double(scrollDimension.getWidth()).intValue());
        scroll.getViewport().setBackground(Color.white);
        packageListPanel.add((Component)scroll, "Center");
        this.add((Component)packageListPanel, "West");
        JPanel refsPanel = new JPanel();
        String selectRefsString = "2) Select a previous entry from this data package";
        JLabel selectedRefsLabel = new JLabel(selectRefsString);
        selectedRefsLabel.setFont(LABELFONT);
        selectedRefsLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        refsPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 16));
        refsPanel.setLayout(new BorderLayout());
        refsPanel.add((Component)selectedRefsLabel, "North");
        this.referenceIdTable = new JTable(null, this.refIDTableCloumnName);
        JScrollPane scrollPanel = new JScrollPane(this.referenceIdTable);
        scrollPanel.getViewport().setBackground(Color.white);
        refsPanel.add(scrollPanel);
        this.add((Component)refsPanel, "Center");
    }

    public void setDisplayName(String displayName) {
        if (displayName == null) {
            displayName = "";
        }
        this.refIDTableCloumnName.clear();
        this.refIDTableCloumnName.add(displayName);
        this.referenceIdTable.validate();
        this.referenceIdTable.repaint();
    }

    private void addingMouseListenerForSearchResultTable() {
        this.dataPackageTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selectedRow = ExternalRefsPage.this.dataPackageTable.getSelectedRow();
                ExternalRefsPage.this.selectedDataPackageID = (String)ExternalRefsPage.this.dataPackageTable.getModel().getValueAt(selectedRow, 1);
                boolean metacat = false;
                boolean local = true;
                ExternalRefsPage.this.selectedDataPackage = DataPackageFactory.getDataPackage(ExternalRefsPage.this.selectedDataPackageID, metacat, local);
                ExternalRefsPage.this.parsingPackageIntoTable(ExternalRefsPage.this.selectedDataPackage);
            }
        });
    }

    private void parsingPackageIntoTable(AbstractDataPackage selectedPackage) {
        String id = null;
        List content = this.referenceHandler.getReferences(selectedPackage, id);
        Iterator iterator = content.iterator();
        Vector dataVector = new Vector();
        while (iterator.hasNext()) {
            Vector<ReferenceMapping> rowDataVector = new Vector<ReferenceMapping>();
            ReferenceMapping mapping = (ReferenceMapping)iterator.next();
            if (mapping == null) continue;
            rowDataVector.add(mapping);
            dataVector.add(rowDataVector);
        }
        if (!dataVector.isEmpty()) {
            Collections.sort(dataVector, new ReferenceComparator());
        }
        DefaultTableModel referenceIdModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        referenceIdModel.setDataVector(dataVector, this.refIDTableCloumnName);
        this.referenceIdTable.setModel(referenceIdModel);
        this.referenceIdTable.validate();
        this.referenceIdTable.repaint();
    }

    private boolean doQueryAndPopulateDialog(final int width) {
        final QueryRefreshInterface queryPlugin = this.getQueryPlugin();
        if (queryPlugin == null) {
            return false;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ExternalRefsPage.this.resultsModel = queryPlugin.doOwnerQueryForCurrentUser(ExternalRefsPage.this.columnNames, ExternalRefsPage.this.currentDataPackageID);
                return null;
            }

            public void finished() {
                ExternalRefsPage.this.setQueryResults(ExternalRefsPage.this.resultsModel, width);
            }
        };
        worker.start();
        return true;
    }

    private QueryRefreshInterface getQueryPlugin() {
        if (this.queryRefreshInterface == null) {
            try {
                ServiceController sc = ServiceController.getInstance();
                this.queryRefreshInterface = (QueryRefreshInterface)((Object)sc.getServiceProvider(QueryRefreshInterface.class));
            }
            catch (ServiceNotHandledException se) {
                Log.debug(6, se.getMessage());
                se.printStackTrace();
            }
        }
        return this.queryRefreshInterface;
    }

    private void setQueryResults(ColumnSortableTableModel model, int width) {
        this.dataPackageTable.setModel(model);
        this.setTableColumnSize(width, this.columnWidth, this.dataPackageTable);
        this.dataPackageTable.validate();
        this.dataPackageTable.repaint();
    }

    private void setTableColumnSize(int width, double[] lengthRatio, JTable table) {
        TableColumn column = null;
        double minFactor = 0.7;
        int maxFactor = 5;
        double percentage = 0.0;
        int preferredSize = 0;
        int minimumSize = 0;
        int maxmumSize = 0;
        for (int i = 0; i < this.columnNames.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            percentage = lengthRatio[i];
            preferredSize = new Double((double)width * percentage).intValue();
            minimumSize = new Double((double)preferredSize * minFactor).intValue();
            maxmumSize = preferredSize * maxFactor;
            column.setPreferredWidth(preferredSize);
            column.setMinWidth(minimumSize);
            column.setMaxWidth(maxmumSize);
        }
    }

    public String getPageID() {
        throw new UnsupportedOperationException("ExternalRefsPage -> getPageID() method not implemented!");
    }

    public String getTitle() {
        throw new UnsupportedOperationException("ExternalRefsPage -> getTitle() method not implemented!");
    }

    public String getSubtitle() {
        throw new UnsupportedOperationException("ExternalRefsPage -> getSubtitle() method not implemented!");
    }

    public String getNextPageID() {
        throw new UnsupportedOperationException("ExternalRefsPage -> getNextPageID() method not implemented!");
    }

    public String getPageNumber() {
        throw new UnsupportedOperationException("ExternalRefsPage -> getPageNumber() method not implemented!");
    }

    public void onLoadAction() {
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        ReferenceMapping map = null;
        int selectedRowInReferencedTable = this.referenceIdTable.getSelectedRow();
        if (selectedRowInReferencedTable != -1) {
            map = (ReferenceMapping)this.referenceIdTable.getValueAt(selectedRowInReferencedTable, 0);
        }
        if (map != null) {
            this.refID = map.getID();
        }
        if (this.refID == null) {
            return false;
        }
        Log.debug(30, "The external package is " + this.selectedDataPackageID);
        Log.debug(30, "The reference id in external package is " + this.refID);
        this.referencedSubtree = this.selectedDataPackage.getSubtreeAtReference(this.refID);
        this.event.setReferenceID(this.refID);
        this.event.setLocation((short)20);
        this.event.setSubtreeRootNodeName(this.referencedSubtree.getNodeName());
        this.event.setXPathValsMap(XMLUtilities.getDOMTreeAsXPathMap((Node)this.referencedSubtree));
        return true;
    }

    public OrderedMap getPageData() {
        throw new UnsupportedOperationException("ExternalRefsPage -> getPageData() method not implemented!");
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("ExternalRefsPage -> getPageData(rootXPath) method not implemented!");
    }

    public boolean setPageData(OrderedMap data, String rootXPath) {
        throw new UnsupportedOperationException("ExternalRefsPage -> setPageData() method not implemented!");
    }

    class ReferenceComparator
    implements Comparator {
        ReferenceComparator() {
        }

        public int compare(Object object1, Object object2) {
            int results = -1;
            Vector vector1 = (Vector)object1;
            Vector vector2 = (Vector)object2;
            ReferenceMapping mapping1 = (ReferenceMapping)vector1.elementAt(0);
            ReferenceMapping mapping2 = (ReferenceMapping)vector2.elementAt(0);
            String surrogate1 = mapping1.toString();
            String surrogate2 = mapping2.toString();
            return surrogate1.compareToIgnoreCase(surrogate2);
        }
    }
}

