/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddUsageRightsCommand
implements Command {
    private final String DATAPACKAGE_RIGHTS_GENERIC_NAME = "intellectualRights";
    private final String USAGE_SUBTREE_NODENAME = "/intellectualRights/";
    private Node usageRoot;
    private AbstractDataPackage adp;
    private MorphoFrame morphoFrame;
    private DataViewContainerPanel dataViewContainerPanel;
    private AbstractUIPage usagePage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (this.showUsageDialog()) {
            try {
                this.insertUsage();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(20, "Exception trying to modify usage DOM");
            }
        }
    }

    private boolean showUsageDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.usagePage = dpwPlugin.getPage("USAGE_RIGHTS");
        OrderedMap existingValuesMap = null;
        this.usageRoot = this.adp.getSubtree("intellectualRights", 0);
        if (this.usageRoot != null) {
            existingValuesMap = XMLUtilities.getDOMTreeAsXPathMap((Node)this.usageRoot);
        }
        Log.debug(45, "sending previous data to usage page -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.usagePage.setPageData(existingValuesMap, null);
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("intellectualRights", 0);
            return false;
        }
        dialog = new ModalDialog(this.usagePage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertUsage() {
        OrderedMap map = this.usagePage.getPageData("/intellectualRights/");
        Log.debug(45, "\n insertProject() Got usage details from usage page -\n\n" + map.toString());
        if (map == null || map.isEmpty()) {
            Log.debug(5, "Unable to get usage details from input!");
            return;
        }
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        Document doc = impl.createDocument("", "intellectualRights", null);
        this.usageRoot = doc.getDocumentElement();
        try {
            XMLUtilities.getXPathMapAsDOMTree((Map)map, (Node)this.usageRoot);
        }
        catch (TransformerException w) {
            Log.debug(5, "Unable to add usage details to package!");
            Log.debug(20, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, usageRoot) with \n" + "map = " + map + " and usageRoot = " + this.usageRoot);
            w.printStackTrace();
            return;
        }
        this.adp.deleteSubtree("intellectualRights", 0);
        Node check = this.adp.insertSubtree("intellectualRights", this.usageRoot, 0);
        if (check != null) {
            Log.debug(45, "added new usage details to package...");
        } else {
            Log.debug(5, "** ERROR: Unable to add new usage details to package... **");
        }
    }
}

