/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class XMLObjectCache {
    private final HashMap m_map = new HashMap();
    private XMLObjectCache m_parent;

    public XMLObjectCache() {
        this(null);
    }

    public XMLObjectCache(XMLObjectCache parent) {
        this.setParent(parent);
    }

    public final String getName(Object value) {
        String ret = null;
        if (this.m_map.containsValue(value)) {
            Iterator entries = this.m_map.entrySet().iterator();
            while (entries.hasNext() && ret == null) {
                Map.Entry entry = entries.next();
                if (!entry.getValue().equals(value)) continue;
                ret = (String)entry.getKey();
            }
        }
        if (this.m_parent != null && ret == null) {
            ret = this.m_parent.getName(value);
        }
        return ret;
    }

    public final String[] getNames() {
        int size = this.m_map.size();
        boolean parentSize = false;
        String[] parentNames = this.m_parent == null ? new String[]{} : this.m_parent.getNames();
        String[] names = new String[parentNames.length + size];
        int idx = 0;
        Iterator keys = this.m_map.keySet().iterator();
        while (keys.hasNext()) {
            names[idx++] = (String)keys.next();
        }
        for (int i = 0; i < parentNames.length; ++i) {
            names[idx++] = "../" + parentNames[i];
        }
        return names;
    }

    public final void setParent(XMLObjectCache parent) {
        if (parent != null && this.m_map.size() > 0) {
            String key;
            Vector<String> moves = new Vector<String>();
            Iterator<Object> iter = this.m_map.keySet().iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                if (!key.startsWith("../")) continue;
                moves.add(key);
            }
            iter = moves.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                Object value = this.m_map.remove(key);
                key = key.substring(3);
                parent.put(key, value);
            }
        }
        this.m_parent = parent;
    }

    public final XMLObjectCache getParent() {
        return this.m_parent;
    }

    public final void clear() {
        this.m_map.clear();
    }

    public final void put(String name, Object value) {
        if (this.m_parent != null && name.startsWith("../")) {
            this.m_parent.put(name.substring(3), value);
            return;
        }
        if (name.startsWith("./")) {
            this.m_map.put(name.substring(2), value);
        } else {
            this.m_map.put(name, value);
        }
    }

    public final void remove(String name) {
        if (this.m_parent != null && name.startsWith("../")) {
            this.m_parent.remove(name.substring(3));
        }
        if (name.startsWith("./")) {
            this.m_map.remove(name.substring(2));
        } else {
            this.m_map.remove(name);
        }
    }

    public Object get(String name) {
        Object object;
        if (name != null && this.m_parent != null && name.startsWith("../")) {
            return this.m_parent.get(name.substring(3));
        }
        boolean searchParent = true;
        if (name != null && name.startsWith("./")) {
            object = this.m_map.get(name.substring(2));
            searchParent = false;
        } else {
            object = this.m_map.get(name);
        }
        if (object != null || !searchParent) {
            return object;
        }
        if (this.m_parent != null) {
            return this.m_parent.get(name);
        }
        return null;
    }
}

