/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.dev;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.record.Record;

public class SlideShowRecordDumper {
    private HSLFSlideShow doc;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Useage: SlideShowRecordDumper <filename>");
            return;
        }
        String filename = args[0];
        SlideShowRecordDumper foo = new SlideShowRecordDumper(filename);
        foo.printDump();
        foo.close();
    }

    public SlideShowRecordDumper(String fileName) throws IOException {
        this.doc = new HSLFSlideShow(fileName);
    }

    public void close() throws IOException {
        if (this.doc != null) {
            this.doc.close();
        }
        this.doc = null;
    }

    public void printDump() throws IOException {
        this.walkTree(0, 0, this.doc.getRecords());
    }

    public String makeHex(int number, int padding) {
        String hex = Integer.toHexString(number).toUpperCase();
        while (hex.length() < padding) {
            hex = "0" + hex;
        }
        return hex;
    }

    public String reverseHex(String s) {
        StringBuffer ret = new StringBuffer();
        if (s.length() / 2 * 2 != s.length()) {
            s = "0" + s;
        }
        char[] c = s.toCharArray();
        for (int i = c.length; i > 0; i -= 2) {
            ret.append(c[i - 2]);
            ret.append(c[i - 1]);
            if (i == 2) continue;
            ret.append(' ');
        }
        return ret.toString();
    }

    public int getDiskLen(Record r) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        r.writeOut(baos);
        byte[] b = baos.toByteArray();
        return b.length;
    }

    public void walkTree(int depth, int pos, Record[] records) throws IOException {
        int i;
        int indent = depth;
        String ind = "";
        for (i = 0; i < indent; ++i) {
            ind = ind + " ";
        }
        for (i = 0; i < records.length; ++i) {
            Record r = records[i];
            int len = this.getDiskLen(r);
            String hexType = this.makeHex((int)r.getRecordType(), 4);
            String rHexType = this.reverseHex(hexType);
            Class<?> c = r.getClass();
            String cname = c.toString();
            if (cname.startsWith("class ")) {
                cname = cname.substring(6);
            }
            if (cname.startsWith("org.apache.poi.hslf.record.")) {
                cname = cname.substring(27);
            }
            System.out.println(ind + "At position " + pos + " (" + this.makeHex(pos, 6) + "):");
            System.out.println(ind + " Record is of type " + cname);
            System.out.println(ind + " Type is " + r.getRecordType() + " (" + hexType + " -> " + rHexType + " )");
            System.out.println(ind + " Len is " + (len - 8) + " (" + this.makeHex(len - 8, 8) + "), on disk len is " + len);
            System.out.println();
            if (r.getChildRecords() != null) {
                this.walkTree(depth + 3, pos + 8, r.getChildRecords());
            }
            pos += len;
        }
    }
}

