/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LZW4HDGF {
    public byte fromInt(int b) {
        if (b < 128) {
            return (byte)b;
        }
        return (byte)(b - 256);
    }

    public byte[] decode(InputStream src) throws IOException {
        int flag;
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        int pos = 0;
        byte[] buffer = new byte[4096];
        buffer[0] = 0;
        block0: while ((flag = src.read()) != -1) {
            for (int mask = 1; mask < 256; mask <<= 1) {
                int tmp;
                if ((flag & mask) > 0) {
                    tmp = src.read();
                    if (tmp == -1) continue;
                    buffer[pos & 0xFFF] = this.fromInt(tmp);
                    ++pos;
                    res.write(new byte[]{this.fromInt(tmp)});
                    continue;
                }
                tmp = src.read();
                if (tmp == -1) continue block0;
                int addr1 = tmp;
                tmp = src.read();
                if (tmp == -1) continue block0;
                int addr2 = tmp;
                int len = (addr2 & 0xF) + 3;
                int pntr = (addr2 & 0xF0) * 16 + addr1;
                pntr = pntr > 4078 ? (pntr -= 4078) : (pntr += 18);
                for (int i = 0; i < len; ++i) {
                    buffer[pos + i & 0xFFF] = buffer[pntr + i & 0xFFF];
                    byte data = buffer[pntr + i & 0xFFF];
                    res.write(new byte[]{data});
                }
                pos += len;
            }
        }
        return res.toByteArray();
    }
}

