/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.CHashMap;
import multivalent.ContextListener;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.gui.VMenu;
import multivalent.gui.VSeparator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentPopup
extends Behavior {
    public static final String MSG_CREATE = "createDocPopup";
    public static final String MSG_CREATE_DOCPOPUP = "createWidget/DOCPOPUP";
    public static final String ATTR_CATEGORIES = "categories";
    String[] popcats_ = null;

    @Override
    public void buildAfter(Document document) {
        document.getRoot().addObserver(this);
    }

    @Override
    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        if (aWTEvent.getID() != 501) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if ((mouseEvent.getModifiers() & 4) == 0) {
            return false;
        }
        CHashMap<Object> cHashMap = new CHashMap<Object>();
        Browser browser = this.getBrowser();
        Node node2 = browser.getCurNode();
        Span span = browser.getSelectionSpan();
        Cloneable cloneable = null;
        if (node2 != null && node2.isLeaf()) {
            cHashMap.put("node", (Object)node2);
            List<ContextListener> list = node2.getActivesAt(browser.getCurOffset());
            ArrayList<Behavior> arrayList = new ArrayList<Behavior>(list.size());
            if (list.size() > 0) {
                cHashMap.put("actives", (Object)list);
            }
            Object object = null;
            for (ContextListener contextListener : list) {
                if (!(contextListener instanceof Behavior)) continue;
                Behavior behavior = (Behavior)((Object)contextListener);
                arrayList.add(behavior);
                if (behavior == span) {
                    object = span;
                    break;
                }
                if (!behavior.isEditable()) continue;
                object = behavior;
            }
            Node node3 = cloneable = object != null ? object : arrayList;
        }
        if (cloneable == null) {
            cloneable = node2;
        }
        browser.eventq(new SemanticEvent(browser, MSG_CREATE, cHashMap, cloneable, null));
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_CREATE == string) {
            Object object;
            VMenu vMenu = new VMenu("docpopup", null, null);
            int n = this.popcats_.length;
            for (int i = 0; i < n; ++i) {
                new VSeparator(new StringBuffer().append("_").append(this.popcats_[i]).toString(), null, vMenu);
            }
            Browser browser = this.getBrowser();
            Object object2 = semanticEvent.getArg();
            Object object3 = semanticEvent.getIn();
            if (object3 != null) {
                if (object3 instanceof List) {
                    Behavior behavior;
                    object = (List)object3;
                    int n2 = object.size();
                    for (int i = 0; i < n2 && !browser.event(new SemanticEvent(browser, MSG_CREATE_DOCPOPUP, object2, behavior = (Behavior)object.get(i), vMenu)); ++i) {
                    }
                } else {
                    browser.event(new SemanticEvent(browser, MSG_CREATE_DOCPOPUP, object2, object3, vMenu));
                }
            }
            if (vMenu.size() == this.popcats_.length) {
                browser.event(new SemanticEvent(browser, MSG_CREATE_DOCPOPUP, object2, null, vMenu));
            }
            object = browser.getCurScrn();
            if (vMenu.size() > this.popcats_.length) {
                vMenu.post(((Point)object).x + 1, ((Point)object).y, browser);
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.popcats_ = this.getAttr(ATTR_CATEGORIES, "specific, navigate, view, create, save, edit").toLowerCase().split("\\s*,\\s*");
    }
}

