/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.awt.Color;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.SemanticEvent;
import multivalent.Span;
import phelps.awt.Colors;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundSpan
extends Span {
    public static final String MSG_CHANGE = "changeColor";
    public static final String MSG_EDIT = "editColor";
    public static final String ATTR_COLORS = "colors";
    public static final String ATTR_COLOR = "color";
    static String[] choices_ = null;
    static String oldchoices_ = null;
    static Color defaultColor_ = Color.YELLOW;
    Color color_ = defaultColor_;

    public void setColor(Color color) {
        this.color_ = color;
    }

    public Color getColor() {
        return this.color_;
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        if (this.color_ != Context.COLOR_INVALID) {
            context.background = this.color_;
        }
        return false;
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (this != semanticEvent.getIn()) {
            return false;
        }
        if ("createWidget/DOCPOPUP" == string && this.isEditable()) {
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            String string2 = this.getPreference(ATTR_COLORS, "Yellow Orange Green Blue");
            if (!string2.equals(oldchoices_)) {
                choices_ = string2.split("\\s+");
                oldchoices_ = string2;
            }
            for (String string3 : choices_) {
                this.createUI("button", string3, new SemanticEvent(browser, MSG_CHANGE, string3, this, null), iNode, "EDIT", false);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (this == semanticEvent.getIn()) {
            if (MSG_CHANGE == string) {
                Object object = semanticEvent.getArg();
                Color color = null;
                if (object != null) {
                    if (object instanceof Color) {
                        color = (Color)object;
                    } else if (object instanceof String) {
                        color = Colors.getColor((String)object);
                    }
                }
                if (color != null) {
                    defaultColor_ = this.color_ = color;
                    this.repaint();
                }
            } else if (MSG_EDIT == string) {
                // empty if block
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public ESISNode save() {
        if (this.color_ == null) {
            this.removeAttr(ATTR_COLOR);
        } else {
            this.putAttr(ATTR_COLOR, Colors.getName(this.color_));
        }
        return super.save();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.color_ = Colors.getColor(this.getAttr(ATTR_COLOR), defaultColor_);
    }

    @Override
    public String toString() {
        return new StringBuffer().append("background=").append(this.color_).toString();
    }
}

