/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import com.pt.io.InputUniString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.MediaAdaptor;
import multivalent.SemanticEvent;
import multivalent.node.LeafUnicode;
import phelps.io.Files;
import phelps.lang.Booleans;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualPageVolume
extends Behavior {
    static final boolean DEBUG = true;
    public static final String MSG_EXISTS = "manualpageExists";
    public static final String MSG_SECTION_VALID = "manualpageValidSection";
    public static final String MSG_DATABASE = "rebuildManPageDatabase";
    public static final String MSG_KILLCATS = "manpageKillCats";
    public static final String PROTOCOL = "manualpagevolume";
    public static final String PREF_DIR = "ManPage/SeeDirectories";
    public static final String PREF_RECENT = "ManPage/SeeRecent";
    public static final String ENV_MANPATH = "MANPATH";
    public static final String PREF_VOLUMES = "MANVOLUMES";
    public static final String PREF_VOLNAMES = "MANVOLNAMES";
    static final String PATH_CONFIG = "systemresource:/multivalent/std/adaptor/ManualPage-config.html";
    static final String ALLVOL = "ALL";
    static final String VOLLETTERS = "1:2:3:4:5:6:7:8:l:o:n:p:pod";
    static final String VOLNAMES = "User Commands:System Calls:Subroutines:Devices:File Formats:Games:Miscellaneous:System Administration:Local:Old:New:Public:Perl";
    static String[] volletters_ = null;
    static String[] volnames_ = null;
    static String warnings_ = "";
    static int mancnt_ = 0;
    static String errhtml = null;
    static String[] validpaths_ = null;
    static String[] manpath_ = null;
    static String[] recent_ = null;
    private static boolean damncats_ = false;
    private static boolean fdb_ = false;
    static Map<String, Object> Name2dirs_ = null;
    static Map<String, String[]> Vol2names_ = null;
    static List<String> Dotsdot_ = null;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("ManualPageVolume".equals(this.getBrowser().getCurDocument().getAttr("genre"))) {
            INode iNode = (INode)semanticEvent.getOut();
            if ("createWidget/Edit" == string) {
                this.createUI("button", "Configure Man Pages", "event openDocument systemresource:/multivalent/std/adaptor/ManualPage-config.html", iNode, "configure", false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        Browser browser = this.getBrowser();
        if (MSG_DATABASE == string) {
            this.buildDatabase();
        } else if (MSG_SECTION_VALID == string) {
            if (object instanceof String) {
                char c = ((String)object).charAt(0);
                boolean bl = false;
                int n = volletters_.length;
                for (int i = 0; i < n; ++i) {
                    if (c != volletters_[i].charAt(0)) continue;
                    bl = true;
                    break;
                }
                semanticEvent.setArg(bl ? Boolean.TRUE : Boolean.FALSE);
            }
        } else if (MSG_EXISTS == string) {
            if (!fdb_) {
                this.buildDatabase();
            }
            if (object instanceof String) {
                String string2 = (String)object;
                int n = string2.indexOf(40);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((n = string2.indexOf(46)) != -1) {
                    string2 = string2.substring(0, n);
                }
                semanticEvent.setArg(Name2dirs_.get(string2) != null ? Boolean.TRUE : Boolean.FALSE);
            }
        } else if (MSG_KILLCATS == string) {
            boolean bl = true;
            int n = manpath_.length;
            for (int i = 0; i < n; ++i) {
                File file = new File(manpath_[i]);
                for (String string3 : file.list()) {
                    if (!string3.startsWith("cat") || string3.length() < 4) continue;
                    System.out.println(new StringBuffer().append("would rm -rf ").append(manpath_[i]).append("/").append(string3).toString());
                }
            }
            if (bl) {
                damncats_ = false;
            }
            browser.eventq("reloadDocument", null);
        } else if ("openDocument" == string && object instanceof DocInfo) {
            DocInfo docInfo = (DocInfo)object;
            URI uRI = docInfo.uri;
            String string4 = uRI.getScheme();
            String string5 = uRI.getSchemeSpecificPart();
            if (string4 != null && string4.startsWith("man")) {
                if (!fdb_) {
                    this.buildDatabase();
                }
                String string6 = null;
                string6 = errhtml != null ? errhtml : (PROTOCOL.equals(string4) || "manpagevol".equals(string4) ? this.showVolume(string5) : this.showPage(string5));
                Document document = docInfo.doc;
                docInfo.returncode = 200;
                document.removeAllChildren();
                Layer layer = document.getLayer("base");
                if (string6.indexOf(60) == -1) {
                    new LeafUnicode(string6, null, document);
                } else {
                    browser.event(new SemanticEvent(this, "buildDocument", docInfo));
                    MediaAdaptor mediaAdaptor = (MediaAdaptor)Behavior.getInstance("helper", "HTML", null, layer);
                    try {
                        mediaAdaptor.setInput(new InputUniString(string6, null, uRI, null));
                        mediaAdaptor.parse(document);
                        document.putAttr("genre", "ManualPageVolume");
                    }
                    catch (Exception exception) {
                        new LeafUnicode(new StringBuffer().append("ERROR ").append(exception).toString(), null, document);
                        exception.printStackTrace();
                    }
                    finally {
                        try {
                            mediaAdaptor.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return false;
    }

    public String showVolume(String string) {
        Object object;
        int n;
        boolean bl = ALLVOL.equals(string);
        StringBuffer stringBuffer = new StringBuffer((bl ? 10 : 2) * 1000);
        stringBuffer.append("<html><head>\n");
        stringBuffer.append("<title>man page vol ").append(string).append("</title>\n");
        stringBuffer.append("</head><body>");
        int n2 = stringBuffer.length();
        stringBuffer.append("<button script='event rebuildManPageDatabase; event reloadDocument'>Refresh database</button>");
        int n3 = 0;
        boolean bl2 = true;
        int n4 = volletters_.length;
        for (n = 0; n < n4; ++n) {
            String string2 = volletters_[n];
            if (!bl && !string2.equals(string) || (object = Vol2names_.get(string2)) == null) continue;
            n3 += ((String[])object).length;
            if (bl) {
                stringBuffer.append("<span behavior='OutlineSpan'>");
            }
            stringBuffer.append("\n<h2>");
            stringBuffer.append("<a name='volume").append(string2).append("'>(").append(string2).append(") ").append(volnames_[n]).append("</a>");
            if (bl) {
                stringBuffer.append("  <font size=2><i>").append(((String[])object).length).append(bl2 ? " pages" : "").append("</i></font>");
            }
            stringBuffer.append("</h2>\n");
            stringBuffer.append("<span behavior='ScriptSpan' title='See man page' script='event openDocument manpage:$node(").append(string2).append(")'>\n");
            char c = '\uffff';
            int n5 = ((Object)object).length;
            for (int i = 0; i < n5; ++i) {
                Object object2 = object[i];
                char c2 = Character.toLowerCase(((String)object2).charAt(0));
                if (c2 != c) {
                    stringBuffer.append("</p>\n<p>");
                    c = c2;
                } else {
                    stringBuffer.append(" &nbsp; ");
                }
                stringBuffer.append((String)object2);
            }
            stringBuffer.append("</p>\n</span>\n");
            if (bl) {
                stringBuffer.append("</span>\n");
            }
            bl2 = false;
        }
        if (mancnt_ == 0) {
            stringBuffer.append("<p>No pages found in MANPATH environment variable -- <a href='systemresource:/multivalent/std/adaptor/ManualPage-config.html'>reset MANPATH</a>.");
        } else if (n3 == 0) {
            stringBuffer.append("<p>No manual pages in volume <b>").append(string).append("</b>.");
        } else {
            stringBuffer.insert(n2, new StringBuffer().append(n3).append(" manual pages").append(bl ? "" : " in section").append(".").toString());
        }
        if (Booleans.parseBoolean(this.getPreference(PREF_DIR, "true"), true) && bl && validpaths_.length > 0) {
            stringBuffer.append("<h2>Directories</h2>");
            stringBuffer.append("[<a href='systemresource:/multivalent/std/adaptor/ManualPage-config.html'>configure</a>]&nbsp;&nbsp;&nbsp;");
            for (String string2 : validpaths_) {
                object = new File(string2);
                stringBuffer.append("<a href='").append(((File)object).toURI()).append("'>").append(string2).append("</a>, ");
                System.out.println(string2);
            }
        }
        if (Booleans.parseBoolean(this.getPreference(PREF_RECENT, "true"), true) && bl && recent_ != null && recent_.length > 0) {
            stringBuffer.append("<h2>Recent</h2>");
            stringBuffer.append("<span behavior='ScriptSpan' title='See man page' script='event openDocument manpage:$node'>\n");
            n4 = recent_.length;
            for (n = 0; n < n4; ++n) {
                stringBuffer.append(recent_[n]).append("\t");
            }
            stringBuffer.append("</span>\n");
        }
        if (warnings_.length() > 0) {
            stringBuffer.append("<p><h2>Warnings</h2>\n");
            StringTokenizer stringTokenizer = new StringTokenizer(warnings_, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken()).append("<br>\n");
            }
        }
        if (damncats_) {
            stringBuffer.append("<h2>Obsolete Cat Pages</h2>");
            stringBuffer.append("<p>The Multivalent browser reads man pages from roff source, rendering the quasi-ASCII cached formatted versions in 'cat' directories obsolete. ");
            stringBuffer.append("You can clean up your disk by deleting cat pages, and do so safely as other man page readers will generate a cat version as needed.");
            stringBuffer.append("<form method='event' action='manpageKillCats'><input type='submit' value='Delete Cats'></form>");
        }
        stringBuffer.append("\n</body></html>");
        return stringBuffer.toString();
    }

    public String showPage(String string) {
        Object object;
        Object object2;
        Iterator iterator;
        Serializable serializable;
        Object object3;
        String string2 = null;
        String string3 = string;
        int n = string.indexOf(40);
        if (n != -1) {
            int n2 = string.indexOf(41);
            if (n2 == -1) {
                n2 = string.length();
            }
            string2 = string.substring(n + 1, n2);
            string3 = string.substring(0, n);
        } else {
            n = string.lastIndexOf(46);
            if (n != -1) {
                string3 = string.substring(0, n);
            }
        }
        Object object4 = Name2dirs_.get(string3);
        if (object4 instanceof List && string2 != null) {
            object3 = (List)object4;
            serializable = new ArrayList(object3.size());
            System.out.println(new StringBuffer().append("trying to winnow down from ").append(object3).append(", based on |").append(string2).append("|").toString());
            if (string2.length() > 1) {
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    if (!((String)object2).endsWith(string2)) continue;
                    serializable.add(object2);
                }
            }
            if (serializable.size() == 0) {
                char c = string2.charAt(0);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (((String)object).charAt(((String)object).lastIndexOf(47) + 4) != c) continue;
                    serializable.add(object);
                }
            }
            if (serializable.size() == 1) {
                object4 = serializable.get(0);
            } else if (serializable.size() > 1) {
                object4 = serializable;
            }
        }
        if (object4 == null) {
            return new StringBuffer().append("<p>Manual page <b>").append(string).append("</b> not found.").toString();
        }
        if (object4 instanceof String) {
            try {
                object3 = this.getBrowser();
                ((Browser)object3).eventq("openDocument", this.findInDir((String)object4, string3).toURL().toString());
                ((Browser)object3).eventq("redirectedDocument", null);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return "Redirecting";
        }
        object3 = (List)object4;
        serializable = new StringBuffer(200 + object3.size() * 100);
        ((StringBuffer)serializable).append("<p>").append(object3.size()).append(" matches of ").append(string).append("<ul>");
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = this.findInDir((String)object2, string3);
            ((StringBuffer)serializable).append("<li><a href='").append(((File)object).toURI()).append("'>").append(((File)object).getPath()).append("</a>");
        }
        ((StringBuffer)serializable).append("</ul>");
        return ((StringBuffer)serializable).toString();
    }

    File findInDir(String string, String string2) {
        File file = new File(string.replace('/', File.separatorChar));
        String string3 = string.substring(string.lastIndexOf(47) + 4);
        String string4 = new StringBuffer().append(string2).append(".").append(string3).toString();
        File file2 = new File(file, string4);
        if (file2.exists()) {
            return file2;
        }
        try {
            file2 = Files.getFuzzyFile(file, string4);
            if (file2.exists()) {
                return file2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        file2 = new File(file, new StringBuffer().append(string2).append(".man").toString());
        if (file2.exists()) {
            return file2;
        }
        System.out.println(new StringBuffer().append("have to search for ").append(string4).toString());
        String[] stringArray = file.list();
        String string5 = new StringBuffer().append(string2).append(".").toString();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith(string5) || Files.isBackup(stringArray[i])) continue;
            return new File(stringArray[i]);
        }
        return new File(file, string4);
    }

    public void configure() {
        errhtml = null;
        Name2dirs_ = null;
        volletters_ = this.getPreference(PREF_VOLUMES, VOLLETTERS).split(":");
        if (volletters_.length != (volnames_ = this.getPreference(PREF_VOLNAMES, VOLNAMES).split(":")).length) {
            errhtml = new StringBuffer().append(errhtml).append("<p>Man page volume letters not same length as volume names (").append(volletters_.length).append(" vs ").append(volnames_.length).append(").\n").append("Fix in ").append(PREF_VOLUMES).append(" and ").append(PREF_VOLNAMES).append(" in Preferences.").toString();
            return;
        }
        fdb_ = false;
    }

    /*
     * WARNING - void declaration
     */
    public void buildDatabase() {
        String string;
        Name2dirs_ = new HashMap<String, Object>(1000);
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>(20);
        Dotsdot_ = new ArrayList<String>(20);
        damncats_ = false;
        String string2 = string = System.getProperty("java.version").startsWith("1.5") ? System.getenv(ENV_MANPATH) : null;
        if (string == null) {
            string = "/usr/man:/usr/share/man:/usr/local/man:/opt/local/man";
        }
        if (string == null) {
            warnings_ = "No MANPATH set.";
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        mancnt_ = 0;
        String string3 = "/multivalent/Multivalent.class";
        String string4 = this.getClass().getResource(string3).getFile();
        string4 = string4.substring(0, string4.lastIndexOf(string3));
        boolean bl = File.pathSeparatorChar == ';';
        System.out.println(new StringBuffer().append("syspfx = ").append(string4).toString());
        ArrayList<String> arrayList = new ArrayList<String>(50);
        ArrayList<String> arrayList2 = new ArrayList<String>(100);
        long l = System.currentTimeMillis();
        long l2 = l - 2592000000L;
        boolean bl2 = Booleans.parseBoolean(this.getPreference(PREF_RECENT, "true"), true);
        ArrayList<String> arrayList3 = new ArrayList<String>(20);
        for (String string5 : string.split(File.pathSeparator)) {
            void object;
            void var18_22;
            String string6 = string5.replace('\\', '/');
            if (string6.startsWith("systemresource:")) {
                String string7 = new StringBuffer().append(string4).append(string6.substring("systemresource:".length())).toString();
            }
            if (var18_22.endsWith("/") && var18_22.length() > 1) {
                String string8 = var18_22.substring(0, var18_22.length() - 1);
            }
            File file = new File((String)object);
            System.out.println(new StringBuffer().append("reading ").append(file).toString());
            if (!file.isAbsolute()) {
                stringBuffer.append((String)object).append(" -- not absolute path.\n");
                continue;
            }
            if (!file.exists()) {
                stringBuffer.append((String)object).append(" -- doesn't exist!\n");
                continue;
            }
            if (!object.endsWith("/man") && new File(file, "man").exists()) {
                file = new File(file, "man");
            }
            if (!file.canRead()) {
                stringBuffer.append((String)object).append(" -- not readable!\n");
                continue;
            }
            if (!file.isDirectory()) {
                stringBuffer.append((String)object).append(" -- not a directory.\n");
                continue;
            }
            String string9 = null;
            try {
                string9 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (arrayList3.indexOf(string9) != -1) continue;
            arrayList3.add(string9);
            File[] fileArray = file.listFiles();
            int n = 0;
            int n2 = 0;
            for (File file2 : fileArray) {
                int n3;
                String string10 = file2.getPath().replace('\\', '/');
                String string11 = file2.getName();
                if (string11.length() <= 3 || !file2.isDirectory()) continue;
                if (string11.startsWith("cat")) {
                    damncats_ = true;
                    continue;
                }
                if (!string11.startsWith("man")) continue;
                ++n;
                String string12 = string11.substring(3);
                if (string12.startsWith(".")) {
                    string12 = string12.substring(1);
                }
                boolean bl3 = file2.lastModified() > l2 || bl;
                String[] stringArray = file2.list();
                int n4 = n3 = stringArray == null ? 0 : stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    Collection<String> collection;
                    Object object2;
                    ++n2;
                    String string13 = stringArray[i];
                    if (bl2 && bl3 && new File(file2, string13).lastModified() > l2) {
                        arrayList2.add(string13);
                    }
                    if (Files.isBackup(string13)) continue;
                    int n5 = string13.length();
                    if (Files.isCompressed(string13)) {
                        n5 = string13.lastIndexOf(46, n5 - 1);
                    }
                    if ((n5 = string13.lastIndexOf(46, n5 - 1)) == -1) continue;
                    if ((string13 = string13.substring(0, n5)).indexOf(46) != -1) {
                        Dotsdot_.add(string13);
                    }
                    if ((object2 = Name2dirs_.get(string13)) == null) {
                        Name2dirs_.put(string13, string10);
                    } else if (object2 instanceof String) {
                        collection = new ArrayList<String>(2);
                        collection.add((String)object2);
                        collection.add(string10);
                        Name2dirs_.put(string13, collection);
                    } else {
                        collection = (ArrayList<String>)object2;
                        collection.add(string10);
                    }
                    collection = (Set)hashMap.get(string12);
                    if (collection != null) {
                        collection.add(string13);
                        continue;
                    }
                    collection = new HashSet(200);
                    hashMap.put(string12, collection);
                    collection.add(string13);
                }
            }
            if (n == 0) {
                stringBuffer.append((String)object).append(" -- no manN subdirectories.");
                stringBuffer.append("\n");
                continue;
            }
            if (n2 == 0) {
                stringBuffer.append((String)object).append(" -- contains no man pages.\n");
                continue;
            }
            arrayList.add(string9);
            mancnt_ += n2;
        }
        String[] stringArray = new String[]{};
        Vol2names_ = new HashMap<String, String[]>(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            String[] stringArray2 = ((Set)entry.getValue()).toArray(stringArray);
            Arrays.sort(stringArray2, String.CASE_INSENSITIVE_ORDER);
            Vol2names_.put((String)entry.getKey(), stringArray2);
        }
        validpaths_ = arrayList.toArray(stringArray);
        manpath_ = arrayList3.toArray(stringArray);
        recent_ = bl2 ? arrayList2.toArray(stringArray) : null;
        warnings_ = stringBuffer.toString();
        fdb_ = true;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.configure();
    }

    public static void main(String[] stringArray) {
        ManualPageVolume manualPageVolume = new ManualPageVolume();
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        runtime.gc();
        long l = runtime.freeMemory();
        long l2 = System.currentTimeMillis();
        manualPageVolume.buildDatabase();
        long l3 = System.currentTimeMillis();
        runtime.gc();
        runtime.gc();
        long l4 = runtime.freeMemory();
        try {
            String string;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("~/tmp/manpage.txt"));
            bufferedWriter.write("*** VOL => PAGES ***");
            bufferedWriter.newLine();
            int n = 0;
            for (Map.Entry<String, String[]> entry : Vol2names_.entrySet()) {
                string = entry.getKey();
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                String[] stringArray2 = entry.getValue();
                n += stringArray2.length;
                int n2 = stringArray2.length;
                for (int i = 0; i < n2; ++i) {
                    bufferedWriter.write("   ");
                    bufferedWriter.write(stringArray2[i]);
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.write("*** PAGE => DIRS ***");
            bufferedWriter.newLine();
            for (Map.Entry<String, Object> entry : Name2dirs_.entrySet()) {
                string = entry.getKey();
                bufferedWriter.write(string);
                bufferedWriter.write("   ");
                bufferedWriter.write(entry.getValue().toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.write("*** STATS ***");
            bufferedWriter.newLine();
            bufferedWriter.write(new StringBuffer().append("Page count: ").append(n).toString());
            bufferedWriter.newLine();
            bufferedWriter.write(new StringBuffer().append("Memory use: ").append(l4 - l).toString());
            bufferedWriter.newLine();
            bufferedWriter.write(new StringBuffer().append("Time (ms): ").append(l3 - l2).toString());
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

