/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import com.pt.awt.NFont;
import com.pt.awt.font.CMap;
import com.pt.awt.font.Encoding;
import com.pt.awt.font.NFontManager;
import com.pt.awt.font.NFontSimple;
import java.io.IOException;
import multivalent.Behavior;
import multivalent.INode;
import multivalent.MediaAdaptor;
import multivalent.node.IParaBox;
import multivalent.node.IVBox;
import multivalent.node.LeafUnicode;
import multivalent.std.span.FontSpan;
import phelps.lang.Strings;
import phelps.net.URIs;

public class FontSampler
extends MediaAdaptor {
    static final boolean DEBUG = false;

    public Object parse(INode iNode) throws IOException {
        NFont nFont = null;
        try {
            nFont = NFontManager.createFont(URIs.toURL(this.getURI()), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IVBox iVBox = new IVBox("font", null, iNode);
        if (nFont == null) {
            return new LeafUnicode("unknown font format", null, iVBox);
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<html><head><style>background: white;</style></head>");
        stringBuffer.append("<h2>Info</h2>\n");
        stringBuffer.append("<ul>\n");
        stringBuffer.append("<li><b>Name:</b> ").append(nFont.getName());
        stringBuffer.append("<li><b>Family:</b> ").append(nFont.getFamily());
        stringBuffer.append("<li><b>Format:</b> ").append(nFont.getFormat());
        stringBuffer.append("<li><b># glyphs:</b> ").append(nFont.getNumGlyphs());
        stringBuffer.append("</ul>\n");
        stringBuffer.append("<h2>Sampler</h2>\n");
        IParaBox iParaBox = new IParaBox("sampler", null, iVBox);
        nFont = ((NFontSimple)nFont).deriveFont(Encoding.IDENTITY, CMap.IDENTITY);
        int n = Math.min(nFont.getMaxGlyphNum(), 4096);
        for (int i = 0; i < n; ++i) {
            if (!nFont.canDisplayEchar(i)) continue;
            new LeafUnicode(Strings.valueOf((char)i), null, iParaBox);
        }
        FontSpan fontSpan = (FontSpan)Behavior.getInstance("font", "multivalent.std.span.FontSpan", null, this.getLayer());
        nFont = nFont.deriveFont(24.0f);
        fontSpan.size = 24.0f;
        fontSpan.spot = nFont;
        fontSpan.moveq(iParaBox.getFirstLeaf(), 0, iParaBox.getLastLeaf(), iParaBox.getLastLeaf().size());
        return iVBox;
    }
}

