/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.CursorMark;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.gui.VCheckbox;
import multivalent.node.LeafImage;
import multivalent.std.span.HyperlinkSpan;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideShowLinks
extends Behavior {
    public static final String MSG_START = "slideShowLinks";
    public static final String MSG_SETAUTO = "slideshowSetAuto";
    public static final String SLIDESHOWNAME = "SLIDESHOW";
    int interval_;
    boolean auto_ = true;
    private boolean skip_ = false;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (SLIDESHOWNAME.equals(browser.getName())) {
            if ("createWidget/Toolbar" == string) {
                VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Auto", "event slideshowSetAuto", (INode)semanticEvent.getOut(), null, false);
                vCheckbox.setState(this.auto_);
            }
        } else if ("createWidget/Go" == string) {
            this.createUI("button", "Slide Show of Links", "event slideShowLinks", (INode)semanticEvent.getOut(), "GoPan", false);
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if (!SLIDESHOWNAME.equals(browser.getName())) {
            if (MSG_START == string) {
                List<Object> list;
                Object object = semanticEvent.getArg();
                List<Object> list2 = list = object instanceof List ? (List<Object>)object : this.collectLinks();
                if (list.size() > 0) {
                    Browser browser2 = this.getGlobal().getBrowser(SLIDESHOWNAME);
                    browser2.eventq("openDocuments", list);
                    browser2.eventq("forwardDocument", null);
                }
            }
        } else if (MSG_SETAUTO == string) {
            Object object = semanticEvent.getArg();
            if (object == null) {
                this.auto_ = !this.auto_;
            }
        } else if ("formattedDocument" == string) {
            // empty if block
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    List<Object> collectLinks() {
        Node node;
        Browser browser = this.getBrowser();
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        Leaf leaf = null;
        Leaf leaf2 = null;
        Span span = browser.getSelectionSpan();
        CursorMark cursorMark = browser.getCursorMark();
        if (span.isSet()) {
            leaf = span.getStart().leaf;
            leaf2 = span.getEnd().leaf;
        } else if (cursorMark.isSet()) {
            leaf = cursorMark.getMark().leaf;
            node = leaf.getDocument();
            leaf2 = node != null ? ((INode)node).getLastLeaf().getNextLeaf() : null;
        } else {
            node = browser.getCurDocument();
            if (node != null) {
                leaf = ((INode)node).getFirstLeaf();
                leaf2 = ((INode)node).getLastLeaf().getNextLeaf();
            } else {
                leaf = browser.getRoot().getFirstLeaf();
                leaf2 = null;
            }
        }
        for (node = leaf; node != null && node != leaf2; node = node.getNextLeaf()) {
            int n = node.sizeSticky();
            for (int i = 0; i < n; ++i) {
                HyperlinkSpan hyperlinkSpan;
                Object object;
                Mark mark = node.getSticky(i);
                Object object2 = mark.getOwner();
                if (!(object2 instanceof HyperlinkSpan) || arrayList.indexOf(object = (hyperlinkSpan = (HyperlinkSpan)object2).getTarget()) != -1) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    @Override
    public boolean eventBefore(AWTEvent aWTEvent, Point point, Node node) {
        int n = aWTEvent.getID();
        if (super.eventBefore(aWTEvent, point, node)) {
            return true;
        }
        if (n == 500) {
            Browser browser = this.getBrowser();
            if (browser.getCurNode() instanceof LeafImage) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                this.getBrowser().eventq(mouseEvent.getButton() == 1 ? "forwardDocument" : "backwardDocument", null);
                return true;
            }
        } else if (n == 401) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            int n2 = keyEvent.getKeyCode();
            Browser browser = this.getBrowser();
            if (n2 == 37 || n2 == 112 || n2 == 98) {
                browser.eventq("backwardDocument", null);
                this.skip_ = true;
                return true;
            }
            if (n2 == 39 || n2 == 110 || n2 == 102) {
                browser.eventq("forwardDocument", null);
                this.skip_ = true;
                return true;
            }
            if (n2 == 38 || n2 == 97) {
                browser.eventq(MSG_SETAUTO, null);
                return true;
            }
        }
        return false;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.interval_ = Integers.parseInt(this.getAttr("intervalms"), 3000);
        Browser browser = this.getBrowser();
        if (SLIDESHOWNAME.equals(browser.getName())) {
            this.getRoot().addObserver(this);
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    if (SlideShowLinks.this.skip_) {
                        SlideShowLinks.this.skip_ = false;
                    } else if (SlideShowLinks.this.auto_) {
                        SlideShowLinks.this.getBrowser().eventq("forwardDocument", null);
                    }
                }
            };
            this.getGlobal().getTimer().schedule(timerTask, 2000L, (long)this.interval_);
        }
    }
}

