/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.FileList;
import com.pt.io.FileLogRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import phelps.io.Files;
import phelps.io.InputStreams;
import phelps.net.URIs;
import phelps.util.Arrayss;

public class FileLog {
    public static final String ACTION_REPORT = "report";
    public static final String ACTION_SAME = "same";
    public static final String ACTION_NEW = "new";
    public static final String ACTION_MOVED = "moved";
    public static final String ACTION_DELETED = "deleted";
    public static final String ACTION_CHANGED = "changed";
    public static final String ACTION_DUPLICATE = "duplicate";
    public static final String ATTR_TIME_FULL = "time-full";
    public static final String ATTR_TIME_UPDATE = "time-update";
    public static final String ATTR_TIME_SPOT_CHECK = "time-spot-check";
    private static final int VERSION = 2;
    private File log_;
    private String[] path_;
    private int[] cnt_;
    private boolean frecurse_;
    private boolean fhash_;
    private boolean fsecure_;
    private int dataversion_;
    private long lastmod_;
    private Map<String, FileLogRecord> db_;
    private Map<String, String> attr_ = new HashMap<String, String>(13);
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileLog(File file, String[] stringArray, boolean bl, int n) {
        this.log_ = file;
        this.path_ = stringArray != null ? stringArray : new String[]{};
        this.cnt_ = new int[this.path_.length];
        this.frecurse_ = bl;
        this.fhash_ = true;
        this.fsecure_ = false;
        this.dataversion_ = n;
        this.lastmod_ = 0L;
        try {
            this.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addPath(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.path_ = Arrayss.resize(this.path_, this.path_.length + 1);
        this.cnt_ = Arrayss.resize(this.cnt_, this.cnt_.length + 1);
        this.path_[this.path_.length - 1] = string;
    }

    public void setHash(boolean bl) {
        this.fhash_ = bl;
    }

    public void setHighSecurity(boolean bl) {
        this.fsecure_ = bl;
        if (bl) {
            this.fhash_ = true;
        }
    }

    private void read() throws IOException {
        String string;
        InputStream inputStream;
        File file;
        this.db_ = new LinkedHashMap<String, FileLogRecord>(200);
        File file2 = this.log_;
        if (file2 == null) {
            return;
        }
        String string2 = file2.getName();
        boolean bl = string2.endsWith(".gz");
        if (!file2.canRead() && (file = new File(file2.getParentFile(), bl ? Files.getRoot(string2) : string2 + ".gz")).canRead()) {
            inputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            InputStreams.copy(bl ? inputStream : new GZIPInputStream(inputStream), bl ? new GZIPOutputStream(fileOutputStream) : fileOutputStream, true);
            if (file2.canRead()) {
                file.delete();
            } else {
                file2 = file;
            }
        }
        if (!file2.canRead() || file2.length() < 20L) {
            return;
        }
        this.lastmod_ = file2.lastModified();
        int n = 0;
        inputStream = new FileInputStream(file2);
        if (bl) {
            inputStream = new GZIPInputStream(inputStream);
        }
        boolean bl2 = this.cnt_.length == 0;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n2 = -1;
        while ((string = bufferedReader.readLine()) != null && (this.lastmod_ > 0L || bl2)) {
            int n3;
            if (string.startsWith("path:")) {
                String string3 = string.substring("path: ".length());
                n3 = string3.indexOf(32);
                int n4 = -1;
                try {
                    n4 = Integer.parseInt(string3.substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string3 = URIs.decode(string3.substring(n3 + 1));
                ++n;
                n3 = Arrayss.indexOf(this.path_, string3);
                if (n3 != -1) {
                    this.cnt_[n3] = n4;
                    continue;
                }
                this.lastmod_ = -3L;
                continue;
            }
            if (string.startsWith("version: ")) {
                try {
                    n2 = Integer.parseInt(string.substring("version: ".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (2 == n2) continue;
                this.lastmod_ = -1L;
                continue;
            }
            if (string.startsWith("dataversion: ")) {
                try {
                    int n5 = Integer.parseInt(string.substring("dataversion: ".length()));
                    if (n5 >= this.dataversion_) continue;
                    this.lastmod_ = -2L;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            n3 = string.indexOf(" ");
            if (n3 > 0 && string.charAt(n3 - 1) == ':') {
                this.attr_.put(string.substring(0, n3 - 1), string.substring(n3 + 1));
                continue;
            }
            if (string.length() < 10) continue;
            try {
                FileLogRecord fileLogRecord = new FileLogRecord(string, n2);
                this.db_.put(fileLogRecord.path, fileLogRecord);
            }
            catch (Exception exception) {}
        }
        bufferedReader.close();
        if (this.lastmod_ >= 0L && n != this.path_.length) {
            this.lastmod_ = -4L;
        }
        if (this.lastmod_ < 0L && !bl2) {
            this.db_.clear();
        }
    }

    public void write() throws IOException {
        if (this.log_ == null) {
            return;
        }
        OutputStream outputStream = new FileOutputStream(this.log_);
        if (this.log_.getName().endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.write("version: 2");
        bufferedWriter.newLine();
        bufferedWriter.write("dataversion: " + this.dataversion_);
        bufferedWriter.newLine();
        int n = this.path_.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = new File(this.path_[i]).list();
            int n2 = stringArray != null ? stringArray.length : 0;
            bufferedWriter.write("path: " + n2 + " " + URIs.encode(this.path_[i]));
            bufferedWriter.newLine();
        }
        this.attr_.put(this.attr_.get("create") == null ? "create" : "update", new Date().toString());
        Iterator<Object> iterator = this.attr_.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            bufferedWriter.write(entry.getKey() + ": " + entry.getValue());
            bufferedWriter.newLine();
        }
        iterator = this.db_.values().iterator();
        while (iterator.hasNext()) {
            bufferedWriter.write(((FileLogRecord)iterator.next()).toString());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    public void update(Observer observer, FileFilter fileFilter) throws IOException {
        FileLogRecord fileLogRecord;
        Iterator iterator;
        Object object;
        HashMap<Long, Object> hashMap;
        int n = this.db_.size();
        long l = System.currentTimeMillis();
        Map map = (Map)((HashMap)this.db_).clone();
        if (this.fhash_) {
            hashMap = new HashMap<Long, Object>(this.db_.size() * 4 / 3);
            object = this.db_.values().iterator();
            while (object.hasNext()) {
                iterator = (FileLogRecord)object.next();
                hashMap.put(new Long(((FileLogRecord)((Object)iterator)).hash), iterator);
            }
        } else {
            hashMap = null;
        }
        object = new FileList(this.path_, fileFilter);
        ((FileList)object).setRecurse(this.frecurse_);
        iterator = ((FileList)object).iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            fileLogRecord = new FileLogRecord(iterator.next());
            String string = fileLogRecord.path;
            FileLogRecord fileLogRecord2 = this.db_.get(string);
            if (fileLogRecord2 == null) {
                this.db_.put(string, fileLogRecord);
                if (this.fhash_) {
                    fileLogRecord.computeHash();
                }
                if (this.fhash_ && fileLogRecord.length > 1L && (fileLogRecord2 = (FileLogRecord)hashMap.get(new Long(fileLogRecord.hash))) != null) {
                    if (new File(fileLogRecord2.path).exists()) {
                        objectArray = new Object[]{ACTION_DUPLICATE, fileLogRecord2, fileLogRecord};
                    } else {
                        fileLogRecord.data = fileLogRecord2.data;
                        this.db_.remove(fileLogRecord2.path);
                        map.remove(fileLogRecord2.path);
                        objectArray = new Object[]{ACTION_MOVED, fileLogRecord2, fileLogRecord};
                    }
                } else {
                    if (this.fhash_) {
                        hashMap.put(new Long(fileLogRecord.hash), fileLogRecord);
                    }
                    objectArray = new Object[]{ACTION_NEW, fileLogRecord};
                }
            } else {
                map.remove(string);
                if (this.fsecure_) {
                    fileLogRecord.computeHash();
                } else {
                    fileLogRecord.hash = fileLogRecord2.hash;
                }
                if (fileLogRecord2.mod == fileLogRecord.mod && fileLogRecord2.length == fileLogRecord.length && fileLogRecord2.hash == fileLogRecord.hash) {
                    objectArray = new Object[]{ACTION_SAME, fileLogRecord2};
                } else {
                    fileLogRecord.data = fileLogRecord2.data;
                    this.db_.remove(fileLogRecord2);
                    this.db_.put(string, fileLogRecord);
                    objectArray = new Object[]{ACTION_CHANGED, fileLogRecord2, fileLogRecord};
                }
            }
            if (observer == null) continue;
            observer.update(null, objectArray);
        }
        if (observer != null) {
            iterator = map.values().iterator();
            while (iterator.hasNext()) {
                fileLogRecord = (FileLogRecord)iterator.next();
                this.db_.remove(fileLogRecord.path);
                observer.update(null, new Object[]{ACTION_DELETED, fileLogRecord});
            }
        }
        this.lastmod_ = System.currentTimeMillis();
        this.putAttr(n == 0 ? ATTR_TIME_FULL : ATTR_TIME_UPDATE, Long.toString(this.lastmod_ - l));
    }

    public void report(Observer observer) {
        if (observer != null) {
            Iterator<FileLogRecord> iterator = this.db_.values().iterator();
            while (iterator.hasNext()) {
                observer.update(null, new Object[]{ACTION_REPORT, iterator.next()});
            }
        }
    }

    public void report(Observer observer, FileFilter fileFilter, long l) throws IOException {
        boolean bl = true;
        if (this.log_ != null && this.lastmod_ != 0L && this.lastmod_ > 0L && l > 0L) {
            bl = false;
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastmod_ > l) {
                bl = true;
            }
            int n = this.path_.length;
            for (int i = 0; !bl && i < n; ++i) {
                int n2;
                File file = new File(this.path_[i]);
                if (!file.canRead()) continue;
                if (file.lastModified() > this.lastmod_) {
                    bl = true;
                    continue;
                }
                String[] stringArray = file.list();
                int n3 = n2 = stringArray != null ? stringArray.length : 0;
                if (n2 == this.cnt_[i]) continue;
                bl = true;
            }
            this.putAttr(ATTR_TIME_SPOT_CHECK, Long.toString(System.currentTimeMillis() - l2));
        }
        if (bl) {
            this.update(observer, fileFilter);
        } else {
            this.report(observer);
        }
    }

    public FileLogRecord getRecord(File file) {
        return this.db_.get(file.toString());
    }

    public void addRecord(FileLogRecord fileLogRecord) {
        this.db_.put(fileLogRecord.path, fileLogRecord);
    }

    public Iterator iterator() {
        return this.db_.values().iterator();
    }

    public long lastModified() {
        return this.lastmod_;
    }

    public String getAttr(String string) {
        return this.attr_.get(string);
    }

    public String putAttr(String string, String string2) {
        return this.attr_.put(string, string2);
    }

    static {
        $assertionsDisabled = !FileLog.class.desiredAssertionStatus();
    }
}

