/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.NFont;
import com.pt.lang.UnicodeBlocks;
import java.io.File;
import java.net.URL;
import phelps.io.Files;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFontRec
implements Comparable<NFontRec> {
    public static final String STATUS_ACTIVE = "Active";
    public static final String STATUS_DUP = "Duplicate";
    public static final String STATUS_UNSUPPORTED = "Unsupported";
    public static final String STATUS_BAD = "Bad";
    public static final String STATUS_PDF = "PDF";
    private String name_;
    private String family_;
    private int weight_;
    private int flags_;
    private URL source_;
    private long mod_;
    private int num_;
    private String format_;
    private String subformat_;
    private String version_;
    private String designer_;
    private String copyright_;
    private int glyphs_;
    private UnicodeBlocks[] blocks_;
    private int variations_;
    private int score_;
    private String status_;
    private String msg_;
    private NFont cache_;

    public NFontRec(String string, String string2, int n, int n2, int n3, int n4, UnicodeBlocks[] unicodeBlocksArray, URL uRL, long l, String string3, String string4, int n5, String string5, String string6, String string7) {
        this.name_ = string;
        this.family_ = string2;
        this.variations_ = n;
        this.weight_ = n2;
        this.flags_ = n3;
        this.format_ = string3.intern();
        this.subformat_ = string4 != null ? string4.intern() : "";
        this.glyphs_ = n4;
        this.version_ = string5;
        this.designer_ = string6;
        this.copyright_ = string7;
        this.source_ = uRL;
        this.mod_ = l;
        this.num_ = n5;
        this.blocks_ = unicodeBlocksArray;
        this.status_ = STATUS_ACTIVE;
        this.msg_ = null;
    }

    NFontRec(URL uRL, long l, String string, String string2) {
        this.source_ = uRL;
        this.mod_ = l;
        this.status_ = string.intern();
        this.msg_ = string2;
        String string3 = uRL.toString();
        int n = string3.lastIndexOf(47);
        if (n != -1) {
            string3 = string3.substring(n + 1);
        }
        this.name_ = string3;
    }

    NFontRec(NFont nFont, String string, int n, int n2, UnicodeBlocks unicodeBlocks) {
        this.cache_ = nFont;
        this.family_ = string;
        this.weight_ = n;
        this.flags_ = n2;
        this.blocks_ = new UnicodeBlocks[]{unicodeBlocks, UnicodeBlocks.NONE, UnicodeBlocks.NONE};
    }

    public String getName() {
        return this.name_;
    }

    public String getFamily() {
        return this.family_;
    }

    public int getWeight() {
        return this.weight_;
    }

    public int getFlags() {
        return this.flags_;
    }

    public URL getSource() {
        return this.source_;
    }

    public String getSourceShort() {
        String string = this.getSource().toString();
        if (string.startsWith("file:")) {
            string = Files.shortpath(null, new File(string.substring("file:".length())));
        }
        return string;
    }

    public long getLastModified() {
        return this.mod_;
    }

    public int getNum() {
        return this.num_;
    }

    public String getFormat() {
        return this.format_;
    }

    public String getSubformat() {
        return this.subformat_;
    }

    public String getVersion() {
        return this.version_;
    }

    public String getDesigner() {
        return this.designer_;
    }

    public String getCopyright() {
        return this.copyright_;
    }

    public int getNumGlyphs() {
        return this.glyphs_;
    }

    public UnicodeBlocks[] getUnicode() {
        return this.blocks_;
    }

    public UnicodeBlocks getUnicodeExist() {
        return this.blocks_[0];
    }

    public UnicodeBlocks getUnicodeCoverage() {
        return this.blocks_[1];
    }

    public UnicodeBlocks getUnicodeFull() {
        return this.blocks_[2];
    }

    public int getFamilySize() {
        return this.variations_;
    }

    public String getStatus() {
        return this.status_;
    }

    public String getMessage() {
        return this.msg_;
    }

    void setScore(int n) {
        this.score_ = n;
    }

    public int getScore() {
        return this.score_;
    }

    public void setStatus(String string, String string2) {
        this.status_ = string;
        this.msg_ = string2;
    }

    void setFamilySize(int n) {
        this.variations_ = n;
    }

    void setCache(NFont nFont) {
        this.cache_ = nFont;
    }

    NFont getCache() {
        return this.cache_;
    }

    public int quality() {
        int n = 0;
        n += this.getNumGlyphs();
        if ("OpenType" == this.format_) {
            n += 20;
        } else if ("TrueType" == this.format_) {
            n += 15;
        } else if ("Type1" == this.format_ && ("PFB" == this.subformat_ || "PFB/IBM" == this.subformat_)) {
            ++n;
        }
        return n;
    }

    @Override
    public int compareTo(NFontRec nFontRec) {
        return -(this.score_ - nFontRec.score_);
    }

    public String toString() {
        return new StringBuffer().append(this.name_).append(" ").append(this.family_).append(" ").append(NFont.strFlags(this.flags_)).append(" / ").append(this.num_).append(" / ").append(this.source_).toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((NFontRec)object);
    }
}

